/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomworklists.mwl;

import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.interfaces.IPatientIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ImagingServiceRequestModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.RequestedProcedureModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ScheduledProcedureStep;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ScheduledStepAttribute;
import com.agfa.pacs.listtext.dicomworklists.mwl.ModalityWorkItem;
import java.util.Date;
import org.dcm4che3.util.UIDUtils;

public class SimpleWorkItem
extends ModalityWorkItem {
    private RequestedProcedureModule requestedProcedure;
    private ImagingServiceRequestModule imagingServiceRequest;
    private ScheduledProcedureStep scheduledProcedureStep;
    private IPatientIdentifier patient;

    public SimpleWorkItem(IPatientIdentifier iPatientIdentifier, RequestedProcedureModule requestedProcedureModule, ScheduledProcedureStep scheduledProcedureStep, ImagingServiceRequestModule imagingServiceRequestModule) {
        this.patient = iPatientIdentifier;
        this.requestedProcedure = requestedProcedureModule;
        this.scheduledProcedureStep = scheduledProcedureStep;
        this.imagingServiceRequest = imagingServiceRequestModule;
        this.init();
    }

    @Override
    protected void init() {
        Date date = new Date();
        this.mpps.setSOPClassUID("1.2.840.10008.3.1.2.3.3");
        this.mpps.setSOPInstanceUID(UIDUtils.createUID());
        this.mpps.getRelationship().setPatientName(this.patient.getPatientName());
        this.mpps.getRelationship().setPatientID(this.patient.getPatientID());
        this.mpps.getRelationship().setPatientSex(this.patient.getPatientSex());
        this.mpps.getRelationship().setPatientBirthDate(this.patient.getPatientBirthDate());
        this.mpps.getRelationship().setIssuerOfPatientID(this.patient.getIssuerOfPatientID());
        this.mpps.getRelationship().setAdmissionID(this.imagingServiceRequest.getAdmissionID());
        this.mpps.getRelationship().setIssuerOfAdmissionID(this.imagingServiceRequest.getIssuerOfAdmissionID());
        ScheduledStepAttribute scheduledStepAttribute = new ScheduledStepAttribute();
        scheduledStepAttribute.setAccessionNumber(this.imagingServiceRequest.getAccessionNumber());
        scheduledStepAttribute.setFillerOrderNumber(this.imagingServiceRequest.getFillerOrderNumber());
        scheduledStepAttribute.setPlacerOrderNumber(this.imagingServiceRequest.getPlacerOrderNumber());
        if (!this.requestedProcedure.referencededStudies().isEmpty()) {
            scheduledStepAttribute.setReferencedStudy((ReferencedSOP)this.requestedProcedure.referencededStudies().get(0));
        }
        scheduledStepAttribute.setRequestedProcedureID(this.requestedProcedure.getID());
        scheduledStepAttribute.setRequestedProcedureCode(this.requestedProcedure.getCode());
        scheduledStepAttribute.setRequestedProcedureDescription(this.requestedProcedure.getDescription());
        scheduledStepAttribute.setStudyInstanceUID(this.requestedProcedure.getStudyInstanceUID());
        scheduledStepAttribute.setScheduledProcedureStepDescription(this.scheduledProcedureStep.getDescription());
        scheduledStepAttribute.setScheduledProcedureStepID(this.scheduledProcedureStep.getID());
        scheduledStepAttribute.scheduledProtocol().addAll(this.scheduledProcedureStep.protocols());
        this.mpps.getRelationship().scheduledStepAttributes().add(scheduledStepAttribute);
        this.mpps.getInformation().setID("1");
        this.mpps.getInformation().setStationAETitle(this.scheduledProcedureStep.getStationAETitle());
        this.mpps.getInformation().setLocation(this.scheduledProcedureStep.getLocation());
        this.mpps.getInformation().setStationName(this.scheduledProcedureStep.getStationName());
        this.mpps.getInformation().setProcedureCode(this.requestedProcedure.getCode());
        this.mpps.getResults().setStudyID(this.requestedProcedure.getID());
        this.mpps.getResults().performedProtocol().addAll(this.scheduledProcedureStep.protocols());
        this.mpps.getInformation().setStartDate(date);
        this.mpps.getInformation().setStartTime(date);
    }
}

