/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomworklists.mwl;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.listtext.dicomobject.general.PersonIdentification;
import com.agfa.pacs.listtext.dicomobject.module.mwl.BillingAndMaterialManagementCodeModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.PerformedSeries;
import com.agfa.pacs.listtext.dicomobject.module.mwl.RadiationDoseModule;
import com.agfa.pacs.listtext.dicomobject.module.series.GeneralSeriesModule;
import com.agfa.pacs.listtext.dicomobject.module.series.Protocol;
import com.agfa.pacs.listtext.dicomobject.mwl.MPPS;
import com.agfa.pacs.listtext.dicomobject.type.ProcedureStepStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class ModalityWorkItem {
    protected MPPS mpps = new MPPS();
    protected List<PersonIdentification> operatorsIdentification = new ArrayList<PersonIdentification>();
    protected List<String> operatorNames = new ArrayList<String>();
    protected String protocolName;
    private IDicomNode dicomNode;

    public IDicomNode getDicomNode() {
        return this.dicomNode;
    }

    public void setDicomNode(IDicomNode iDicomNode) {
        this.dicomNode = iDicomNode;
    }

    protected abstract void init();

    public MPPS getPerformedProcedureStep() {
        return this.mpps;
    }

    public List<PerformedSeries> performedSeries() {
        return this.mpps.getResults().performedSeries();
    }

    public List<Protocol> performedProtocols() {
        return this.mpps.getResults().performedProtocol();
    }

    public BillingAndMaterialManagementCodeModule getBilling() {
        return this.mpps.getBilling();
    }

    public RadiationDoseModule getRadiationDose() {
        return this.mpps.getRadiationDose();
    }

    public void setStart(Date date) {
        this.mpps.getInformation().setStartDate(date);
        this.mpps.getInformation().setStartTime(date);
    }

    public void setEnd(Date date) {
        this.mpps.getInformation().setEndDate(date);
        this.mpps.getInformation().setEndTime(date);
    }

    public void setComments(String string) {
        this.mpps.getInformation().setComments(string);
    }

    public void setDescription(String string) {
        this.mpps.getInformation().setDescription(string);
    }

    public void setTypeDescription(String string) {
        this.mpps.getInformation().setTypeDescription(string);
    }

    public void setProcedure(Code code) {
        this.mpps.getInformation().setProcedureCode(code);
    }

    public void complete() {
        this.mpps.getInformation().setStatus(ProcedureStepStatus.Completed);
        this.mpps.getInformation().setDiscontinuationReasonCode(null);
    }

    public void discontinue(Code code) {
        this.mpps.getInformation().setStatus(ProcedureStepStatus.Discontinued);
        this.mpps.getInformation().setDiscontinuationReasonCode(code);
    }

    public void setProtocolName(String string) {
        this.protocolName = string;
    }

    public List<String> operatorNames() {
        return this.operatorNames;
    }

    public List<PersonIdentification> operatorsIdentification() {
        return this.operatorsIdentification;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public PerformedSeries createPerformedSeries(GeneralSeriesModule generalSeriesModule) {
        PerformedSeries performedSeries = new PerformedSeries();
        performedSeries.operatorsName().addAll(generalSeriesModule.operatorName());
        performedSeries.operatorsIdentification().addAll(generalSeriesModule.operatorIdentification());
        performedSeries.performingPhysiciansName().addAll(generalSeriesModule.performingPhysicianName());
        performedSeries.performingPhysicianIdentification().addAll(generalSeriesModule.performingPhysicianIdentification());
        performedSeries.setProtocolName(generalSeriesModule.getProtocolName());
        performedSeries.setSeriesDescription(generalSeriesModule.getSeriesDescription());
        performedSeries.setSeriesInstanceUID(generalSeriesModule.getSeriesInstanceUID());
        return performedSeries;
    }
}

