/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomworklists.mwl;

import com.agfa.pacs.listtext.dicomobject.interfaces.IPatientIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ImagingServiceRequestModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.RequestedProcedureModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ScheduledProcedureStep;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ScheduledStepAttribute;
import com.agfa.pacs.listtext.dicomworklists.mwl.ModalityWorkItem;
import java.util.Date;
import java.util.List;
import org.dcm4che3.util.UIDUtils;

public class GroupWorkItem
extends ModalityWorkItem {
    private IPatientIdentifier patient;
    private List<Item> items;
    private String studyInstanceUID;
    private String studyID;

    public GroupWorkItem(IPatientIdentifier iPatientIdentifier, List<Item> list) {
        this.patient = iPatientIdentifier;
        this.items = list;
        this.studyInstanceUID = UIDUtils.createUID();
        this.studyID = "1";
        this.init();
    }

    @Override
    protected void init() {
        Item item2;
        Date date = new Date();
        this.mpps.setSOPClassUID("1.2.840.10008.3.1.2.3.3");
        this.mpps.setSOPInstanceUID(UIDUtils.createUID());
        this.mpps.getRelationship().setPatientName(this.patient.getPatientName());
        this.mpps.getRelationship().setPatientID(this.patient.getPatientID());
        this.mpps.getRelationship().setPatientSex(this.patient.getPatientSex());
        this.mpps.getRelationship().setPatientBirthDate(this.patient.getPatientBirthDate());
        this.mpps.getRelationship().setIssuerOfPatientID(this.patient.getIssuerOfPatientID());
        for (Item item2 : this.items) {
            ScheduledStepAttribute scheduledStepAttribute = new ScheduledStepAttribute();
            scheduledStepAttribute.setAccessionNumber(item2.imagingServiceRequest.getAccessionNumber());
            scheduledStepAttribute.setFillerOrderNumber(item2.imagingServiceRequest.getFillerOrderNumber());
            scheduledStepAttribute.setPlacerOrderNumber(item2.imagingServiceRequest.getPlacerOrderNumber());
            scheduledStepAttribute.setRequestedProcedureID(item2.requestedProcedure.getID());
            scheduledStepAttribute.setRequestedProcedureDescription(item2.requestedProcedure.getDescription());
            scheduledStepAttribute.setStudyInstanceUID(this.studyInstanceUID);
            scheduledStepAttribute.setScheduledProcedureStepDescription(item2.scheduledProcedureStep.getDescription());
            scheduledStepAttribute.setScheduledProcedureStepID(item2.scheduledProcedureStep.getID());
            scheduledStepAttribute.scheduledProtocol().addAll(item2.scheduledProcedureStep.protocols());
            this.mpps.getRelationship().scheduledStepAttributes().add(scheduledStepAttribute);
        }
        item2 = this.items.get((int)0).scheduledProcedureStep;
        this.mpps.getInformation().setStationAETitle(item2.getStationAETitle());
        this.mpps.getInformation().setLocation(item2.getLocation());
        this.mpps.getInformation().setStationName(item2.getStationName());
        this.mpps.getResults().setStudyID(this.studyID);
        this.mpps.getInformation().setStartDate(date);
        this.mpps.getInformation().setStartTime(date);
    }

    private String check(String string, String string2) {
        if (string != null && !string.equals(string2)) {
            return null;
        }
        return string;
    }

    public static class Item {
        protected RequestedProcedureModule requestedProcedure;
        protected ImagingServiceRequestModule imagingServiceRequest;
        protected ScheduledProcedureStep scheduledProcedureStep;

        public Item(RequestedProcedureModule requestedProcedureModule, ImagingServiceRequestModule imagingServiceRequestModule, ScheduledProcedureStep scheduledProcedureStep) {
            this.requestedProcedure = requestedProcedureModule;
            this.imagingServiceRequest = imagingServiceRequestModule;
            this.scheduledProcedureStep = scheduledProcedureStep;
        }
    }
}

