/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail.plaf;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.thumbnail.AbstractThumbnails;
import com.agfa.pacs.listtext.lta.thumbnail.Messages;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailLoader;
import com.agfa.pacs.listtext.lta.thumbnail.plaf.ThumbnailList;
import com.agfa.pacs.listtext.lta.thumbnail.plaf.ThumbnailListModel;
import com.agfa.pacs.listtext.swingx.layout.RowLayout;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.dcm4che3.data.PersonName;

public class ThumbnailsUI
extends ComponentUI {
    protected AbstractThumbnails thumbnail = null;
    protected JLabel patientLabel = null;
    protected JLabel noIconsLabel = null;
    protected JScrollPane scrollPane = null;
    protected JPanel thumbnailPanel = null;
    protected JLayeredPane layeredPane = null;
    protected JPanel contentPanel = null;
    protected Map<ISeriesInfo, ThumbnailList> lists = new Hashtable<ISeriesInfo, ThumbnailList>();
    protected ThumbnailListener previewListener = new ThumbnailListener();
    protected ResizeListener resizeListener = new ResizeListener();
    protected PopupListener popupListener = new PopupListener();
    protected Color headerBackground = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ThumbnailsUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.thumbnail = (AbstractThumbnails)((Object)jComponent);
        this.installDefaults();
        this.createComponents();
        this.installListeners();
        this.installLayout();
        this.initComponents();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallLayout();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.thumbnail = null;
    }

    public void installDefaults() {
        this.headerBackground = UIManager.getColor("controlShadow");
        if (this.headerBackground == null) {
            this.headerBackground = UIManager.getColor("control");
        }
    }

    public void uninstallDefaults() {
        this.headerBackground = null;
    }

    public void createComponents() {
        this.patientLabel = this.createPatientLabel();
        this.noIconsLabel = this.createNoIconsLabel();
        this.layeredPane = new JLayeredPane();
        this.contentPanel = new JPanel();
        this.thumbnailPanel = this.createScrollablePanel(BorderFactory.createEmptyBorder(5, 1, 5, 1));
        this.scrollPane = this.createScrollPane(this.thumbnailPanel);
        this.scrollPane.setVisible(false);
    }

    public void installListeners() {
        this.thumbnail.addPropertyChangeListener(this.previewListener);
        this.layeredPane.addComponentListener(this.resizeListener);
    }

    public void uninstallListeners() {
        this.thumbnail.removePropertyChangeListener(this.previewListener);
        this.layeredPane.removeComponentListener(this.resizeListener);
    }

    protected void initComponents() {
    }

    protected void installLayout() {
        this.thumbnailPanel.setLayout(new BoxLayout(this.thumbnailPanel, 1));
        this.thumbnailPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layeredPane.add(this.scrollPane);
        this.layeredPane.add(this.noIconsLabel);
        this.layeredPane.setLayer(this.scrollPane, 0);
        this.layeredPane.setLayer(this.noIconsLabel, 1);
        this.contentPanel.setLayout(new BorderLayout(0, 10));
        this.contentPanel.add((Component)this.patientLabel, "North");
        this.contentPanel.add((Component)this.layeredPane, "Center");
        this.contentPanel.setBorder(BorderFactory.createLineBorder(this.contentPanel.getBackground().darker()));
        this.thumbnail.setLayout(new BorderLayout());
        this.thumbnail.add(this.contentPanel, "Center");
    }

    public void uninstallLayout() {
        this.thumbnailPanel.removeAll();
        this.layeredPane.removeAll();
        this.contentPanel.removeAll();
        this.thumbnail.removeAll();
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        if (string != null) {
            jLabel.setText(string);
        }
        return jLabel;
    }

    protected JLabel createNoIconsLabel() {
        JLabel jLabel = SwingUtilities2.createLabel((String)this.getNoThumbnailsAvailableText(), null, null, null);
        jLabel.setVerticalAlignment(0);
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        return jLabel;
    }

    protected JLabel createPatientLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(true);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jLabel.setBackground(this.headerBackground);
        return jLabel;
    }

    protected JPanel createScrollablePanel(Border border) {
        class ScrollablePanel
        extends JPanel
        implements Scrollable {
            ScrollablePanel() {
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                return ThumbnailLoader.MAX_ICON_HEIGHT;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
                return 5 * ThumbnailLoader.MAX_ICON_HEIGHT;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }
        }
        ScrollablePanel scrollablePanel = new ScrollablePanel();
        scrollablePanel.setOpaque(false);
        scrollablePanel.setBorder(border);
        return scrollablePanel;
    }

    protected JScrollPane createScrollPane(Component component) {
        return SwingUtilities2.createScrollPane((Component)component, (Integer)20, (Integer)30, (Boolean)true, (Boolean)false);
    }

    protected StudyThumbnailsPanel createStudyThumbnailsPanel(IStudyInfo iStudyInfo, Collection<ISeriesInfo> collection) {
        return new StudyThumbnailsPanel(iStudyInfo, collection, true);
    }

    private void showThumbnails() {
        this.noIconsLabel.setVisible(false);
        this.scrollPane.setVisible(true);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void hideThumbnails(boolean bl) {
        this.noIconsLabel.setText(bl ? this.getInitializingThumbnailsText() : this.getNoThumbnailsAvailableText());
        this.scrollPane.setVisible(false);
        this.noIconsLabel.setVisible(true);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private String getNoThumbnailsAvailableText() {
        return Messages.getString("ThumbnailsUI.NoThumbnailsAvailable");
    }

    private String getInitializingThumbnailsText() {
        return Messages.getString("ThumbnailsUI.Loading");
    }

    private void updatePatient() {
        Collection<IPatientInfo> collection = this.thumbnail.getPatients();
        if (collection == null || collection.isEmpty()) {
            this.patientLabel.setText(Messages.getString("ThumbnailsUI.NoPatientDataAvailable"));
        } else if (collection.size() == 1) {
            IPatientInfo iPatientInfo = collection.iterator().next();
            PersonName personName = null;
            if (iPatientInfo != null) {
                personName = new PersonName(iPatientInfo.getAttributes().getString(0x100010), true);
            }
            this.patientLabel.setText(personName != null ? PersonNameUtilities.personNameToHRShort(personName) : Messages.getString("ThumbnailsUI.NoPatientDataAvailable"));
        } else {
            this.patientLabel.setText(String.valueOf(collection.size()) + " " + Messages.getString("ThumbnailsUI.PatientsSelected"));
        }
        this.patientLabel.revalidate();
        this.patientLabel.repaint();
    }

    private void reset(boolean bl) {
        for (ThumbnailList thumbnailList : this.lists.values()) {
            thumbnailList.removeMouseListener(this.popupListener);
            thumbnailList.dispose();
        }
        this.lists.clear();
        this.thumbnailPanel.removeAll();
        this.thumbnailPanel.scrollRectToVisible(new Rectangle(new Point(0, 0)));
        this.updatePatient();
        this.hideThumbnails(bl);
        this.thumbnail.revalidate();
        this.thumbnail.repaint();
    }

    private void initThumbnails() {
        Collection<IStudyInfo> collection = this.thumbnail.getStudies();
        if (collection == null || collection.isEmpty()) {
            this.reset(false);
        } else {
            for (IStudyInfo iStudyInfo : collection) {
                Collection<ISeriesInfo> collection2 = this.thumbnail.getSeries(iStudyInfo);
                for (ISeriesInfo iSeriesInfo : collection2) {
                    Collection<ThumbnailFrame> collection3 = this.thumbnail.getFrames(iSeriesInfo);
                    ThumbnailListModel thumbnailListModel = new ThumbnailListModel(iSeriesInfo, collection3);
                    ThumbnailList thumbnailList = new ThumbnailList(thumbnailListModel, this.thumbnail, this.thumbnail.createTransferHandler());
                    thumbnailList.addMouseListener(this.popupListener);
                    thumbnailList.setBackground(UIManager.getColor("color.black"));
                    thumbnailList.setBorder(BorderFactory.createLineBorder(this.thumbnailPanel.getBackground().brighter()));
                    this.lists.put(iSeriesInfo, thumbnailList);
                }
                this.thumbnailPanel.add(this.createStudyThumbnailsPanel(iStudyInfo, collection2));
            }
            this.updatePatient();
            this.showThumbnails();
        }
    }

    private void handlePopupRequest(Component component, int n, int n2) {
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        HashMap<String, BitSet> hashMap = new HashMap<String, BitSet>();
        for (ThumbnailList thumbnailList : this.lists.values()) {
            List<ThumbnailFrame> list = thumbnailList.getSelectedThumbnailFrames();
            if (list == null) continue;
            for (ThumbnailFrame thumbnailFrame : list) {
                IObjectInfo iObjectInfo = thumbnailFrame.getObject();
                arrayList.add((IDataInfo)iObjectInfo);
                Integer n3 = thumbnailFrame.getFrameNumber();
                if (n3 == null) continue;
                String string = iObjectInfo.getKey();
                BitSet bitSet = (BitSet)hashMap.get(string);
                if (bitSet == null) {
                    bitSet = new BitSet();
                    hashMap.put(string, bitSet);
                }
                bitSet.set(n3);
            }
        }
        if (!arrayList.isEmpty()) {
            this.thumbnail.handlePopup(arrayList, hashMap, component, n, n2);
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                ThumbnailsUI.this.handlePopupRequest(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getSource() == ThumbnailsUI.this.layeredPane) {
                Insets insets = ThumbnailsUI.this.layeredPane.getInsets();
                int n = ThumbnailsUI.this.layeredPane.getWidth() - insets.left + insets.right;
                int n2 = ThumbnailsUI.this.layeredPane.getHeight() - insets.top - insets.bottom;
                ThumbnailsUI.this.noIconsLabel.setSize(n, n2);
                ThumbnailsUI.this.scrollPane.setSize(n, n2);
                ThumbnailsUI.this.layeredPane.revalidate();
                ThumbnailsUI.this.layeredPane.repaint();
            }
        }
    }

    public class StudyThumbnailsPanel
    extends JPanel {
        private IStudyInfo study;
        private Collection<ISeriesInfo> series;
        private JLabel studyLabel;
        private JPanel thumbnailPanel;
        private boolean showStudyInfo;

        public StudyThumbnailsPanel(IStudyInfo iStudyInfo, Collection<ISeriesInfo> collection, boolean bl) {
            this.study = iStudyInfo;
            this.series = collection;
            this.showStudyInfo = bl;
            this.createComponents();
            this.initComponents();
            this.installLayout();
        }

        private void createComponents() {
            this.studyLabel = new JLabel();
            this.studyLabel.setHorizontalTextPosition(10);
            this.thumbnailPanel = new JPanel();
        }

        private void initComponents() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><u>");
            if (this.study == null) {
                stringBuilder.append(Messages.getString("Thumbnails.NoStudyDataAvailable"));
            } else {
                stringBuilder.append(Messages.getString("Thumbnails.Study"));
                Date date = this.study.getAttributes().getDate(524320);
                if (date != null) {
                    stringBuilder.append(' ');
                    stringBuilder.append(Messages.getString("Thumbnails.from"));
                    stringBuilder.append(' ');
                    stringBuilder.append(DateTimeUtils.date2String((Date)date));
                }
            }
            stringBuilder.append("</u></html>");
            this.studyLabel.setText(stringBuilder.toString());
            this.studyLabel.setVisible(this.showStudyInfo);
            this.study = null;
        }

        private void installLayout() {
            if (this.series != null) {
                this.thumbnailPanel.setLayout((LayoutManager)new RowLayout(2));
                for (ISeriesInfo iSeriesInfo : this.series) {
                    ThumbnailList thumbnailList = ThumbnailsUI.this.lists.get(iSeriesInfo);
                    if (thumbnailList == null) continue;
                    this.thumbnailPanel.add(thumbnailList);
                }
            }
            this.setLayout(new BorderLayout(0, 10));
            this.add((Component)this.studyLabel, "North");
            this.add((Component)this.thumbnailPanel, "Center");
            this.series = null;
        }
    }

    private class ThumbnailListener
    implements PropertyChangeListener {
        private ThumbnailListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("RESET".equals(string)) {
                EventUtil.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ThumbnailsUI.this.reset(false);
                    }
                });
            } else if ("INITIALIZATION_STARTED".equals(string)) {
                try {
                    EventUtil.invokeSynchronous((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ThumbnailsUI.this.reset(true);
                        }
                    });
                }
                catch (Exception exception) {}
            } else if ("INITIALIZATION_FINISHED".equals(string)) {
                EventUtil.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ThumbnailsUI.this.initThumbnails();
                    }
                });
            }
        }
    }
}

