/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ScaledIconWrapper
implements Icon {
    private Icon wrappedIcon;
    private JComponent target;
    private ImageIcon scaledIcon;

    public ScaledIconWrapper(Icon icon, JComponent jComponent) {
        this.wrappedIcon = icon;
        this.target = jComponent;
    }

    public Icon getWrappedIcon() {
        return this.wrappedIcon;
    }

    public JComponent getTargetComponent() {
        return this.target;
    }

    @Override
    public int getIconHeight() {
        return this.wrappedIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.wrappedIcon.getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        ImageIcon imageIcon = this.getScaledIcon(component);
        if (imageIcon != null) {
            imageIcon.paintIcon(component, graphics, n -= (int)((double)(imageIcon.getIconWidth() - this.getIconWidth()) / 2.0 + 0.5), n2 -= (int)((double)(imageIcon.getIconHeight() - this.getIconHeight()) / 2.0 + 0.5));
        }
    }

    private ImageIcon getScaledIcon(Component component) {
        int n = this.getScaledIconWidth();
        int n2 = this.getScaledIconHeight();
        if (n > 0 && n2 > 0 && (this.scaledIcon == null || this.scaledIcon.getIconWidth() != n || this.scaledIcon.getIconHeight() != n2)) {
            BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            this.wrappedIcon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
            this.scaledIcon = new ImageIcon(bufferedImage.getScaledInstance(n, n2, 4));
        }
        return this.scaledIcon;
    }

    private int getScaledIconWidth() {
        int n;
        int n2 = this.getButtonIconWidth();
        if (n2 > (n = this.getButtonIconHeight())) {
            return (int)((double)n / (double)this.getIconHeight() * (double)this.getIconWidth() + 0.5);
        }
        return n2;
    }

    private int getScaledIconHeight() {
        int n = this.getButtonIconWidth();
        int n2 = this.getButtonIconHeight();
        if (n2 > n) {
            return (int)((double)n / (double)this.getIconWidth() * (double)this.getIconHeight() + 0.5);
        }
        return n2;
    }

    private int getButtonIconWidth() {
        return this.target.getWidth() - this.target.getInsets().left - this.target.getInsets().right;
    }

    private int getButtonIconHeight() {
        return this.target.getHeight() - this.target.getInsets().top - this.target.getInsets().bottom;
    }
}

