/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.nimbus.painters;

import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.nimbus.AbstractRegionPainter;

public abstract class AbstractCustomRegionPainter
extends AbstractRegionPainter {
    private static final ALogger log = ALogger.getLogger(AbstractCustomRegionPainter.class);
    private CustomPaintContext ctx;

    protected AbstractCustomRegionPainter(CustomPaintContext customPaintContext) {
        this.ctx = customPaintContext;
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    protected final Color decodeColor(String[] stringArray, float[] fArray, float[] fArray2, float[] fArray3, int[] nArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (UIManager.getLookAndFeelDefaults().getColor(stringArray[n]) != null) {
                return this.decodeColor(stringArray[n], fArray[n], fArray2[n], fArray3[n], nArray[n]);
            }
            ++n;
        }
        return this.decodeColor("nimbusBase", 0.0f, 0.0f, 0.0f, 0);
    }

    public final Color decodeColor(Color color, float f, float f2, float f3, int n) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[0] = this.clamp(fArray[0] + f);
        fArray[1] = this.clamp(fArray[1] + f2);
        fArray[2] = this.clamp(fArray[2] + f3);
        int n2 = this.clamp(color.getAlpha() + n);
        int n3 = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]) & 0xFFFFFF | n2 << 24;
        return new Color(n3);
    }

    public final Color getColor(String ... stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Color color = this.getColor(stringArray[n]);
            if (color != null) {
                return color;
            }
            ++n;
        }
        return null;
    }

    public final Color getColor(String string) {
        return UIManager.getLookAndFeelDefaults().getColor(string);
    }

    private float clamp(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private int clamp(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    public static final class CustomLazyPainter
    implements UIDefaults.LazyValue {
        private int state;
        private CustomPaintContext ctx;
        private Class<? extends AbstractCustomRegionPainter> clazz;

        public CustomLazyPainter(Class<? extends AbstractCustomRegionPainter> clazz, int n, CustomPaintContext customPaintContext) {
            this.clazz = clazz;
            this.state = n;
            this.ctx = customPaintContext;
        }

        @Override
        public Object createValue(UIDefaults uIDefaults) {
            try {
                Constructor<? extends AbstractCustomRegionPainter> constructor = this.clazz.getDeclaredConstructor(Integer.TYPE, CustomPaintContext.class);
                if (constructor == null) {
                    throw new NullPointerException("Failed to find the constructor for the nimbus painter class: " + this.clazz);
                }
                return constructor.newInstance(this.state, this.ctx);
            }
            catch (Exception exception) {
                log.error(null, (Throwable)exception);
                return null;
            }
        }
    }

    public static final class CustomPaintContext
    extends AbstractRegionPainter.PaintContext {
        private CustomPaintContext(Insets insets, Dimension dimension, boolean bl, AbstractRegionPainter.PaintContext.CacheMode cacheMode, double d, double d2) {
            super(insets, dimension, bl, cacheMode, d, d2);
        }

        private CustomPaintContext(Insets insets, Dimension dimension, boolean bl) {
            this(insets, dimension, bl, null, 1.0, 1.0);
        }

        public static CustomPaintContext createInstance(Insets insets, Dimension dimension, boolean bl) {
            return new CustomPaintContext(insets, dimension, bl);
        }

        public static CustomPaintContext createUncachedInstance(Insets insets, Dimension dimension, boolean bl, double d, double d2) {
            return new CustomPaintContext(insets, dimension, bl, AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING, d, d2);
        }

        public static CustomPaintContext createFixedSizeInstance(Insets insets, Dimension dimension, boolean bl, double d, double d2) {
            return new CustomPaintContext(insets, dimension, bl, AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES, d, d2);
        }

        public static CustomPaintContext createNineSquareScaleInstance(Insets insets, Dimension dimension, boolean bl, double d, double d2) {
            return new CustomPaintContext(insets, dimension, bl, AbstractRegionPainter.PaintContext.CacheMode.NINE_SQUARE_SCALE, d, d2);
        }
    }
}

