/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class BorderLayout2
implements LayoutManager {
    public static final String Center = "center";
    public static final String North = "north";
    public static final String South = "south";
    public static final String East = "east";
    public static final String West = "west";
    public static final String NorthAndFill = "north.fill";
    public static final String SouthAndFill = "south.fill";
    public static final String EastAndFill = "east.fill";
    public static final String WestAndFill = "west.fill";
    private List<Component> north;
    private List<Component> south;
    private List<Component> east;
    private List<Component> west;
    private List<Component> filler;
    private Component center;
    private int hgap;
    private int vgap;

    public BorderLayout2() {
        this(0, 0);
    }

    public BorderLayout2(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public static Component createLineBreak() {
        return new LineBreak();
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            this.addComponent(component, Center, false);
        } else {
            String[] stringArray = string.trim().split("\\.");
            if (stringArray.length == 2) {
                this.addComponent(component, stringArray[0].trim(), !this.isLineBreak(component) && "fill".equals(stringArray[1].trim()));
            } else if (stringArray.length == 1) {
                this.addComponent(component, stringArray[0].trim(), false);
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.removeComponent(component);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        Dimension dimension = new Dimension(0, 0);
        if (this.north != null) {
            int n = 0;
            while (n < this.north.size()) {
                serializable4 = this.north.get(n);
                if (((Component)serializable4).isVisible() && !this.isLineBreak((Component)serializable4)) {
                    dimension.width = dimension.width + (((Component)serializable4).getMinimumSize().width + n < this.north.size() - 1 ? this.hgap : 0);
                    dimension.height = Math.max(dimension.height, ((Component)serializable4).getMinimumSize().height);
                }
                ++n;
            }
        }
        Dimension dimension2 = new Dimension(0, 0);
        if (this.south != null) {
            int n = 0;
            while (n < this.south.size()) {
                serializable3 = this.south.get(n);
                if (((Component)serializable3).isVisible() && !this.isLineBreak((Component)serializable3)) {
                    dimension2.width = dimension2.width + (((Component)serializable3).getMinimumSize().width + n < this.south.size() - 1 ? this.hgap : 0);
                    dimension2.height = Math.max(dimension2.height, ((Component)serializable3).getMinimumSize().height);
                }
                ++n;
            }
        }
        serializable4 = new Dimension(0, 0);
        if (this.east != null) {
            int n = 0;
            while (n < this.east.size()) {
                serializable2 = this.east.get(n);
                if (((Component)serializable2).isVisible() && !this.isLineBreak((Component)serializable2)) {
                    ((Dimension)serializable4).width = Math.max(((Dimension)serializable4).width, ((Component)serializable2).getMinimumSize().width);
                    ((Dimension)serializable4).height = ((Dimension)serializable4).height + (((Component)serializable2).getMinimumSize().height + n < this.east.size() - 1 ? this.vgap : 0);
                }
                ++n;
            }
        }
        serializable3 = new Dimension(0, 0);
        if (this.west != null) {
            int n = 0;
            while (n < this.west.size()) {
                serializable = this.west.get(n);
                if (serializable.isVisible() && !this.isLineBreak((Component)serializable)) {
                    ((Dimension)serializable3).width = Math.max(((Dimension)serializable3).width, serializable.getMinimumSize().width);
                    ((Dimension)serializable3).height = ((Dimension)serializable3).height + (serializable.getMinimumSize().height + n < this.west.size() - 1 ? this.vgap : 0);
                }
                ++n;
            }
        }
        serializable2 = new Dimension(0, 0);
        if (this.center != null && this.center.isVisible() && !this.isLineBreak(this.center)) {
            ((Dimension)serializable2).width += this.center.getMinimumSize().width;
            ((Dimension)serializable2).height += this.center.getMinimumSize().height;
        }
        ((Dimension)serializable2).height = (((Dimension)serializable2).height = ((Dimension)serializable2).height + (dimension.height > 0 ? this.vgap : 0)) + (dimension2.height > 0 ? this.vgap : 0);
        ((Dimension)serializable2).width = ((Dimension)serializable2).width + (((Dimension)serializable4).width > 0 ? this.hgap : 0);
        ((Dimension)serializable2).width = ((Dimension)serializable2).width + (((Dimension)serializable3).width > 0 ? this.hgap : 0);
        serializable = container.getInsets();
        Dimension dimension3 = new Dimension(0, 0);
        dimension3.width = Math.max(dimension3.width, dimension.width);
        dimension3.width = Math.max(dimension3.width, dimension2.width);
        dimension3.width = Math.max(dimension3.width, ((Dimension)serializable2).width + ((Dimension)serializable4).width + ((Dimension)serializable3).width);
        dimension3.height = Math.max(dimension3.height, dimension.height + ((Dimension)serializable4).height + dimension2.height);
        dimension3.height = Math.max(dimension3.height, dimension.height + ((Dimension)serializable2).height + dimension2.height);
        dimension3.height = Math.max(dimension3.height, dimension.height + ((Dimension)serializable3).height + dimension2.height);
        dimension3.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension3.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension3;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        Dimension dimension = new Dimension(0, 0);
        if (this.north != null) {
            int n = 0;
            while (n < this.north.size()) {
                serializable4 = this.north.get(n);
                if (((Component)serializable4).isVisible() && !this.isLineBreak((Component)serializable4)) {
                    dimension.width = dimension.width + (((Component)serializable4).getPreferredSize().width + n < this.north.size() - 1 ? this.hgap : 0);
                    dimension.height = Math.max(dimension.height, ((Component)serializable4).getPreferredSize().height);
                }
                ++n;
            }
        }
        Dimension dimension2 = new Dimension(0, 0);
        if (this.south != null) {
            int n = 0;
            while (n < this.south.size()) {
                serializable3 = this.south.get(n);
                if (((Component)serializable3).isVisible() && !this.isLineBreak((Component)serializable3)) {
                    dimension2.width = dimension2.width + (((Component)serializable3).getPreferredSize().width + n < this.south.size() - 1 ? this.hgap : 0);
                    dimension2.height = Math.max(dimension2.height, ((Component)serializable3).getPreferredSize().height);
                }
                ++n;
            }
        }
        serializable4 = new Dimension(0, 0);
        if (this.east != null) {
            int n = 0;
            while (n < this.east.size()) {
                serializable2 = this.east.get(n);
                if (((Component)serializable2).isVisible() && !this.isLineBreak((Component)serializable2)) {
                    ((Dimension)serializable4).width = Math.max(((Dimension)serializable4).width, ((Component)serializable2).getPreferredSize().width);
                    ((Dimension)serializable4).height = ((Dimension)serializable4).height + (((Component)serializable2).getPreferredSize().height + n < this.east.size() - 1 ? this.vgap : 0);
                }
                ++n;
            }
        }
        serializable3 = new Dimension(0, 0);
        if (this.west != null) {
            int n = 0;
            while (n < this.west.size()) {
                serializable = this.west.get(n);
                if (serializable.isVisible() && !this.isLineBreak((Component)serializable)) {
                    ((Dimension)serializable3).width = Math.max(((Dimension)serializable3).width, serializable.getPreferredSize().width);
                    ((Dimension)serializable3).height = ((Dimension)serializable3).height + (serializable.getPreferredSize().height + n < this.west.size() - 1 ? this.vgap : 0);
                }
                ++n;
            }
        }
        serializable2 = new Dimension(0, 0);
        if (this.center != null && this.center.isVisible() && !this.isLineBreak(this.center)) {
            ((Dimension)serializable2).width += this.center.getPreferredSize().width;
            ((Dimension)serializable2).height += this.center.getPreferredSize().height;
        }
        ((Dimension)serializable2).height = (((Dimension)serializable2).height = ((Dimension)serializable2).height + (dimension.height > 0 ? this.vgap : 0)) + (dimension2.height > 0 ? this.vgap : 0);
        ((Dimension)serializable2).width = ((Dimension)serializable2).width + (((Dimension)serializable4).width > 0 ? this.hgap : 0);
        ((Dimension)serializable2).width = ((Dimension)serializable2).width + (((Dimension)serializable3).width > 0 ? this.hgap : 0);
        serializable = container.getInsets();
        Dimension dimension3 = new Dimension(0, 0);
        dimension3.width = Math.max(dimension3.width, dimension.width);
        dimension3.width = Math.max(dimension3.width, dimension2.width);
        dimension3.width = Math.max(dimension3.width, ((Dimension)serializable2).width + ((Dimension)serializable4).width + ((Dimension)serializable3).width);
        dimension3.height = Math.max(dimension3.height, dimension.height + ((Dimension)serializable4).height + dimension2.height);
        dimension3.height = Math.max(dimension3.height, dimension.height + ((Dimension)serializable2).height + dimension2.height);
        dimension3.height = Math.max(dimension3.height, dimension.height + ((Dimension)serializable3).height + dimension2.height);
        dimension3.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension3.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension3;
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        Insets insets = container.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = container.getWidth() - insets.right;
        int n8 = container.getHeight() - insets.bottom;
        int n9 = n7 - n5;
        Rectangle rectangle = new Rectangle(n5, n6, 0, 0);
        if (this.componentsAvailable(North)) {
            rectangle = this.layoutHorizontal(this.north, new Rectangle(n5, n6, n9, Integer.MAX_VALUE));
        }
        int n10 = this.componentsAvailable(North) ? rectangle.y + rectangle.height + this.vgap : n6;
        Rectangle rectangle2 = new Rectangle(n5, n10, 0, 0);
        if (this.componentsAvailable(South)) {
            rectangle2 = this.layoutHorizontal(this.south, new Rectangle(n5, n10, n9, Integer.MAX_VALUE));
            n4 = n8 - rectangle2.height - rectangle2.y;
            int n11 = this.componentsAvailable(Center) ? Math.max(this.center.getMinimumSize().height + this.vgap, n4) : n4;
            for (Component component : this.south) {
                component.setLocation(component.getLocation().x, component.getLocation().y + n11);
            }
        }
        n4 = this.componentsAvailable(North) ? rectangle.y + rectangle.height + this.vgap : n6;
        Rectangle rectangle3 = new Rectangle(n5, n4, 0, 0);
        if (this.componentsAvailable(East)) {
            int n12 = this.componentsAvailable(South) ? n8 - rectangle2.height - this.vgap : n8;
            this.layoutVertical(this.east, new Rectangle(n5, n4, Integer.MAX_VALUE, n12 - n4));
        }
        int n13 = this.componentsAvailable(East) ? rectangle3.y + rectangle3.width + this.hgap : n5;
        int n14 = this.componentsAvailable(North) ? rectangle.y + rectangle.height + this.vgap : n6;
        Rectangle rectangle4 = new Rectangle(n13, n14, 0, 0);
        if (this.componentsAvailable(West)) {
            n3 = this.componentsAvailable(South) ? n8 - rectangle2.height - this.vgap : n8;
            rectangle4 = this.layoutVertical(this.west, new Rectangle(n13, n14, Integer.MAX_VALUE, n3 - n14));
            n2 = n7 - rectangle4.width - rectangle4.x;
            n = this.componentsAvailable(Center) ? Math.max(this.center.getMinimumSize().width + this.hgap, n2) : n2;
            for (Component component : this.west) {
                component.setLocation(component.getLocation().x + n, component.getLocation().y);
            }
        }
        if (this.componentsAvailable(Center)) {
            n3 = this.componentsAvailable(East) ? rectangle3.x + rectangle3.width + this.hgap : n5;
            n2 = this.componentsAvailable(North) ? rectangle.y + rectangle.height + this.vgap : n6;
            n = this.componentsAvailable(West) ? n7 - rectangle4.width - this.hgap : n7;
            int n15 = this.componentsAvailable(South) ? n8 - rectangle2.height - this.vgap : n8;
            this.center.setBounds(n3, n2, n - n3, n15 - n2);
        }
    }

    private Rectangle layoutHorizontal(List<Component> list, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 0, 0);
        if (list != null) {
            int n = rectangle.y;
            int n2 = rectangle.x;
            int n3 = rectangle.x + rectangle.width;
            int n4 = 0;
            int n5 = n3 - n2;
            ArrayList<Component> arrayList = new ArrayList<Component>();
            int n6 = 0;
            while (n6 < list.size()) {
                Component component = list.get(n6);
                if (component.isVisible()) {
                    int n7 = component.getPreferredSize().height;
                    int n8 = this.getComponentWidth(list, n6, n5);
                    component.setBounds(n2, n, n8, n7);
                    n5 = n3 - (n2 += n8 + (n6 < list.size() - 1 ? this.hgap : 0));
                    n4 = Math.max(n4, n7);
                    arrayList.add(component);
                    if (n6 == list.size() - 1 || this.getComponentWidth(list, n6 + 1, n5) > n5 || this.isLineBreak(list.get(n6 + 1))) {
                        for (Component component2 : arrayList) {
                            component2.setLocation(component2.getLocation().x, n + n4 / 2 - component2.getBounds().height / 2);
                        }
                        rectangle2.width = Math.max(rectangle2.width, component.getBounds().x + component.getBounds().width - rectangle.x);
                        rectangle2.height = Math.max(rectangle2.height, n + n4 + (n6 < list.size() - 1 ? this.vgap : 0));
                        n2 = rectangle.x;
                        n += n4 + this.vgap;
                        n5 = n3 - n2;
                        n4 = 0;
                        arrayList.clear();
                    }
                }
                ++n6;
            }
        }
        return rectangle2;
    }

    private Rectangle layoutVertical(List<Component> list, Rectangle rectangle) {
        int n = rectangle.y;
        int n2 = rectangle.x;
        int n3 = rectangle.y + rectangle.height;
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = n2;
        rectangle2.y = n;
        if (list != null) {
            int n4 = 0;
            int n5 = n3 - n;
            ArrayList<Component> arrayList = new ArrayList<Component>();
            int n6 = 0;
            while (n6 < list.size()) {
                Component component = list.get(n6);
                if (component.isVisible()) {
                    int n7 = component.getPreferredSize().width;
                    int n8 = this.getComponentHeight(list, n6, n5);
                    component.setBounds(n2, n, n7, n8);
                    n5 = n3 - (n += n8 + (n6 < list.size() - 1 ? this.vgap : 0));
                    n4 = Math.max(n4, n7);
                    arrayList.add(component);
                    if (n6 == list.size() - 1 || this.getComponentHeight(list, n6 + 1, n5) > n5 || this.isLineBreak(list.get(n6 + 1))) {
                        for (Component component2 : arrayList) {
                            component2.setLocation(n2 + n4 / 2 - component2.getBounds().width / 2, component2.getLocation().x);
                        }
                        rectangle2.height = Math.max(rectangle2.height, component.getBounds().y + component.getBounds().height - rectangle.y);
                        rectangle2.width = Math.max(rectangle2.width, n2 + n4);
                        n = rectangle.y;
                        n2 += n4 + this.hgap;
                        n4 = 0;
                        arrayList.clear();
                    }
                }
                ++n6;
            }
        }
        return rectangle2;
    }

    private int getComponentWidth(List<Component> list, int n, int n2) {
        Component component = list.get(n);
        if (!this.isFiller(component)) {
            return component.getPreferredSize().width;
        }
        int n3 = n + 1;
        int n4 = component.getMinimumSize().width;
        int n5 = 0;
        int n6 = 0;
        while (n3 < list.size()) {
            int n7;
            Component component2 = list.get(n3);
            if (!component2.isVisible()) continue;
            if (this.isLineBreak(component2)) break;
            int n8 = n7 = this.isFiller(component2) ? component2.getMinimumSize().width : component2.getPreferredSize().width;
            if (n4 + n5 + n7 + this.hgap > n2) break;
            n5 += n7 + this.hgap;
            if (this.isFiller(component2)) {
                ++n6;
            }
            ++n3;
        }
        int n9 = (n2 - n5) / (n6 + 1);
        return Math.max(n4, n9);
    }

    private int getComponentHeight(List<Component> list, int n, int n2) {
        Component component = list.get(n);
        if (!this.isFiller(component)) {
            return component.getPreferredSize().height;
        }
        int n3 = n + 1;
        int n4 = component.getMinimumSize().height;
        int n5 = 0;
        int n6 = 0;
        while (n3 < list.size()) {
            int n7;
            Component component2 = list.get(n3);
            if (!component2.isVisible()) continue;
            if (this.isLineBreak(component2)) break;
            int n8 = n7 = this.isFiller(component2) ? component2.getMinimumSize().height : component2.getPreferredSize().height;
            if (n4 + n5 + n7 + this.vgap > n2) break;
            n5 += n7 + this.vgap;
            if (this.isFiller(component2)) {
                ++n6;
            }
            ++n3;
        }
        int n9 = (n2 - n5) / (n6 + 1);
        return Math.max(n4, n9);
    }

    private boolean componentsAvailable(String string) {
        if (North.equals(string)) {
            return this.containsVisibleComponent(this.north);
        }
        if (South.equals(string)) {
            return this.containsVisibleComponent(this.south);
        }
        if (East.equals(string)) {
            return this.containsVisibleComponent(this.east);
        }
        if (West.equals(string)) {
            return this.containsVisibleComponent(this.west);
        }
        if (Center.equals(string)) {
            return this.center != null && this.center.isVisible();
        }
        return false;
    }

    private boolean isFiller(Component component) {
        return this.filler != null && this.filler.contains(component);
    }

    private boolean isLineBreak(Component component) {
        return component instanceof LineBreak;
    }

    private boolean containsVisibleComponent(List<Component> list) {
        if (list != null) {
            for (Component component : list) {
                if (!component.isVisible() || this.isLineBreak(component)) continue;
                return true;
            }
        }
        return false;
    }

    private void addComponent(Component component, String string, boolean bl) {
        if (Center.equals(string)) {
            this.center = component;
        } else {
            if (North.equals(string)) {
                this.north = this.addToList(this.north, component);
            } else if (South.equals(string)) {
                this.south = this.addToList(this.south, component);
            } else if (East.equals(string)) {
                this.east = this.addToList(this.east, component);
            } else if (West.equals(string)) {
                this.west = this.addToList(this.west, component);
            }
            if (bl) {
                this.filler = this.addToList(this.filler, component);
            }
        }
    }

    private void removeComponent(Component component) {
        this.north = this.removeFromList(this.north, component);
        this.south = this.removeFromList(this.south, component);
        this.east = this.removeFromList(this.east, component);
        this.west = this.removeFromList(this.west, component);
        this.filler = this.removeFromList(this.filler, component);
    }

    private List<Component> addToList(List<Component> list, Component component) {
        if (list == null) {
            list = new ArrayList<Component>();
        }
        if (!list.contains(component)) {
            list.add(component);
        }
        return list;
    }

    private List<Component> removeFromList(List<Component> list, Component component) {
        if (list != null) {
            list.remove(component);
            if (list.isEmpty()) {
                list = null;
            }
        }
        return list;
    }

    private static class LineBreak
    extends JComponent {
        private LineBreak() {
        }
    }
}

