/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon.impl;

import com.agfa.pacs.listtext.swingx.icon.PIconSource;
import com.agfa.pacs.listtext.swingx.icon.impl.AbstractPIcon;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconFile;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconURL;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconXmlDefinition;
import com.agfa.pacs.logging.ALogger;
import com.kitfox.svg.SVGCache;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.Semaphore;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PVectorIcon
extends AbstractPIcon {
    private static final Color BLACK_TRANSPARENT = new Color(0, 0, 0, 0);
    private static final ALogger log = ALogger.getLogger(PVectorIcon.class);
    private static final Semaphore svgAccess = new Semaphore(1);
    private SVGIcon svgIcon;

    public PVectorIcon(String string) {
        super(string);
    }

    private static SVGIcon loadSvgIconFromString(String string, String string2) {
        if (log.isTraceEnabled()) {
            log.trace("Loading icon '" + string + "': " + string2);
        }
        StringReader stringReader = new StringReader(string2);
        return PVectorIcon.loadSvgIconFromXml(string, stringReader);
    }

    private static SVGIcon loadSvgIconFromXml(String string, Reader reader) {
        try {
            URI uRI = SVGCache.getSVGUniverse().loadSVG(reader, string);
            return PVectorIcon.loadSvgIcon(uRI);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Loading SVG icon failed: ");
            stringBuilder.append(string);
            log.warn(stringBuilder.toString(), (Throwable)exception);
            return null;
        }
    }

    private static ImageIcon[] createDefaultIcons(SVGIcon sVGIcon, int ... nArray) {
        ImageIcon[] imageIconArray = new ImageIcon[nArray.length];
        int n = 0;
        while (n < imageIconArray.length) {
            imageIconArray[n] = PVectorIcon.scaleSvgIcon(sVGIcon, nArray[n]);
            ++n;
        }
        return imageIconArray;
    }

    private static ImageIcon scaleSvgIcon(SVGIcon sVGIcon, int n) {
        if (sVGIcon == null) {
            return null;
        }
        int n2 = (int)Math.round((double)(sVGIcon.getIconWidth() * n) / (double)sVGIcon.getIconHeight());
        sVGIcon.setPreferredSize(new Dimension(n2, n));
        return new ImageIcon(PVectorIcon.paintToImage((Icon)sVGIcon, n2, n));
    }

    private static SVGIcon loadSvgIcon(URL uRL) {
        log.trace("Loading SVG icon: " + uRL);
        try {
            return PVectorIcon.loadSvgIcon(uRL.toURI());
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Loading SVG icon failed: ");
            stringBuilder.append(uRL);
            log.warn(stringBuilder.toString(), (Throwable)exception);
            return null;
        }
    }

    private static SVGIcon loadSvgIcon(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("Icon URI is not set.");
        }
        SVGIcon sVGIcon = new SVGIcon();
        try {
            sVGIcon.setSvgURI(uRI);
            sVGIcon.setAntiAlias(true);
            sVGIcon.setScaleToFit(true);
        }
        catch (Exception exception) {
            log.warn("Loading SVG icon failed: " + uRI.toString(), (Throwable)exception);
        }
        if (sVGIcon.getIconWidth() == 0 || sVGIcon.getIconHeight() == 0) {
            log.warn("Undefined icon width and/or height for SVG icon: " + uRI.toString());
            sVGIcon = null;
        }
        return sVGIcon;
    }

    private static Image paintToImage(Icon icon, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(BLACK_TRANSPARENT);
        graphics2D.setColor(BLACK_TRANSPARENT);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setClip(0, 0, n, n2);
        try {
            svgAccess.acquireUninterruptibly();
            icon.paintIcon(null, graphics2D, 0, 0);
        }
        finally {
            svgAccess.release();
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected ImageIcon[] createDefaultIcons(PIconSource pIconSource) {
        if (pIconSource instanceof PIconURL) {
            URL uRL = ((PIconURL)pIconSource).getURL();
            this.svgIcon = PVectorIcon.loadSvgIcon(uRL);
        } else if (pIconSource instanceof PIconXmlDefinition) {
            PIconXmlDefinition pIconXmlDefinition = (PIconXmlDefinition)pIconSource;
            this.svgIcon = PVectorIcon.loadSvgIconFromString(pIconXmlDefinition.getIconName(), pIconXmlDefinition.getXmlDefinition());
        } else if (pIconSource instanceof PIconFile) {
            File file = ((PIconFile)pIconSource).getFile();
            try {
                this.svgIcon = PVectorIcon.loadSvgIconFromXml(file.getName(), new FileReader(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.warn("File not found: " + file.getAbsolutePath(), (Throwable)fileNotFoundException);
                this.svgIcon = null;
            }
        } else {
            throw new IllegalArgumentException(pIconSource.getClass() + " not supported.");
        }
        return PVectorIcon.createDefaultIcons(this.svgIcon, pIconSource.getDefaultIconHeights());
    }

    @Override
    protected synchronized ImageIcon scaleIcon(int n) {
        return PVectorIcon.scaleSvgIcon(this.svgIcon, n);
    }
}

