/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon.impl;

import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.listtext.swingx.icon.PIconSource;
import com.agfa.pacs.listtext.swingx.icon.impl.AbstractPIcon;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconFile;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconURL;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;

public class PBitmapIcon
extends AbstractPIcon {
    private ImageIcon originalIcon;

    public PBitmapIcon(String string) {
        super(string);
    }

    @Override
    protected ImageIcon[] createDefaultIcons(PIconSource pIconSource) {
        Image image;
        if (pIconSource instanceof PIconURL) {
            URL uRL = ((PIconURL)pIconSource).getURL();
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        } else if (pIconSource instanceof PIconFile) {
            File file = ((PIconFile)pIconSource).getFile();
            image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        } else {
            throw new IllegalArgumentException(pIconSource.getClass() + " not supported.");
        }
        return this.createDefaultIcons(image, pIconSource.getDefaultIconHeights());
    }

    private ImageIcon[] createDefaultIcons(Image image, int ... nArray) {
        this.originalIcon = new ImageIcon(image);
        ImageIcon[] imageIconArray = new ImageIcon[nArray.length];
        int n = 0;
        while (n < imageIconArray.length) {
            imageIconArray[n] = PBitmapIcon.scaleBitmapIcon(this.originalIcon, nArray[n]);
            ++n;
        }
        return imageIconArray;
    }

    private static ImageIcon scaleBitmapIcon(ImageIcon imageIcon, int n) {
        ImageIcon imageIcon2 = n != imageIcon.getIconHeight() ? IconUtil.scaleImageIcon(imageIcon, -1, n) : imageIcon;
        return imageIcon2;
    }

    @Override
    protected ImageIcon scaleIcon(int n) {
        return PBitmapIcon.scaleBitmapIcon(this.originalIcon, n);
    }
}

