/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class IconUtil {
    public static ImageIcon scaleIcon(Icon icon, float f, Component component) {
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = Math.round((float)n * f);
        int n4 = Math.round((float)n2 * f);
        return IconUtil.scaleIcon(icon, n3, n4, component);
    }

    public static ImageIcon scaleIcon(Icon icon, int n, int n2, Component component) {
        if (icon instanceof ImageIcon) {
            return IconUtil.scaleImageIcon((ImageIcon)icon, n, n2);
        }
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        ImageGraphics imageGraphics = IconUtil.prepareGraphicsForImageScaling(n3, n4, n, n2, component != null ? component.getBackground() : null);
        icon.paintIcon(null, imageGraphics.graphics, 0, 0);
        imageGraphics.graphics.dispose();
        return new ImageIcon(imageGraphics.image);
    }

    public static ImageIcon scaleImageIcon(ImageIcon imageIcon, float f) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        n = Math.round((float)n * f);
        n2 = Math.round((float)n2 * f);
        return IconUtil.scaleImageIcon(imageIcon, n, n2);
    }

    public static ImageIcon scaleImageIcon(ImageIcon imageIcon, int n, int n2) {
        Image image = imageIcon.getImage();
        image = IconUtil.scaleImage(image, n, n2);
        return new ImageIcon(image);
    }

    public static ImageIcon scaleImageIconForDiagnosticMonitor(ImageIcon imageIcon) {
        return IconUtil.scaleImageIcon(imageIcon, (float)GUI.getScaleDiagnosticFactor());
    }

    public static Icon scaleIconForDiagnosticMonitor(Icon icon) {
        if (icon instanceof PIcon) {
            return icon;
        }
        return IconUtil.scaleIcon(icon, (float)GUI.getScaleDiagnosticFactor(), null);
    }

    public static Icon scaleIconForLTA(Icon icon) {
        return IconUtil.scaleIcon(icon, (float)GUI.getScaleFactor(), null);
    }

    public static Image scaleImage(Image image, int n, int n2) {
        ImageGraphics imageGraphics = IconUtil.prepareGraphicsForImageScaling(image.getWidth(null), image.getHeight(null), n, n2, null);
        imageGraphics.graphics.drawImage(image, 0, 0, null);
        imageGraphics.graphics.dispose();
        return imageGraphics.image;
    }

    private static ImageGraphics prepareGraphicsForImageScaling(int n, int n2, int n3, int n4, Color color) {
        double d;
        double d2;
        assert (n3 > 0 || n4 > 0) : "Can not scale without target";
        if (n3 <= 0) {
            d = d2 = (double)n4 / (double)n2;
            n3 = (int)Math.round((double)n * d);
        } else if (n4 <= 0) {
            d2 = d = (double)n3 / (double)n;
            n4 = (int)Math.round((double)n2 * d2);
        } else {
            d = (double)n3 / (double)n;
            d2 = (double)n4 / (double)n2;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(d, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (color != null) {
            graphics2D.setColor(color);
        }
        return new ImageGraphics(graphics2D, bufferedImage);
    }

    public static ImageIcon darkenIcon(ImageIcon imageIcon, float f) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2;
        if (imageIcon == null) {
            return null;
        }
        if (imageIcon.getImage() instanceof BufferedImage) {
            bufferedImage2 = (BufferedImage)imageIcon.getImage();
            bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
        } else {
            bufferedImage2 = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
            graphics2D.dispose();
            bufferedImage = bufferedImage2;
        }
        IconUtil.darkenLightenImage(bufferedImage2, bufferedImage, f);
        return new ImageIcon(bufferedImage);
    }

    private static void darkenLightenImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f) {
        int[] nArray = bufferedImage.getRaster().getPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (int[])null);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)((float)nArray[n] * f) & 0xFF;
            nArray[n + 1] = (int)((float)nArray[n + 1] * f) & 0xFF;
            nArray[n + 2] = (int)((float)nArray[n + 2] * f) & 0xFF;
            n += 4;
        }
        bufferedImage2.getRaster().setPixels(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), nArray);
    }

    private static class ImageGraphics {
        public final Graphics2D graphics;
        public final Image image;

        ImageGraphics(Graphics2D graphics2D, Image image) {
            this.graphics = graphics2D;
            this.image = image;
        }
    }
}

