/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.treetable;

import com.agfa.pacs.listtext.swingx.controls.treetable.ITreeTableSelectionModel;
import com.agfa.pacs.listtext.swingx.controls.treetable.JTreeTable;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeTableSelectionModelWrapper
extends DefaultTreeSelectionModel
implements ITreeTableSelectionModel {
    private static final long serialVersionUID = 5040852526908337151L;
    private JTreeTable treeTable;
    protected boolean updatingListSelectionModel;

    public TreeTableSelectionModelWrapper(JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
        this.listSelectionModel = new TreeTableSelectionModel();
        this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
    }

    @Override
    public ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    @Override
    public TreeSelectionModel getTreeSelectionModel() {
        return this.treeTable.getTree().getSelectionModel();
    }

    @Override
    public void resetRowSelection() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                super.resetRowSelection();
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected void updateSelectedPathsFromSelectedRows() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                int n = this.listSelectionModel.getMinSelectionIndex();
                int n2 = this.listSelectionModel.getMaxSelectionIndex();
                this.clearSelection();
                if (n != -1 && n2 != -1) {
                    int n3 = n;
                    while (n3 <= n2) {
                        TreePath treePath;
                        if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = this.treeTable.tree.getPathForRow(n3)) != null) {
                            this.addSelectionPath(treePath);
                        }
                        ++n3;
                    }
                }
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TreeTableSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
        }
    }

    class TreeTableSelectionModel
    extends DefaultListSelectionModel {
        TreeTableSelectionModel() {
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            if (((TreeTableSelectionModelWrapper)TreeTableSelectionModelWrapper.this).treeTable.ignoreClearSelection) {
                return;
            }
            super.setAnchorSelectionIndex(n);
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            if (((TreeTableSelectionModelWrapper)TreeTableSelectionModelWrapper.this).treeTable.ignoreClearSelection) {
                return;
            }
            super.setLeadSelectionIndex(n);
        }
    }
}

