/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.treetable;

import com.agfa.pacs.listtext.swingx.controls.treetable.ITreeTableModel;
import com.agfa.pacs.listtext.swingx.controls.treetable.JTreeTable;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private static final long serialVersionUID = -4930352821692744692L;
    private JTreeTable treeTable;
    protected int visibleRow;

    public TreeTableCellRenderer(ITreeTableModel iTreeTableModel) {
        super(iTreeTableModel);
    }

    protected void setTreeTable(JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    @Override
    public void setRowHeight(int n) {
        if (n > 0) {
            super.setRowHeight(n);
            if (this.treeTable != null && this.treeTable.getRowHeight() != n) {
                this.treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, 0, n3, this.treeTable.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.translate(0, -this.visibleRow * this.getRowHeight() - 1);
        super.paint(graphics);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.updateTableCellRenderer(jTable, object, bl, bl2, n, n2);
        this.visibleRow = n;
        return this;
    }

    protected void updateTableCellRenderer(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
    }
}

