/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.treetable;

import com.agfa.pacs.listtext.swingx.controls.treetable.ITreeTableModel;
import com.agfa.pacs.listtext.swingx.controls.treetable.ITreeTableSelectionModel;
import com.agfa.pacs.listtext.swingx.controls.treetable.TreeTableCellEditor;
import com.agfa.pacs.listtext.swingx.controls.treetable.TreeTableCellRenderer;
import com.agfa.pacs.listtext.swingx.controls.treetable.TreeTableModelAdapter;
import com.agfa.pacs.listtext.swingx.controls.treetable.TreeTableSelectionModelWrapper;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = -9192467202445975997L;
    protected TreeTableCellRenderer tree;
    protected boolean ignoreClearSelection;

    public JTreeTable(ITreeTableModel iTreeTableModel, TableColumnModel tableColumnModel) {
        super(null, tableColumnModel != null ? tableColumnModel : null);
        this.tree = this.createTreeTableCellRenderer(iTreeTableModel);
        this.tree.setTreeTable(this);
        super.setModel(new TreeTableModelAdapter(iTreeTableModel, this.tree));
        TreeTableSelectionModelWrapper treeTableSelectionModelWrapper = this.createTreeTableSelectionModel();
        this.tree.setSelectionModel(treeTableSelectionModelWrapper);
        this.setSelectionModel(treeTableSelectionModelWrapper.getListSelectionModel());
        this.tree.setRowHeight(this.getRowHeight());
        this.setDefaultRenderer(ITreeTableModel.class, this.tree);
        this.setDefaultEditor(ITreeTableModel.class, new TreeTableCellEditor(this));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public JTreeTable(ITreeTableModel iTreeTableModel) {
        this(iTreeTableModel, null);
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == ITreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.ignoreClearSelection = true;
        try {
            super.tableChanged(tableModelEvent);
        }
        finally {
            this.ignoreClearSelection = false;
        }
    }

    @Override
    public void clearSelection() {
        if (!this.ignoreClearSelection) {
            super.clearSelection();
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public ITreeTableModel getTreeTableModel() {
        return ((TreeTableModelAdapter)this.getModel()).getTreeTableModel();
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
    }

    public boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        if (treePath != null && !this.tree.getModel().isLeaf(treePath.getLastPathComponent())) {
            Insets insets = this.tree.getInsets();
            Icon icon = UIManager.getIcon("Tree.expandedIcon");
            int n3 = UIManager.getInt("Tree.rightChildIndent");
            int n4 = UIManager.getInt("Tree.leftChildIndent");
            int n5 = n3 + n4;
            boolean bl = this.tree.getComponentOrientation().isLeftToRight();
            int n6 = 0;
            if (this.tree.isRootVisible() && this.tree.getShowsRootHandles()) {
                n6 = 1;
            } else if (!this.tree.isRootVisible() && !this.tree.getShowsRootHandles()) {
                n6 = -1;
            }
            int n7 = icon != null ? icon.getIconWidth() : 8;
            int n8 = n5 * (treePath.getPathCount() - 1 + n6);
            n8 = bl ? n8 + insets.left - n3 + 1 : this.tree.getWidth() - n8 - insets.right + n3 - 1;
            int n9 = n8 = bl ? n8 - (int)Math.ceil((double)n7 / 2.0) : n8 - (int)Math.floor((double)n7 / 2.0);
            return n >= n8 && n < n8 + n7;
        }
        return false;
    }

    public ITreeTableSelectionModel getTreeTableSelectionModel() {
        return (ITreeTableSelectionModel)((Object)this.tree.getSelectionModel());
    }

    protected TreeTableCellRenderer createTreeTableCellRenderer(ITreeTableModel iTreeTableModel) {
        return new TreeTableCellRenderer(iTreeTableModel);
    }

    public TreeTableSelectionModelWrapper createTreeTableSelectionModel() {
        return new TreeTableSelectionModelWrapper(this);
    }
}

