/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.treetable;

import com.agfa.pacs.listtext.swingx.controls.treetable.ITreeTableModel;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTableModel
implements ITreeTableModel {
    protected Object root;
    protected List<TreeModelListener> listeners;

    public AbstractTreeTableModel(Object object) {
        this.root = object;
        this.listeners = new CopyOnWriteArrayList<TreeModelListener>();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Root is null!");
        }
        this.root = object;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        int n = 0;
        while (n < this.getChildCount(object)) {
            if (this.getChild(object, n).equals(object2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null && !this.listeners.contains(treeModelListener)) {
            this.listeners.add(treeModelListener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null && this.listeners.contains(treeModelListener)) {
            this.listeners.remove(treeModelListener);
        }
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    @Override
    public Class getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return this.getColumnClass(n) == ITreeTableModel.class || Component.class.isAssignableFrom(this.getColumnClass(n));
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }
}

