/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.timetable;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.listtext.swingx.controls.DateBox;
import com.agfa.pacs.listtext.swingx.controls.Messages;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableModel;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

class TimeTableToolPanel
extends JPanel {
    private TimeTableModel model;
    private Box box = new Box(0);
    private DateBox dateBox;
    private JButton dayForwardBtn;
    private JButton dayBackwardBtn;
    private JButton weekForwardBtn;
    private JButton weekBackwardBtn;
    private JButton monthForwardBtn;
    private JButton monthBackwardBtn;
    private Action dayForwardAction;
    private Action dayBackwardAction;
    private Action weekForwardAction;
    private Action weekBackwardAction;
    private Action monthForwardAction;
    private Action monthBackwardAction;

    TimeTableToolPanel() {
        this((TimeTableModel)null);
    }

    TimeTableToolPanel(TimeTableModel timeTableModel) {
        super(new BorderLayout());
        this.add((Component)this.box, "East");
        this.box.add(this.createButton(new TodayAction()));
        this.monthBackwardAction = new MonthBackwardAction();
        this.monthBackwardBtn = this.createButton(this.monthBackwardAction);
        this.box.add(this.monthBackwardBtn);
        this.weekBackwardAction = new WeekBackwardAction();
        this.weekBackwardBtn = this.createButton(this.weekBackwardAction);
        this.box.add(this.weekBackwardBtn);
        this.dayBackwardAction = new DayBackwardAction();
        this.dayBackwardBtn = this.createButton(this.dayBackwardAction);
        this.box.add(this.dayBackwardBtn);
        this.dateBox = this.createDateBox();
        this.box.add(this.dateBox);
        this.dayForwardAction = new DayForwardAction();
        this.dayForwardBtn = this.createButton(this.dayForwardAction);
        this.box.add(this.dayForwardBtn);
        this.weekForwardAction = new WeekForwardAction();
        this.weekForwardBtn = this.createButton(this.weekForwardAction);
        this.box.add(this.weekForwardBtn);
        this.monthForwardAction = new MonthForwardAction();
        this.monthForwardBtn = this.createButton(this.monthForwardAction);
        this.box.add(this.monthForwardBtn);
        this.init(timeTableModel);
    }

    void init(TimeTableModel timeTableModel) {
        this.model = timeTableModel;
        if (timeTableModel == null) {
            this.dayForwardAction.putValue("Name", ">");
            this.dayBackwardAction.putValue("Name", "<");
            this.weekForwardAction.putValue("Name", ">>");
            this.weekBackwardAction.putValue("Name", "<<");
            this.monthForwardAction.putValue("Name", ">>>");
            this.monthBackwardAction.putValue("Name", "<<<");
            this.dayForwardBtn.setEnabled(false);
            this.dayBackwardBtn.setEnabled(false);
            this.weekForwardBtn.setEnabled(false);
            this.weekBackwardBtn.setEnabled(false);
            this.monthForwardBtn.setEnabled(false);
            this.monthBackwardBtn.setEnabled(false);
            this.dayForwardBtn.setVisible(true);
            this.dayBackwardBtn.setVisible(true);
            this.weekForwardBtn.setVisible(true);
            this.weekBackwardBtn.setVisible(true);
            this.monthForwardBtn.setVisible(true);
            this.monthBackwardBtn.setVisible(true);
        } else {
            this.dayForwardBtn.setEnabled(true);
            this.dayBackwardBtn.setEnabled(true);
            this.weekForwardBtn.setEnabled(true);
            this.weekBackwardBtn.setEnabled(true);
            this.monthForwardBtn.setEnabled(true);
            this.monthBackwardBtn.setEnabled(true);
            TimeTableModel.TimeTableType timeTableType = timeTableModel.getType();
            if (timeTableType.equals(TimeTableModel.TimeTableType.Days7)) {
                this.dayForwardAction.putValue("Name", ">");
                this.dayBackwardAction.putValue("Name", "<");
                this.weekForwardAction.putValue("Name", ">>");
                this.weekBackwardAction.putValue("Name", "<<");
                this.dayForwardBtn.setVisible(true);
                this.dayBackwardBtn.setVisible(true);
                this.weekForwardBtn.setVisible(true);
                this.weekBackwardBtn.setVisible(true);
                this.monthForwardBtn.setVisible(false);
                this.monthBackwardBtn.setVisible(false);
            } else if (timeTableType.equals(TimeTableModel.TimeTableType.Week)) {
                this.weekForwardAction.putValue("Name", ">");
                this.weekBackwardAction.putValue("Name", "<");
                this.dayForwardBtn.setVisible(false);
                this.dayBackwardBtn.setVisible(false);
                this.weekForwardBtn.setVisible(true);
                this.weekBackwardBtn.setVisible(true);
                this.monthForwardBtn.setVisible(false);
                this.monthBackwardBtn.setVisible(false);
            } else if (timeTableType.equals(TimeTableModel.TimeTableType.Month)) {
                this.monthForwardAction.putValue("Name", ">");
                this.monthBackwardAction.putValue("Name", "<");
                this.dayForwardBtn.setVisible(false);
                this.dayBackwardBtn.setVisible(false);
                this.weekForwardBtn.setVisible(false);
                this.weekBackwardBtn.setVisible(false);
                this.monthForwardBtn.setVisible(true);
                this.monthBackwardBtn.setVisible(true);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private JButton createButton(Action action) {
        return SwingUtilities2.createButton(action);
    }

    private DateBox createDateBox() {
        DateBox dateBox = SwingUtilities2.createDateBox(this.model != null ? this.model.getDate() : new Date(), true, false);
        dateBox.addPropertyChangeListener(new DateBoxListener());
        return dateBox;
    }

    private void updateDateBox() {
        Date date = this.model.getDate();
        if (!date.equals(this.dateBox.getDate())) {
            this.dateBox.setDate(date);
        }
    }

    private class DateBoxListener
    implements PropertyChangeListener {
        private DateBoxListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("DATE_VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName()) && TimeTableToolPanel.this.model != null) {
                TimeTableToolPanel.this.model.setDate((Date)propertyChangeEvent.getNewValue());
            }
        }
    }

    class DayBackwardAction
    extends AbstractAction {
        private Calendar cal = Calendar.getInstance();

        DayBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CursorUtil.setWaitCursor((Component)((Component)actionEvent.getSource()));
                this.cal.setTime(TimeTableToolPanel.this.model.getDate());
                this.cal.add(5, -1);
                TimeTableToolPanel.this.model.setDate(this.cal.getTime());
            }
            finally {
                CursorUtil.resetWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.updateDateBox();
            }
        }
    }

    class DayForwardAction
    extends AbstractAction {
        private Calendar cal = Calendar.getInstance();

        DayForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CursorUtil.setWaitCursor((Component)((Component)actionEvent.getSource()));
                this.cal.setTime(TimeTableToolPanel.this.model.getDate());
                this.cal.add(5, 1);
                TimeTableToolPanel.this.model.setDate(this.cal.getTime());
            }
            finally {
                CursorUtil.resetWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.updateDateBox();
            }
        }
    }

    class MonthBackwardAction
    extends AbstractAction {
        private Calendar cal = Calendar.getInstance();

        MonthBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CursorUtil.setWaitCursor((Component)((Component)actionEvent.getSource()));
                this.cal.setTime(TimeTableToolPanel.this.model.getDate());
                this.cal.add(2, -1);
                TimeTableToolPanel.this.model.setDate(this.cal.getTime());
            }
            finally {
                CursorUtil.resetWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.updateDateBox();
            }
        }
    }

    class MonthForwardAction
    extends AbstractAction {
        private Calendar cal = Calendar.getInstance();

        MonthForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CursorUtil.setWaitCursor((Component)((Component)actionEvent.getSource()));
                this.cal.setTime(TimeTableToolPanel.this.model.getDate());
                this.cal.add(2, 1);
                TimeTableToolPanel.this.model.setDate(this.cal.getTime());
            }
            finally {
                CursorUtil.resetWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.updateDateBox();
            }
        }
    }

    class TodayAction
    extends AbstractAction {
        public TodayAction() {
            super(Messages.getString("TimeTable.Today.Text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CursorUtil.setWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.model.setDate(new Date());
            }
            finally {
                CursorUtil.resetWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.updateDateBox();
            }
        }
    }

    class WeekBackwardAction
    extends AbstractAction {
        private Calendar cal = Calendar.getInstance();

        WeekBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CursorUtil.setWaitCursor((Component)((Component)actionEvent.getSource()));
                this.cal.setTime(TimeTableToolPanel.this.model.getDate());
                this.cal.add(5, -this.cal.getActualMaximum(7));
                TimeTableToolPanel.this.model.setDate(this.cal.getTime());
            }
            finally {
                CursorUtil.resetWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.updateDateBox();
            }
        }
    }

    class WeekForwardAction
    extends AbstractAction {
        private Calendar cal = Calendar.getInstance();

        WeekForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CursorUtil.setWaitCursor((Component)((Component)actionEvent.getSource()));
                this.cal.setTime(TimeTableToolPanel.this.model.getDate());
                this.cal.add(5, this.cal.getActualMaximum(7));
                TimeTableToolPanel.this.model.setDate(this.cal.getTime());
            }
            finally {
                CursorUtil.resetWaitCursor((Component)((Component)actionEvent.getSource()));
                TimeTableToolPanel.this.updateDateBox();
            }
        }
    }
}

