/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.timetable;

import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTableItem;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableUtils;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;

public final class TimeTableItemComparator
implements Comparator<ITimeTableItem> {
    private static TimeTableItemComparator dateInstance;
    private static TimeTableItemComparator timeInstance;
    private static TimeTableItemComparator dateTimeInstance;
    boolean compareTime = false;
    boolean compareDate = false;

    private TimeTableItemComparator(boolean bl, boolean bl2) {
        this.compareDate = bl;
        this.compareTime = bl2;
    }

    public static synchronized TimeTableItemComparator getDateComparator() {
        if (dateInstance == null) {
            dateInstance = new TimeTableItemComparator(true, false);
        }
        return dateInstance;
    }

    public static synchronized TimeTableItemComparator getTimeComparator() {
        if (timeInstance == null) {
            timeInstance = new TimeTableItemComparator(false, true);
        }
        return timeInstance;
    }

    public static synchronized TimeTableItemComparator getDateTimeComparator() {
        if (dateTimeInstance == null) {
            dateTimeInstance = new TimeTableItemComparator(true, true);
        }
        return dateTimeInstance;
    }

    @Override
    public int compare(ITimeTableItem iTimeTableItem, ITimeTableItem iTimeTableItem2) {
        int n = 0;
        if (n == 0 && this.compareDate) {
            n = this.compareDates(iTimeTableItem, iTimeTableItem2);
        }
        if (n == 0 && this.compareTime) {
            n = this.compareTimes(iTimeTableItem, iTimeTableItem2);
        }
        if (n == 0) {
            n = this.compareNames(iTimeTableItem, iTimeTableItem2);
        }
        return n != 0 ? n : -1;
    }

    private int compareDates(ITimeTableItem iTimeTableItem, ITimeTableItem iTimeTableItem2) {
        Date date = TimeTableUtils.startDate(iTimeTableItem);
        Date date2 = TimeTableUtils.startDate(iTimeTableItem2);
        return date.compareTo(date2);
    }

    private int compareTimes(ITimeTableItem iTimeTableItem, ITimeTableItem iTimeTableItem2) {
        Date date = TimeTableUtils.startTime(iTimeTableItem);
        Date date2 = TimeTableUtils.startTime(iTimeTableItem2);
        return date.compareTo(date2);
    }

    private int compareNames(ITimeTableItem iTimeTableItem, ITimeTableItem iTimeTableItem2) {
        String string = iTimeTableItem.getCaption();
        String string2 = iTimeTableItem2.getCaption();
        if (string != null && string2 != null) {
            return Collator.getInstance().compare(string, string2);
        }
        if (string != null) {
            return -1;
        }
        if (string2 != null) {
            return 1;
        }
        return 0;
    }
}

