/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.plaf.basic;

import com.agfa.pacs.listtext.swingx.controls.plaf.TaskPaneTabUI;
import com.agfa.pacs.listtext.swingx.controls.taskpane.TaskPaneTab;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;

public class BasicTaskPaneTabUI
extends TaskPaneTabUI {
    protected TaskPaneTab tab = null;
    protected TaskPaneTabHeader header = null;
    protected JComponent clientComponent = null;
    private TabListener tabListener = new TabListener();
    private HeaderListener headerListener = new HeaderListener();
    protected Icon expandIconArrow = null;
    protected Icon collapseIconArrow = null;
    protected Icon expandIconSquare = null;
    protected Icon collapseIconSquare = null;
    protected Icon closeIcon = null;
    protected Color titleForeground = null;
    protected Color titleBackground = null;
    protected Color primaryColor = null;
    protected Color secondaryColor = null;
    protected Color tertiaryColor = null;
    protected Color titleForegroundExpanded = null;
    protected Color titleBackgroundExpanded = null;
    protected Color primaryExpandedColor = null;
    protected Color secondaryExpandedColor = null;
    protected Color tertiaryExpandedColor = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskPaneTabUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.tab = (TaskPaneTab)jComponent;
        this.installDefaults();
        this.createComponents();
        this.installListeners();
        this.initComponents();
        this.installLayout();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallLayout();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.tab = null;
    }

    protected void installDefaults() {
        this.primaryColor = UIManager.getColor("color.secondary.2");
        this.secondaryColor = this.primaryColor.darker();
        this.tertiaryColor = this.primaryColor.brighter();
        this.primaryExpandedColor = UIManager.getColor("color.primary.1");
        this.secondaryExpandedColor = this.primaryExpandedColor.darker();
        this.tertiaryExpandedColor = this.primaryExpandedColor.brighter();
        this.titleBackgroundExpanded = this.primaryExpandedColor;
        this.closeIcon = UIManager.getIcon("cancel.lta");
        this.expandIconArrow = UIManager.getIcon("triangle.down.filled");
        this.collapseIconArrow = UIManager.getIcon("triangle.up.filled");
        this.expandIconSquare = UIManager.getIcon("window.expanded");
        this.collapseIconSquare = UIManager.getIcon("window.collapsed");
        this.titleForeground = Color.WHITE;
        this.primaryColor = UIManager.getColor("color.secondary.4");
        this.secondaryColor = UIManager.getColor("color.secondary.2");
        this.tertiaryColor = UIManager.getColor("color.secondary.1");
        this.titleForegroundExpanded = Color.WHITE;
        this.primaryExpandedColor = UIManager.getColor("color.secondary.2").brighter();
        this.secondaryExpandedColor = UIManager.getColor("color.secondary.1").brighter();
        this.tertiaryExpandedColor = UIManager.getColor("color.secondary.2");
    }

    public void uninstallDefaults() {
        this.titleBackground = null;
        this.titleForeground = null;
        this.titleBackgroundExpanded = null;
        this.titleForegroundExpanded = null;
        this.primaryColor = null;
        this.secondaryColor = null;
        this.tertiaryColor = null;
        this.primaryExpandedColor = null;
        this.secondaryExpandedColor = null;
        this.tertiaryExpandedColor = null;
        this.expandIconArrow = null;
        this.collapseIconArrow = null;
        this.expandIconSquare = null;
        this.collapseIconSquare = null;
    }

    public void createComponents() {
        this.header = new TaskPaneTabHeader(this.tab.getHeaderPaintingType(), this.tab.isExpanded() && this.titleBackgroundExpanded != null ? this.titleBackgroundExpanded : this.titleBackground, this.tab.isExpanded() && this.titleForegroundExpanded != null ? this.titleBackgroundExpanded : this.titleForeground, this.primaryColor, this.secondaryColor, this.tertiaryColor);
        this.header.setPrimaryColorExpanded(this.primaryExpandedColor);
        this.header.setSecondaryColorExpanded(this.secondaryExpandedColor);
        this.header.setTertiaryColorExpanded(this.tertiaryExpandedColor);
    }

    public void installListeners() {
        this.tab.addPropertyChangeListener(this.tabListener);
        this.header.addMouseListener(this.headerListener);
        this.header.addPropertyChangeListener(this.headerListener);
    }

    public void uninstallListeners() {
        this.tab.removePropertyChangeListener(this.tabListener);
        this.header.removeMouseListener(this.headerListener);
        this.header.removePropertyChangeListener(this.headerListener);
    }

    protected void initComponents() {
        this.clientComponent = this.tab.getClientComponent();
        this.header.setTitle(this.tab.getTitle());
        this.header.setTitleIcon(this.getExpandCollapseIcon());
        this.header.setActionComponents(this.tab.getActionComponents());
        this.header.setCloseButtonVisible(this.tab.isCloseable());
        int n = this.tab.getHeaderSize();
        this.header.setMinimumSize(new Dimension(this.header.getMinimumSize().width, n));
        this.header.setPreferredSize(new Dimension(this.header.getPreferredSize().width, n));
        this.header.setMaximumSize(new Dimension(this.header.getMaximumSize().width, n));
    }

    protected void installLayout() {
        this.tab.setLayout(new BorderLayout());
        this.tab.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.tab.add((Component)this.header, "North");
        if (this.clientComponent != null) {
            this.tab.add((Component)this.clientComponent, "Center");
        }
    }

    public void uninstallLayout() {
        this.tab.removeAll();
    }

    private void setClientComponent(JComponent jComponent) {
        if (this.clientComponent != null) {
            this.tab.remove(this.clientComponent);
        }
        this.clientComponent = jComponent;
        if (this.clientComponent != null) {
            this.tab.add((Component)this.clientComponent, "Center");
        }
        this.tab.revalidate();
    }

    private void setHeaderSize(int n) {
        if (this.header.getHeight() != n) {
            this.header.setMinimumSize(new Dimension(this.header.getMinimumSize().width, n));
            this.header.setPreferredSize(new Dimension(this.header.getPreferredSize().width, n));
            this.header.setMaximumSize(new Dimension(this.header.getMaximumSize().width, n));
            this.tab.revalidate();
        }
    }

    private void setTabExpanded(boolean bl) {
        this.header.setExpanded(bl);
    }

    private void setPrimaryColor(Color color) {
        if (color != null) {
            this.primaryColor = color;
            this.header.setPrimaryColor(color);
        }
    }

    private void setSecondaryColor(Color color) {
        if (color != null) {
            this.secondaryColor = color;
            this.header.setSecondaryColor(color);
        }
    }

    private void setTertiaryColor(Color color) {
        if (color != null) {
            this.tertiaryColor = color;
            this.header.setTertiaryColor(color);
        }
    }

    private void setPrimaryColorExpanded(Color color) {
        if (color != null) {
            this.primaryExpandedColor = color;
            this.header.setPrimaryColorExpanded(color);
        }
    }

    private void setSecondaryColorExpanded(Color color) {
        if (color != null) {
            this.secondaryExpandedColor = color;
            this.header.setSecondaryColorExpanded(color);
        }
    }

    private void setTertiaryColorExpanded(Color color) {
        if (color != null) {
            this.tertiaryExpandedColor = color;
            this.header.setTertiaryColorExpanded(color);
        }
    }

    private void setTitleForeground(Color color) {
        if (color != null && !color.equals(this.titleForeground)) {
            this.titleForeground = color;
            this.header.setTitleForeground(color);
        }
    }

    private void setTitleBackground(Color color) {
        if (color != null && !color.equals(this.titleBackground)) {
            this.titleBackground = color;
            this.header.setTitleBackground(color);
        }
    }

    private void setTitleForegroundExpanded(Color color) {
        if (color != null && !color.equals(this.titleForegroundExpanded)) {
            this.titleForegroundExpanded = color;
            if (this.tab.isExpanded()) {
                this.header.setTitleForeground(color);
            }
        }
    }

    private void setTitleBackgroundExpanded(Color color) {
        if (color != null && !color.equals(this.titleBackgroundExpanded)) {
            this.titleBackgroundExpanded = color;
            if (this.tab.isExpanded()) {
                this.header.setTitleBackground(color);
            }
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (jComponent != this.tab) {
            return;
        }
        if (this.tab.getHeaderPaintingType() == 3) {
            Color color = graphics.getColor();
            graphics.setColor(this.primaryColor);
            Insets insets = jComponent.getInsets();
            int n = insets.left;
            int n2 = jComponent.getWidth() - 1;
            int n3 = insets.top + this.header.getHeight();
            int n4 = jComponent.getHeight() - 1;
            graphics.drawLine(n, n3, n, n4);
            graphics.drawLine(n, n4, n2, n4);
            graphics.drawLine(n2, n3, n2, n4);
            graphics.setColor(color);
        }
    }

    private Icon getExpandCollapseIcon() {
        switch (this.tab.getExpandCollapseIconType()) {
            case 0: {
                return this.tab.isExpanded() ? this.expandIconArrow : this.collapseIconArrow;
            }
            case 1: {
                return this.tab.isExpanded() ? this.expandIconSquare : this.collapseIconSquare;
            }
        }
        return null;
    }

    private class HeaderListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private HeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && !BasicTaskPaneTabUI.this.tab.isTitleEditable()) {
                BasicTaskPaneTabUI.this.tab.setExpanded(!BasicTaskPaneTabUI.this.tab.isExpanded());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("CLOSE_BUTTON_PRESSED".equals(string)) {
                BasicTaskPaneTabUI.this.tab.setClosed(true);
            }
        }
    }

    private class TabListener
    implements PropertyChangeListener {
        private TabListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("TITLE_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setTitle((String)propertyChangeEvent.getNewValue());
            } else if ("CLIENT_COMPONENT_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setClientComponent((JComponent)propertyChangeEvent.getNewValue());
            } else if ("ACTION_COMPONENTS_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setActionComponents((List)propertyChangeEvent.getNewValue());
            } else if ("TAB_EXPANSION_FLAG_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setTabExpanded((Boolean)propertyChangeEvent.getNewValue());
            } else if ("TITLE_EDITABLE_CHANGED".equals(string) || "TITLE_EDITING_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setTitleEditing(BasicTaskPaneTabUI.this.tab.isTitleEditable() && BasicTaskPaneTabUI.this.tab.isTitleEditing());
            } else if ("HEADER_SIZE_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setHeaderSize((Integer)propertyChangeEvent.getNewValue());
            } else if ("HEADER_PAINTING_TYPE_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setPaintingType((Integer)propertyChangeEvent.getNewValue());
            } else if ("HEADER_TITLE_FOREGROUND_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setTitleForeground((Color)propertyChangeEvent.getNewValue());
            } else if ("HEADER_TITLE_BACKGROUND_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setTitleBackground((Color)propertyChangeEvent.getNewValue());
            } else if ("HEADER_EXPANDED_TITLE_FOREGROUND_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setTitleForegroundExpanded((Color)propertyChangeEvent.getNewValue());
            } else if ("HEADER_EXPANDED_TITLE_BACKGROUND_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setTitleBackgroundExpanded((Color)propertyChangeEvent.getNewValue());
            } else if ("PRIMARY_HEADER_COLOR_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setPrimaryColor((Color)propertyChangeEvent.getNewValue());
            } else if ("SECONDARY_HEADER_COLOR_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setSecondaryColor((Color)propertyChangeEvent.getNewValue());
            } else if ("TERTIARY_HEADER_COLOR_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setTertiaryColor((Color)propertyChangeEvent.getNewValue());
            } else if ("PRIMARY_EXPAND_HEADER_COLOR_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setPrimaryColorExpanded((Color)propertyChangeEvent.getNewValue());
            } else if ("SECONDARY_EXPAND_HEADER_COLOR_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setSecondaryColorExpanded((Color)propertyChangeEvent.getNewValue());
            } else if ("TERTIARY_EXPAND_HEADER_COLOR_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.setTertiaryColorExpanded((Color)propertyChangeEvent.getNewValue());
            } else if ("EXPAND_COLLAPSE_ICON_TYPE_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setTitleIcon(BasicTaskPaneTabUI.this.getExpandCollapseIcon());
            } else if ("HIGHLIGHT_TAB".equals(string)) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl) {
                    BasicTaskPaneTabUI.this.header.fadeIn();
                } else {
                    BasicTaskPaneTabUI.this.header.fadeOut();
                }
            }
        }
    }

    protected class TaskPaneTabHeader
    extends JComponent {
        private JPanel headerPanel = null;
        private JLabel iconLabel = null;
        private JLabel titleLabel = null;
        private JTextField titleTextField = null;
        private Vector<JComponent> actionComponents = null;
        private JButton closeBtn = null;
        private int paintingType = -1;
        private Color primHeaderColor;
        private Color secHeaderColor;
        private Color tertHeaderColor;
        private Color primExpHeaderColor;
        private Color secExpHeaderColor;
        private Color tertExpHeaderColor;
        private Color primPaintingColor;
        private Color secPaintingColor;
        private Color tertPaintingColor;
        private boolean colorsOk;
        private boolean autoPaintingColors = true;
        private HeaderColorFader inFader = new HeaderColorFader(this, 20, 100, 5, false);
        private HeaderColorFader outFader = new HeaderColorFader(this, 20, 0, 5, true);
        private HeaderMouseListener headerMouseListener = null;
        protected Image cachedBI = new BufferedImage(1, 1, 1);

        public TaskPaneTabHeader(int n, Color color, Color color2, Color color3, Color color4, Color color5) {
            this.setOpaque(true);
            this.paintingType = n;
            this.primHeaderColor = color3;
            this.secHeaderColor = color4;
            this.tertHeaderColor = color5;
            this.primPaintingColor = color3;
            this.secPaintingColor = color4;
            this.tertPaintingColor = color5;
            boolean bl = this.colorsOk = this.primHeaderColor != null && this.secHeaderColor != null && this.tertHeaderColor != null;
            if (this.primHeaderColor == null) {
                this.primHeaderColor = UIManager.getColor("control");
            }
            this.headerPanel = SwingUtilities2.createPanel(false, null);
            this.iconLabel = new HeaderLabel();
            this.iconLabel.setText(" ");
            this.titleLabel = new HeaderLabel();
            this.titleLabel.addMouseListener(new EditTitleListener());
            this.titleTextField = new TitleTextField();
            this.titleLabel.setVisible(!BasicTaskPaneTabUI.this.tab.isTitleEditing());
            this.titleTextField.setVisible(BasicTaskPaneTabUI.this.tab.isTitleEditing());
            this.headerMouseListener = new HeaderMouseListener();
            this.addMouseListener(this.headerMouseListener);
            this.addMouseMotionListener(this.headerMouseListener);
            this.actionComponents = new Vector();
            this.closeBtn = SwingUtilities2.createButton(BasicTaskPaneTabUI.this.closeIcon);
            this.closeBtn.setVisible(false);
            this.closeBtn.setPreferredSize(new Dimension(20, 20));
            this.closeBtn.setAlignmentY(0.5f);
            this.actionComponents.addElement(this.closeBtn);
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TaskPaneTabHeader.this.firePropertyChange("CLOSE_BUTTON_PRESSED", false, true);
                }
            });
            this.initLayout();
        }

        public String getTitle() {
            return this.titleLabel.getText().trim();
        }

        public void setTitle(String string) {
            String string2 = string != null ? string : "";
            this.titleLabel.setText(String.valueOf(string2) + "   ");
            if (!string2.equals(this.titleTextField.getText())) {
                this.titleTextField.setText(string2);
            }
            this.titleLabel.revalidate();
            this.titleLabel.repaint();
        }

        public Icon getTitleIcon() {
            return this.iconLabel.getIcon();
        }

        public void setTitleIcon(Icon icon) {
            if (this.iconLabel.getIcon() != icon) {
                this.iconLabel.setIcon(icon);
                this.iconLabel.repaint();
            }
        }

        public void setCloseButtonVisible(boolean bl) {
            this.closeBtn.setVisible(bl);
            this.revalidate();
        }

        public Color getTitleForeground() {
            return this.titleLabel.getForeground();
        }

        public Color getTitleBackground() {
            return this.titleLabel.getBackground();
        }

        public Font getTitleFont() {
            return this.titleLabel.getFont();
        }

        public void setTitleForeground(Color color) {
            if (color != null && this.titleLabel.getForeground() != color) {
                this.iconLabel.setForeground(color);
                this.titleLabel.setForeground(color);
                this.titleTextField.setForeground(color);
                this.titleTextField.setSelectedTextColor(this.titleTextField.getBackground());
                this.titleTextField.setSelectionColor(this.titleTextField.getForeground());
                this.repaint();
            }
        }

        public void setTitleBackground(Color color) {
            if (color != null && this.titleLabel.getBackground() != color) {
                this.iconLabel.setBackground(color);
                this.titleLabel.setBackground(color);
                this.titleTextField.setBackground(color);
                this.titleTextField.setSelectedTextColor(this.titleTextField.getBackground());
                this.titleTextField.setSelectionColor(this.titleTextField.getForeground());
                this.repaint();
            }
        }

        public void setTitleFont(Font font) {
            if (font != null && this.titleLabel.getFont() != font) {
                this.iconLabel.setFont(font);
                this.titleLabel.setFont(font);
                this.titleTextField.setFont(font);
                this.repaint();
            }
        }

        public Color getPrimaryColor() {
            return this.primHeaderColor;
        }

        public void setPrimaryColor(Color color) {
            if (color != null && this.primHeaderColor != color) {
                this.primHeaderColor = color;
                this.repaint();
            }
        }

        public Color getSecondaryColor() {
            return this.secHeaderColor;
        }

        public void setSecondaryColor(Color color) {
            if (color != null && this.secHeaderColor != color) {
                this.secHeaderColor = color;
                this.repaint();
            }
        }

        public Color getTertiaryColor() {
            return this.tertHeaderColor;
        }

        public void setTertiaryColor(Color color) {
            if (color != null && this.tertHeaderColor != color) {
                this.tertHeaderColor = color;
                this.repaint();
            }
        }

        public Color getPrimaryColorExpanded() {
            return this.primExpHeaderColor;
        }

        public void setPrimaryColorExpanded(Color color) {
            if (color != null && this.primExpHeaderColor != color) {
                this.primExpHeaderColor = color;
                this.titleLabel.setBackground(color);
                this.titleTextField.setBackground(color);
                this.repaint();
            }
        }

        public Color getSecondaryColorExpanded() {
            return this.secExpHeaderColor;
        }

        public void setSecondaryColorExpanded(Color color) {
            if (color != null && this.secExpHeaderColor != color) {
                this.secExpHeaderColor = color;
                this.repaint();
            }
        }

        public Color getTertiaryColorExpanded() {
            return this.tertExpHeaderColor;
        }

        public void setTertiaryColorExpanded(Color color) {
            if (color != null && this.tertExpHeaderColor != color) {
                this.tertExpHeaderColor = color;
                this.repaint();
            }
        }

        public int getPaintingType() {
            return this.paintingType;
        }

        public void setPaintingType(int n) {
            if (this.paintingType != n) {
                this.paintingType = n;
                boolean bl = this.paintingType != 2;
                this.iconLabel.setOpaque(bl);
                this.titleLabel.setOpaque(bl);
                this.titleTextField.setOpaque(bl);
                this.repaint();
            }
        }

        public void setTitleEditing(boolean bl) {
            if (bl) {
                this.titleTextField.setText(this.titleLabel.getText().trim());
                this.titleTextField.setMinimumSize(this.titleTextField.getPreferredSize());
                this.titleLabel.setVisible(false);
                this.titleTextField.setVisible(true);
            } else {
                this.titleTextField.setVisible(false);
                this.titleLabel.setVisible(true);
            }
            this.revalidate();
            this.repaint();
        }

        public void setExpanded(boolean bl) {
            this.setTitleIcon(BasicTaskPaneTabUI.this.getExpandCollapseIcon());
            this.setTitleBackground(BasicTaskPaneTabUI.this.titleBackgroundExpanded != null ? BasicTaskPaneTabUI.this.titleBackgroundExpanded : BasicTaskPaneTabUI.this.titleBackground);
            this.setTitleForeground(BasicTaskPaneTabUI.this.titleForegroundExpanded != null ? BasicTaskPaneTabUI.this.titleForegroundExpanded : BasicTaskPaneTabUI.this.titleForeground);
            if (bl) {
                this.fadeIn();
            } else {
                this.fadeOut();
            }
        }

        public List<JComponent> getActionComponents() {
            return this.actionComponents;
        }

        public void setActionComponents(List<JComponent> list) {
            this.actionComponents.removeAllElements();
            if (list != null) {
                this.actionComponents.addAll(list);
            }
            this.actionComponents.addElement(this.closeBtn);
            this.initLayout();
            this.revalidate();
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.autoPaintingColors) {
                this.primPaintingColor = this.getPrimaryPaintingColor();
                this.secPaintingColor = this.getSecondaryPaintingColor();
                this.tertPaintingColor = this.getTertiaryPaintingColor();
            }
            super.paintComponent(graphics);
            switch (this.paintingType) {
                case 0: {
                    this.paintPlain(graphics);
                    break;
                }
                case 1: {
                    this.paintStippled(graphics);
                    break;
                }
                case 2: {
                    this.paintScaled(graphics);
                    break;
                }
                case 3: {
                    this.paintOneLined(graphics);
                    break;
                }
                case 4: {
                    this.paintStippledAndScaled(graphics);
                }
            }
        }

        protected void paintPlain(Graphics graphics) {
            Color color = graphics.getColor();
            graphics.setColor(this.primPaintingColor);
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
        }

        protected void paintStippled(Graphics graphics) {
            Insets insets = this.getInsets();
            int n = this.getHeight() - insets.top - insets.bottom;
            int n2 = this.getWidth() - insets.left - insets.right;
            Color color = graphics.getColor();
            graphics.setColor(this.primPaintingColor);
            graphics.fillRect(insets.left, insets.top, n2, n);
            graphics.setColor(this.secPaintingColor);
            int n3 = insets.top;
            while (n3 <= insets.top + n) {
                graphics.drawLine(insets.left, n3, insets.left + n2, n3);
                n3 += 2;
            }
            graphics.setColor(color);
        }

        protected void paintScaled(Graphics graphics) {
            Insets insets = this.getInsets();
            int n = this.getHeight() - insets.top - insets.bottom;
            int n2 = this.getWidth() - insets.left - insets.right;
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                GradientPaint gradientPaint = new GradientPaint(insets.left, insets.top, this.primPaintingColor, insets.left + n2, insets.top + n, this.secPaintingColor);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(insets.left, insets.top, n2, n);
                graphics2D.setPaint(paint);
            } else {
                Color color = graphics.getColor();
                Color color2 = this.primPaintingColor;
                Color color3 = this.secPaintingColor;
                double d = (double)(color3.getRed() - color2.getRed()) / (double)n2;
                double d2 = (double)(color3.getGreen() - color2.getGreen()) / (double)n2;
                double d3 = (double)(color3.getBlue() - color2.getBlue()) / (double)n2;
                int n3 = 0;
                while (n3 < n2) {
                    graphics.setColor(new Color(color2.getRed() + (int)((double)n3 * d), color2.getGreen() + (int)((double)n3 * d2), color2.getBlue() + (int)((double)n3 * d3)));
                    graphics.drawLine(insets.left + n3, insets.top, insets.left + n3, insets.top + n);
                    ++n3;
                }
                graphics.setColor(color);
            }
        }

        protected void paintStippledAndScaled(Graphics graphics) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            if (!this.colorsOk) {
                this.paintPlain(graphics);
                return;
            }
            Insets insets = this.getInsets();
            int n = this.getHeight() - insets.top - insets.bottom;
            int n2 = this.getWidth() - insets.left - insets.right;
            if (this.cachedBI.getWidth(null) != n2 || this.cachedBI.getHeight(null) != n) {
                this.cachedBI = new BufferedImage(n2, n, 1);
                Graphics2D graphics2D = (Graphics2D)this.cachedBI.getGraphics();
                Paint paint = graphics2D.getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.primPaintingColor, 0 + n2, 0 + n, this.tertPaintingColor);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, n2, n);
                GradientPaint gradientPaint2 = new GradientPaint(0.0f, 1.0f, this.secPaintingColor, 0 + n2, 1.0f, this.tertPaintingColor);
                graphics2D.setPaint(gradientPaint2);
                int n3 = 1;
                while (n3 < 0 + n) {
                    graphics2D.drawLine(0, n3, 0 + n2, n3);
                    n3 += 2;
                }
                graphics2D.setPaint(paint);
            }
            graphics.drawImage(this.cachedBI, insets.left, insets.top, null);
        }

        protected void paintOneLined(Graphics graphics) {
            Color color = graphics.getColor();
            Insets insets = this.getInsets();
            int n = 0;
            int n2 = this.getWidth();
            int n3 = insets.top;
            int n4 = this.getHeight() - insets.bottom;
            int n5 = n3 + (n4 - n3) / 2;
            Rectangle rectangle = BasicTaskPaneTabUI.this.tab.isTitleEditable() ? this.titleTextField.getBounds() : this.titleLabel.getBounds();
            graphics.setColor(this.headerPanel.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.primPaintingColor);
            graphics.drawLine(n, n5, this.iconLabel.getBounds().x, n5);
            int n6 = rectangle.x + rectangle.width;
            for (JComponent jComponent : this.actionComponents) {
                if (!jComponent.isVisible() || jComponent instanceof Box.Filler) continue;
                Rectangle rectangle2 = jComponent.getBounds();
                Rectangle rectangle3 = SwingUtilities.convertRectangle(this.headerPanel, rectangle2, this);
                if (n6 + 4 < rectangle3.x - 4) {
                    graphics.drawLine(n6 + 4, n5, rectangle3.x - 4, n5);
                }
                n6 = rectangle3.x + rectangle3.width;
            }
            graphics.drawLine(Math.min(n6 + 4, n2), n5, n2, n5);
            graphics.drawLine(n, n5, n, n4);
            graphics.drawLine(n2 - 1, n5, n2 - 1, n4);
            if (!BasicTaskPaneTabUI.this.tab.isExpanded()) {
                graphics.drawLine(n, n4 - 1, n2, n4 - 1);
            }
            graphics.setColor(color);
        }

        protected void initLayout() {
            this.removeAll();
            this.headerPanel.removeAll();
            this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 0));
            for (JComponent jComponent : this.actionComponents) {
                jComponent.setAlignmentY(0.5f);
                Dimension dimension = jComponent.getMaximumSize();
                jComponent.setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
                this.headerPanel.add(jComponent);
            }
            int n = BasicTaskPaneTabUI.this.tab.getHeaderBorderSize();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.setConstraints(this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(n + 1, 2 * n, n + 1, 0), 0, 0));
            gridBagLayout.setConstraints(this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(n + 1, 0, n + 1, 0), 0, 0));
            gridBagLayout.setConstraints(this.titleTextField, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            gridBagLayout.setConstraints(this.headerPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(n, 2 * n, n, 2 * n), 0, 0));
            this.setBorder(new HeaderBorder(this));
            this.setLayout(gridBagLayout);
            this.add(this.iconLabel);
            this.add(this.titleLabel);
            this.add(this.titleTextField);
            this.add(this.headerPanel);
        }

        @Override
        public Color getBackground() {
            return this.secPaintingColor;
        }

        private Color getPrimaryPaintingColor() {
            if (BasicTaskPaneTabUI.this.tab.isColorFadingEnabled() && BasicTaskPaneTabUI.this.tab.isExpanded() && this.primExpHeaderColor != null) {
                return this.primExpHeaderColor;
            }
            return this.primHeaderColor;
        }

        private Color getSecondaryPaintingColor() {
            if (BasicTaskPaneTabUI.this.tab.isColorFadingEnabled() && BasicTaskPaneTabUI.this.tab.isExpanded() && this.secExpHeaderColor != null) {
                return this.secExpHeaderColor;
            }
            return this.secHeaderColor;
        }

        private Color getTertiaryPaintingColor() {
            if (BasicTaskPaneTabUI.this.tab.isColorFadingEnabled() && BasicTaskPaneTabUI.this.tab.isExpanded() && this.tertExpHeaderColor != null) {
                return this.tertExpHeaderColor;
            }
            return this.tertHeaderColor;
        }

        private void fadeIn() {
            if (this.outFader != null) {
                this.outFader.stop();
            }
            if (BasicTaskPaneTabUI.this.tab.isColorFadingEnabled() && !BasicTaskPaneTabUI.this.tab.isExpanded() && !this.inFader.isRunning()) {
                this.inFader.start();
                BasicTaskPaneTabUI.this.header.titleLabel.setFont(BasicTaskPaneTabUI.this.header.titleLabel.getFont().deriveFont(1));
            }
        }

        private void fadeOut() {
            if (this.inFader.isRunning()) {
                this.inFader.stop();
            }
            if (BasicTaskPaneTabUI.this.tab.isColorFadingEnabled() && !BasicTaskPaneTabUI.this.tab.isExpanded() && !this.outFader.isRunning()) {
                this.outFader.start();
                BasicTaskPaneTabUI.this.header.titleLabel.setFont(BasicTaskPaneTabUI.this.header.titleLabel.getFont().deriveFont(0));
            }
        }

        private class EditTitleListener
        extends MouseAdapter
        implements AWTEventListener,
        DocumentListener,
        ActionListener {
            private EditTitleListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.isTitleEditable() && !((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.isTitleEditing()) {
                    ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.setTitleEditing(true);
                    TaskPaneTabHeader.this.titleTextField.requestFocusInWindow();
                    TaskPaneTabHeader.this.titleTextField.select(0, TaskPaneTabHeader.this.titleTextField.getDocument().getLength());
                    TaskPaneTabHeader.this.titleTextField.addActionListener(this);
                    TaskPaneTabHeader.this.titleTextField.getDocument().addDocumentListener(this);
                    Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
                }
            }

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                Window window;
                Window window2;
                MouseEvent mouseEvent;
                if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getID() == 501 && mouseEvent.getComponent() != TaskPaneTabHeader.this.titleTextField && (window2 = mouseEvent.getComponent() instanceof Window ? (Window)mouseEvent.getComponent() : SwingUtilities.windowForComponent(mouseEvent.getComponent())) == (window = SwingUtilities.windowForComponent(TaskPaneTabHeader.this.titleTextField))) {
                    ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.setTitleEditing(false);
                    TaskPaneTabHeader.this.titleTextField.getDocument().removeDocumentListener(this);
                    TaskPaneTabHeader.this.titleTextField.removeActionListener(this);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Toolkit.getDefaultToolkit().removeAWTEventListener(EditTitleListener.this);
                        }
                    });
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateTitle(TaskPaneTabHeader.this.titleTextField.getText());
                TaskPaneTabHeader.this.titleTextField.setMinimumSize(TaskPaneTabHeader.this.titleTextField.getPreferredSize());
                TaskPaneTabHeader.this.revalidate();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateTitle(TaskPaneTabHeader.this.titleTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateTitle(TaskPaneTabHeader.this.titleTextField.getText());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.setTitleEditing(false);
            }

            private void updateTitle(String string) {
                String string2 = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.getTitle();
                if (string2 == null || !string2.equals(string)) {
                    ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.setTitle(string);
                }
            }
        }

        private class HeaderBorder
        extends LineBorder {
            private static final long serialVersionUID = 4779839061533600822L;
            private TaskPaneTabHeader header;

            public HeaderBorder(TaskPaneTabHeader taskPaneTabHeader2) {
                super(Color.BLACK, 1, false);
                this.header = taskPaneTabHeader2;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                this.lineColor = this.findBorderColor().darker();
                this.thickness = 3 == ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.getHeaderPaintingType() ? 0 : 1;
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }

            private Color findBorderColor() {
                return ColorUtils.isBrighter(this.header.primPaintingColor, this.header.secPaintingColor) ? this.header.secPaintingColor : this.header.primPaintingColor;
            }
        }

        private class HeaderColorFader
        implements ActionListener {
            private Timer timer = new Timer(75, this);
            private boolean reverse = false;
            private int totalSteps = 10;
            private int steps = 0;
            private Color startPrimaryColor = null;
            private Color startSecondaryColor = null;
            private Color startTertiaryColor = null;
            private Color endPrimaryColor = null;
            private Color endSecondaryColor = null;
            private Color endTertiaryColor = null;

            public HeaderColorFader(TaskPaneTabHeader taskPaneTabHeader2, int n, int n2, int n3, boolean bl) {
                this.reverse = bl;
                this.totalSteps = n3;
                this.steps = 0;
                this.timer.setDelay(n);
                this.timer.setInitialDelay(n2);
            }

            public void start() {
                boolean bl;
                boolean bl2 = bl = this.reverse ? this.prepareReverse() : this.prepare();
                if (bl) {
                    this.steps = 0;
                    ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.autoPaintingColors = false;
                    this.timer.restart();
                }
            }

            public void stop() {
                ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.autoPaintingColors = true;
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            }

            public boolean isRunning() {
                return this.timer.isRunning();
            }

            public boolean prepare() {
                Color color = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getPrimaryColorExpanded();
                Color color2 = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getSecondaryColorExpanded();
                Color color3 = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getTertiaryColorExpanded();
                if (color.equals(TaskPaneTabHeader.this.primPaintingColor) && color2.equals(TaskPaneTabHeader.this.secPaintingColor) && color3.equals(TaskPaneTabHeader.this.tertPaintingColor)) {
                    return false;
                }
                this.startPrimaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getPrimaryColor();
                this.startSecondaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getSecondaryColor();
                this.startTertiaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getTertiaryColor();
                this.endPrimaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getPrimaryColorExpanded();
                this.endSecondaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getSecondaryColorExpanded();
                this.endTertiaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getTertiaryColorExpanded();
                return true;
            }

            public boolean prepareReverse() {
                Color color = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getPrimaryColor();
                Color color2 = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getSecondaryColor();
                Color color3 = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getTertiaryColor();
                if (color.equals(TaskPaneTabHeader.this.primPaintingColor) && color2.equals(TaskPaneTabHeader.this.secPaintingColor) && color3.equals(TaskPaneTabHeader.this.tertPaintingColor)) {
                    return false;
                }
                this.startPrimaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getPrimaryColorExpanded();
                this.startSecondaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getSecondaryColorExpanded();
                this.startTertiaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getTertiaryColorExpanded();
                this.endPrimaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getPrimaryColor();
                this.endSecondaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getSecondaryColor();
                this.endTertiaryColor = ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.getTertiaryColor();
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = (double)(this.endPrimaryColor.getRed() - this.startPrimaryColor.getRed()) / (double)this.totalSteps;
                double d2 = (double)(this.endPrimaryColor.getGreen() - this.startPrimaryColor.getGreen()) / (double)this.totalSteps;
                double d3 = (double)(this.endPrimaryColor.getBlue() - this.startPrimaryColor.getBlue()) / (double)this.totalSteps;
                int n = (int)((double)this.startPrimaryColor.getRed() + d * (double)this.steps);
                int n2 = (int)((double)this.startPrimaryColor.getGreen() + d2 * (double)this.steps);
                int n3 = (int)((double)this.startPrimaryColor.getBlue() + d3 * (double)this.steps);
                d = (double)(this.endSecondaryColor.getRed() - this.startSecondaryColor.getRed()) / (double)this.totalSteps;
                d2 = (double)(this.endSecondaryColor.getGreen() - this.startSecondaryColor.getGreen()) / (double)this.totalSteps;
                d3 = (double)(this.endSecondaryColor.getBlue() - this.startSecondaryColor.getBlue()) / (double)this.totalSteps;
                int n4 = (int)((double)this.startSecondaryColor.getRed() + d * (double)this.steps);
                int n5 = (int)((double)this.startSecondaryColor.getGreen() + d2 * (double)this.steps);
                int n6 = (int)((double)this.startSecondaryColor.getBlue() + d3 * (double)this.steps);
                d = (double)(this.endTertiaryColor.getRed() - this.startTertiaryColor.getRed()) / (double)this.totalSteps;
                d2 = (double)(this.endTertiaryColor.getGreen() - this.startTertiaryColor.getGreen()) / (double)this.totalSteps;
                d3 = (double)(this.endTertiaryColor.getBlue() - this.startTertiaryColor.getBlue()) / (double)this.totalSteps;
                int n7 = (int)((double)this.startTertiaryColor.getRed() + d * (double)this.steps);
                int n8 = (int)((double)this.startTertiaryColor.getGreen() + d2 * (double)this.steps);
                int n9 = (int)((double)this.startTertiaryColor.getBlue() + d3 * (double)this.steps);
                ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.primPaintingColor = new Color(n, n2, n3);
                ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.secPaintingColor = new Color(n4, n5, n6);
                ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.tertPaintingColor = new Color(n7, n8, n9);
                ((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.header.repaint();
                if (this.steps >= this.totalSteps) {
                    this.timer.stop();
                } else {
                    ++this.steps;
                }
            }
        }

        private class HeaderLabel
        extends JLabel {
            private Font f = null;

            public HeaderLabel() {
                this.setOpaque(TaskPaneTabHeader.this.paintingType != 2);
                this.setHorizontalAlignment(2);
                if (((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleBackground == null) {
                    this.setBackground(TaskPaneTabHeader.this.secPaintingColor);
                } else {
                    this.setBackground(((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleBackground);
                }
                this.setForeground(((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleForeground);
                this.f = super.getFont();
            }

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                super.processMouseEvent(mouseEvent);
                TaskPaneTabHeader.this.processMouseEvent(mouseEvent);
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                super.processMouseMotionEvent(mouseEvent);
                TaskPaneTabHeader.this.processMouseMotionEvent(mouseEvent);
            }

            @Override
            public Color getBackground() {
                if (((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleBackground == null && TaskPaneTabHeader.this.primPaintingColor != null) {
                    return TaskPaneTabHeader.this.secPaintingColor;
                }
                return super.getBackground();
            }

            @Override
            public Font getFont() {
                return this.f;
            }

            @Override
            public void setFont(Font font) {
                this.f = font;
                super.setFont(font);
            }
        }

        private class HeaderMouseListener
        extends MouseAdapter {
            private boolean enterDelay = true;
            private boolean exitInDelay = false;

            private HeaderMouseListener() {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (TaskPaneTabHeader.this.outFader != null) {
                    TaskPaneTabHeader.this.outFader.stop();
                }
                this.enterDelay = true;
                this.exitInDelay = false;
                if (!((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.isTitleEditable()) {
                    new Timer(250, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!HeaderMouseListener.this.exitInDelay) {
                                if (((TaskPaneTabHeader)((HeaderMouseListener)HeaderMouseListener.this).TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.isMouseHoverEnabled()) {
                                    TaskPaneTabHeader.this.setCursor(Cursor.getPredefinedCursor(12));
                                }
                                TaskPaneTabHeader.this.fadeIn();
                            }
                            HeaderMouseListener.this.enterDelay = false;
                            ((Timer)actionEvent.getSource()).stop();
                        }
                    }).start();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.isMouseHoverEnabled()) {
                    TaskPaneTabHeader.this.setCursor(Cursor.getDefaultCursor());
                }
                if (this.enterDelay) {
                    this.exitInDelay = true;
                }
                if (TaskPaneTabHeader.this.inFader.isRunning()) {
                    TaskPaneTabHeader.this.inFader.stop();
                }
                TaskPaneTabHeader.this.fadeOut();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.tab.isMouseHoverEnabled() && !this.enterDelay) {
                    TaskPaneTabHeader.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        private class TitleTextField
        extends JTextField {
            public TitleTextField() {
                if (((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleBackground == null) {
                    this.setBackground(TaskPaneTabHeader.this.secPaintingColor);
                } else {
                    this.setBackground(((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleBackground);
                }
                this.setForeground(((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleForeground);
            }

            @Override
            public Color getBackground() {
                if (((TaskPaneTabHeader)TaskPaneTabHeader.this).BasicTaskPaneTabUI.this.titleBackground == null && TaskPaneTabHeader.this.primPaintingColor != null) {
                    return TaskPaneTabHeader.this.secPaintingColor;
                }
                return super.getBackground();
            }
        }
    }
}

