/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class TriStateRowSorter<M extends TableModel>
extends TableRowSorter<M> {
    public TriStateRowSorter(M m) {
        super(m);
    }

    @Override
    public void toggleSortOrder(int n) {
        if (n < 0 || n >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
        if (this.isSortable(n)) {
            List<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            int n2 = list.size() - 1;
            while (n2 >= 0) {
                if (((RowSorter.SortKey)list.get(n2)).getColumn() == n) break;
                --n2;
            }
            if (n2 == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(n, SortOrder.ASCENDING);
                list.add(0, sortKey);
            } else if (n2 == 0) {
                list.set(0, this.toggle((RowSorter.SortKey)list.get(0)));
            } else {
                list.remove(n2);
                list.add(0, new RowSorter.SortKey(n, SortOrder.ASCENDING));
            }
            if (list.size() > this.getMaxSortKeys()) {
                list = list.subList(0, this.getMaxSortKeys());
            }
            this.setSortKeys(list);
        }
    }

    protected RowSorter.SortKey toggle(RowSorter.SortKey sortKey) {
        if (sortKey.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(sortKey.getColumn(), SortOrder.DESCENDING);
        }
        if (sortKey.getSortOrder() == SortOrder.DESCENDING) {
            return new RowSorter.SortKey(sortKey.getColumn(), SortOrder.UNSORTED);
        }
        return new RowSorter.SortKey(sortKey.getColumn(), SortOrder.ASCENDING);
    }
}

