/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MouseInfo;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class PopupController {
    private static final ALogger log = ALogger.getLogger(PopupController.class);
    private Container parent;
    private JComponent contentPanel;
    private Alignment alignment;
    private String title;
    private State currentState;
    private Color indicatorBg;
    private Color popupBg;
    private int openPopupDelay;
    private PopupWindowController popupController;
    private FloatingWindowController floatingController;

    public PopupController(Container container, JComponent jComponent, Alignment alignment, State state, String string) {
        this(container, jComponent, alignment, state, string, 0);
    }

    public PopupController(Container container, JComponent jComponent, Alignment alignment, State state, String string, int n) {
        this.parent = container;
        this.contentPanel = this.createContentPanel(jComponent);
        this.alignment = alignment;
        this.title = string;
        this.openPopupDelay = n;
        if (state != null) {
            this.installInitialState(state);
        }
    }

    public State getState() {
        return this.currentState;
    }

    public void setState(State state) throws Exception {
        if (State.Docked.equals((Object)state)) {
            this.setDocked();
        } else if (State.Popup.equals((Object)state)) {
            this.setPopup();
        } else if (State.Floating.equals((Object)state)) {
            this.setFloating();
        }
    }

    public boolean isDocked() {
        return State.Docked.equals((Object)this.currentState);
    }

    public boolean isPopup() {
        return State.Popup.equals((Object)this.currentState);
    }

    public boolean isFloating() {
        return State.Floating.equals((Object)this.currentState);
    }

    public void setDocked() throws Exception {
        if (this.isDocked()) {
            return;
        }
        if (this.isPopup()) {
            this.uninstallPopupState();
        } else if (this.isFloating()) {
            this.uninstallFloatingState();
        }
        this.installDockedState();
    }

    public void setPopup() throws Exception {
        if (this.isPopup()) {
            return;
        }
        if (this.isDocked()) {
            this.uninstallDockedState();
        } else if (this.isFloating()) {
            this.uninstallFloatingState();
        }
        this.installPopupState();
    }

    public void setPopup(boolean bl) throws Exception {
        if (!this.isPopup()) {
            this.setPopup();
        }
        if (bl) {
            this.popupController.openPopup();
        }
    }

    public void setFloating() throws Exception {
        if (this.isFloating()) {
            return;
        }
        if (this.isDocked()) {
            this.uninstallDockedState();
        } else if (this.isPopup()) {
            this.uninstallPopupState();
        }
        this.installFloatingState();
    }

    public Color getPopupIndicatorBackground() {
        return this.indicatorBg;
    }

    public void setPopupIndicatorBackground(Color color) {
        this.indicatorBg = color;
    }

    public Color getPopupWindowBackground() {
        return this.popupBg;
    }

    public void setPopupWindowBackground(Color color) {
        this.popupBg = color;
    }

    protected boolean canClosePopup() {
        return true;
    }

    private void uninstallDockedState() throws Exception {
        this.parent.remove(this.contentPanel);
        this.parent.invalidate();
        this.parent.validate();
    }

    private void uninstallPopupState() throws Exception {
        this.popupController.uninstall();
        this.popupController = null;
    }

    private void uninstallFloatingState() throws Exception {
        this.floatingController.uninstall();
        this.floatingController = null;
    }

    private void installState(State state) throws Exception {
        if (State.Docked.equals((Object)state)) {
            this.installDockedState();
        } else if (State.Popup.equals((Object)state)) {
            this.installPopupState();
        } else if (State.Floating.equals((Object)state)) {
            this.installFloatingState();
        }
    }

    private void installDockedState() throws Exception {
        if (!(this.parent.getLayout() instanceof BorderLayout)) {
            this.parent.setLayout(new BorderLayout());
        }
        this.parent.add((Component)this.contentPanel, this.alignment.toBorderLayoutConstraint());
        this.parent.invalidate();
        this.parent.validate();
        this.currentState = State.Docked;
    }

    private void installPopupState() throws Exception {
        this.popupController = new PopupWindowController(this.createPopupIndicator());
        this.popupController.install();
        this.currentState = State.Popup;
    }

    private void installFloatingState() throws Exception {
        Window window = this.createFloatingWindow();
        this.floatingController = new FloatingWindowController(window);
        this.floatingController.install();
        this.currentState = State.Floating;
    }

    private JComponent createContentPanel(JComponent jComponent) {
        JPanel jPanel = SwingUtilities2.createPanel(false, null);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    protected Window createFloatingWindow() {
        JDialog jDialog = new JDialog(SwingUtilities.windowForComponent(this.parent), this.title);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)this.contentPanel, "Center");
        jDialog.setSize(0, 0);
        if (this.popupBg != null) {
            jDialog.getContentPane().setBackground(this.popupBg);
            jDialog.setBackground(this.popupBg);
        }
        return jDialog;
    }

    protected JWindow createPopupWindow() {
        JWindow jWindow = new JWindow(SwingUtilities.windowForComponent(this.parent));
        jWindow.getContentPane().setLayout(new BorderLayout());
        jWindow.getContentPane().add((Component)this.contentPanel, "Center");
        if (this.popupBg != null) {
            jWindow.getContentPane().setBackground(this.popupBg);
            jWindow.setBackground(this.popupBg);
        }
        return jWindow;
    }

    protected JComponent createPopupIndicator() {
        DefaultPopupIndicator defaultPopupIndicator = new DefaultPopupIndicator();
        if (Alignment.Left.equals((Object)this.alignment) || Alignment.Right.equals((Object)this.alignment)) {
            defaultPopupIndicator.setPreferredSize(GUI.getScaledDimension((int)10, (int)100));
        } else {
            defaultPopupIndicator.setPreferredSize(GUI.getScaledDimension((int)100, (int)10));
        }
        return defaultPopupIndicator;
    }

    private void installInitialState(final State state) {
        if (this.parent.isValid() || State.Docked.equals((Object)state)) {
            try {
                this.installState(state);
            }
            catch (Exception exception) {
                log.error("Installing initial state failed!", (Throwable)exception);
            }
        } else {
            this.parent.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (PopupController.this.currentState == null && PopupController.this.parent.isValid()) {
                        try {
                            PopupController.this.installState(state);
                        }
                        catch (Exception exception) {
                            log.error("Installing initial state failed!", (Throwable)exception);
                        }
                    }
                }
            });
        }
    }

    public static enum Alignment {
        Top,
        Left,
        Bottom,
        Right;


        public String toBorderLayoutConstraint() {
            if (Top.equals((Object)this)) {
                return "North";
            }
            if (Left.equals((Object)this)) {
                return "West";
            }
            if (Bottom.equals((Object)this)) {
                return "South";
            }
            return "East";
        }
    }

    private class DefaultPopupIndicator
    extends JComponent {
        private DefaultPopupIndicator() {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Area area = this.createPopupIndicatorArea();
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setPaint(this.createAreaPaint(area));
                ((Graphics2D)graphics).fill(area);
            }
            Polygon polygon = null;
            int n = (int)((double)this.getWidth() * 0.2 + 0.5);
            int n2 = (int)((double)((float)this.getWidth() / 2.0f) * 0.95);
            int n3 = this.getHeight() / 2;
            if (Alignment.Left.equals((Object)PopupController.this.alignment)) {
                polygon = new Polygon(new int[]{n2 - n, n2 + n, n2 - n}, new int[]{n3 - n * 2, n3, n3 + n * 2}, 3);
            } else if (Alignment.Right.equals((Object)PopupController.this.alignment)) {
                polygon = new Polygon(new int[]{n2 + n, n2 - n, n2 + n}, new int[]{n3 - n * 2, n3, n3 + n * 2}, 3);
            } else if (Alignment.Top.equals((Object)PopupController.this.alignment)) {
                polygon = new Polygon(new int[]{n2 - n * 2, n2, n2 + n * 2}, new int[]{n3 - n, n3 + n, n3 - n}, 3);
            } else if (Alignment.Bottom.equals((Object)PopupController.this.alignment)) {
                polygon = new Polygon(new int[]{n2 - n * 2, n2, n2 + n * 2}, new int[]{n3 + n, n3 - n, n3 + n}, 3);
            }
            if (polygon != null) {
                graphics.setColor(new Color(204, 204, 204, 255));
                graphics.fillPolygon(polygon);
            }
        }

        private Area createPopupIndicatorArea() {
            int n = GUI.getScaledInt((int)15);
            Area area = new Area();
            if (Alignment.Left.equals((Object)PopupController.this.alignment) || Alignment.Right.equals((Object)PopupController.this.alignment)) {
                float f = this.getWidth();
                float f2 = this.getHeight();
                if (Alignment.Left.equals((Object)PopupController.this.alignment)) {
                    area.add(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, f, f2, n, n)));
                    area.add(new Area(new Rectangle2D.Float(0.0f, 0.0f, f - (float)(n / 2), f2)));
                } else {
                    area.add(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, f, f2, n, n)));
                    area.add(new Area(new Rectangle2D.Float(n / 2, 0.0f, f - (float)(n / 2), f2)));
                }
            } else {
                float f = this.getWidth();
                float f3 = this.getHeight();
                if (Alignment.Top.equals((Object)PopupController.this.alignment)) {
                    area.add(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, f, f3, n, n)));
                    area.add(new Area(new Rectangle2D.Float(0.0f, 0.0f, f, f3 - (float)n)));
                } else {
                    area.add(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, f, f3, n, n)));
                    area.add(new Area(new Rectangle2D.Float(0.0f, n, f, f3 - (float)n)));
                }
            }
            return area;
        }

        private Paint createAreaPaint(Area area) {
            Rectangle rectangle = area.getBounds();
            Color color = PopupController.this.indicatorBg != null ? PopupController.this.indicatorBg : UIManager.getColor("control");
            Color color2 = ColorUtils.brighter(color, 0.75f);
            Color color3 = ColorUtils.brighter(color, 0.25f);
            if (Alignment.Left.equals((Object)PopupController.this.alignment)) {
                return new LinearGradientPaint(rectangle.x, (float)rectangle.getCenterY(), rectangle.x + rectangle.width, (float)rectangle.getCenterY(), new float[]{0.0f, 0.4f, 0.9f, 1.0f}, new Color[]{color, color, color2, color3});
            }
            if (Alignment.Right.equals((Object)PopupController.this.alignment)) {
                return new LinearGradientPaint(rectangle.x, (float)rectangle.getCenterY(), rectangle.x + rectangle.width, (float)rectangle.getCenterY(), new float[]{0.0f, 0.1f, 0.6f, 1.0f}, new Color[]{color3, color2, color, color});
            }
            if (Alignment.Top.equals((Object)PopupController.this.alignment)) {
                return new LinearGradientPaint((float)rectangle.getCenterX(), rectangle.y, (float)rectangle.getCenterX(), rectangle.y + rectangle.height, new float[]{0.0f, 0.4f, 0.9f, 1.0f}, new Color[]{color, color, color2, color3});
            }
            if (Alignment.Bottom.equals((Object)PopupController.this.alignment)) {
                return new LinearGradientPaint((float)rectangle.getCenterX(), rectangle.y, (float)rectangle.getCenterX(), rectangle.y + rectangle.height, new float[]{0.0f, 0.1f, 0.6f, 1.0f}, new Color[]{color3, color2, color, color});
            }
            return null;
        }
    }

    private class FloatingWindowController {
        private Window window;

        public FloatingWindowController(Window window) {
            this.window = window;
        }

        public void install() {
            if (this.window.isVisible()) {
                return;
            }
            this.window.pack();
            int n = PopupController.this.parent.getWidth();
            int n2 = PopupController.this.parent.getHeight();
            int n3 = ((PopupController)PopupController.this).parent.getLocationOnScreen().x;
            int n4 = ((PopupController)PopupController.this).parent.getLocationOnScreen().y + ((PopupController)PopupController.this).parent.getInsets().top;
            int n5 = 0;
            Dimension dimension = new Dimension();
            dimension.width = this.window.getPreferredSize().width;
            dimension.height = n2 - ((PopupController)PopupController.this).parent.getInsets().top - ((PopupController)PopupController.this).parent.getInsets().bottom;
            if (PopupController.this.parent.getComponentCount() > 0) {
                int n6 = ((BorderLayout)PopupController.this.parent.getLayout()).getVgap();
                Component[] componentArray = PopupController.this.parent.getComponents();
                int n7 = componentArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    Component component = componentArray[n8];
                    String string = (String)((BorderLayout)PopupController.this.parent.getLayout()).getConstraints(component);
                    if ("North".equals(string) || "South".equals(string)) {
                        dimension.height -= component.getSize().height;
                        dimension.height -= n6;
                        if ("North".equals(string)) {
                            n5 = component.getSize().height + n6;
                        }
                    }
                    ++n8;
                }
            }
            this.window.setSize(dimension);
            Point point = new Point(0, 0);
            if (Alignment.Top.equals((Object)PopupController.this.alignment)) {
                point.x = n3 + n / 2 - dimension.width / 2;
                point.y = n4 + n5;
            } else if (Alignment.Bottom.equals((Object)PopupController.this.alignment)) {
                point.x = n3 + n / 2 - dimension.width / 2;
                point.y = n4 + n5 + n2 - dimension.height;
            } else if (Alignment.Left.equals((Object)PopupController.this.alignment)) {
                point.x = n3;
                point.y = n4 + n5;
            } else if (Alignment.Right.equals((Object)PopupController.this.alignment)) {
                point.x = n3 + n - dimension.width;
                point.y = n4 + n5;
            }
            SwingUtilities.convertPointFromScreen(point, this.window.getOwner());
            this.window.setLocation(point);
            this.window.setVisible(true);
        }

        public void uninstall() {
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
        }
    }

    private class PopupWindowController {
        private JComponent indicator;
        private JWindow popup;
        private MouseAdapter showPopupListener;
        private ActionListener closePopupListener;
        private ActionListener openPopupListener;
        private Timer closePopupTimer;
        private Timer openPopupTimer;

        public PopupWindowController(final JComponent jComponent) {
            this.indicator = jComponent;
            this.showPopupListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    PopupWindowController.this.openPopupTimer.restart();
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    PopupWindowController.this.openPopupTimer.restart();
                }
            };
            this.closePopupListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PopupWindowController.this.popup != null && PopupWindowController.this.popup.isVisible()) {
                        Point point = MouseInfo.getPointerInfo().getLocation();
                        Point point2 = PopupWindowController.this.popup.getLocationOnScreen();
                        Rectangle rectangle = new Rectangle(point2.x, point2.y, PopupWindowController.this.popup.getWidth(), PopupWindowController.this.popup.getHeight());
                        int n = GUI.getScaledInt((int)5);
                        if (Alignment.Left.equals((Object)PopupController.this.alignment) || Alignment.Right.equals((Object)PopupController.this.alignment)) {
                            rectangle.x -= n;
                            rectangle.width += n * 2;
                        } else if (Alignment.Top.equals((Object)PopupController.this.alignment) || Alignment.Bottom.equals((Object)PopupController.this.alignment)) {
                            rectangle.y -= n;
                            rectangle.height += n * 2;
                        }
                        if (!rectangle.contains(point) && PopupController.this.canClosePopup()) {
                            PopupWindowController.this.closePopup();
                        }
                    }
                }
            };
            this.openPopupListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    if ((PopupWindowController.this.popup == null || !PopupWindowController.this.popup.isVisible()) && jComponent.isVisible()) {
                        Point point = MouseInfo.getPointerInfo().getLocation();
                        Point point2 = jComponent.getLocationOnScreen();
                        Rectangle rectangle = new Rectangle(point2.x, point2.y, jComponent.getWidth(), jComponent.getHeight());
                        if (rectangle.contains(point)) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        PopupWindowController.this.openPopup();
                    }
                }
            };
            this.closePopupTimer = new Timer(100, this.closePopupListener);
            this.openPopupTimer = new Timer(PopupController.this.openPopupDelay, this.openPopupListener);
            this.openPopupTimer.setRepeats(false);
        }

        public void install() {
            this.indicator.addMouseListener(this.showPopupListener);
            this.indicator.addMouseMotionListener(this.showPopupListener);
            PopupController.this.parent.add((Component)this.indicator, PopupController.this.alignment.toBorderLayoutConstraint());
            PopupController.this.parent.invalidate();
            PopupController.this.parent.validate();
        }

        public void uninstall() {
            this.indicator.removeMouseListener(this.showPopupListener);
            this.indicator.removeMouseMotionListener(this.showPopupListener);
            PopupController.this.parent.remove(this.indicator);
            PopupController.this.parent.invalidate();
            PopupController.this.parent.validate();
            if (this.popup != null) {
                this.popup.setVisible(false);
                this.popup.dispose();
            }
            this.indicator = null;
            this.popup = null;
        }

        private void openPopup() {
            if (this.popup == null) {
                this.popup = PopupController.this.createPopupWindow();
            }
            if (this.popup.isVisible()) {
                return;
            }
            Point point = this.indicator.getLocationOnScreen();
            Dimension dimension = new Dimension(100, 100);
            if (Alignment.Left.equals((Object)PopupController.this.alignment) || Alignment.Right.equals((Object)PopupController.this.alignment)) {
                dimension.width = ((PopupController)PopupController.this).contentPanel.getPreferredSize().width;
                dimension.height = this.indicator.getHeight();
            } else {
                dimension.width = this.indicator.getWidth();
                dimension.height = ((PopupController)PopupController.this).contentPanel.getPreferredSize().height;
            }
            this.popup.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.popup.setVisible(true);
            this.closePopupTimer.restart();
        }

        private void closePopup() {
            this.closePopupTimer.stop();
            this.popup.setVisible(false);
        }
    }

    public static enum State {
        Docked,
        Popup,
        Floating;

    }
}

