/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Line2D;
import javax.swing.JComponent;

public class JSeparator2
extends JComponent {
    private static final long serialVersionUID = -5710890934737187796L;
    private SeparatorType type = SeparatorType.LINE;
    private SeparatorOrientation orientation = SeparatorOrientation.HORIZONTAL;
    private Color c;

    public JSeparator2(SeparatorOrientation separatorOrientation, SeparatorType separatorType, Color color, Dimension dimension) {
        this.orientation = separatorOrientation != null ? separatorOrientation : SeparatorOrientation.HORIZONTAL;
        this.type = separatorType != null ? separatorType : SeparatorType.LINE;
        this.c = color;
        if (dimension != null) {
            this.setPreferredSize(dimension);
        }
    }

    public JSeparator2(SeparatorOrientation separatorOrientation, SeparatorType separatorType, Dimension dimension) {
        this(separatorOrientation, separatorType, null, dimension);
    }

    public JSeparator2(SeparatorType separatorType, Dimension dimension) {
        this(null, separatorType, dimension);
    }

    public JSeparator2(SeparatorType separatorType) {
        this(null, separatorType, null);
    }

    public JSeparator2() {
        this(null, null, null);
    }

    public SeparatorType getSeparatorType() {
        return this.type;
    }

    public SeparatorOrientation getSeparatorOrientation() {
        return this.orientation;
    }

    public void setSeparatorType(SeparatorType separatorType) {
        this.type = separatorType;
    }

    public void setSeparatorOrientation(SeparatorOrientation separatorOrientation) {
        this.orientation = separatorOrientation;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = graphics.getColor();
        graphics.setColor(this.c != null ? this.c : this.getBackground().brighter().brighter());
        if (this.type == SeparatorType.NONE) {
            return;
        }
        if (this.type == SeparatorType.LINE) {
            this.paintLineSeparator(graphics);
        } else if (this.type == SeparatorType.DASHED && graphics instanceof Graphics2D) {
            this.paintDashedLineSeparator((Graphics2D)graphics);
        } else if (this.type == SeparatorType.DOUBLE_DASHED && graphics instanceof Graphics2D) {
            this.paintDoubleDashedLineSeparator((Graphics2D)graphics);
        } else if (this.type == SeparatorType.FILLED) {
            this.paintFilled(graphics);
        }
        graphics.setColor(color);
    }

    protected void paintLineSeparator(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getHeight() - insets.top - insets.bottom;
        int n2 = this.getWidth() - insets.left - insets.right;
        int n3 = insets.top + n / 2;
        int n4 = insets.left + n2 / 2;
        if (this.orientation == SeparatorOrientation.HORIZONTAL) {
            graphics.drawLine(insets.left, n3, insets.left + n2, n3);
        } else if (this.orientation == SeparatorOrientation.VERTICAL) {
            graphics.drawLine(n4, insets.top, n4, insets.top + n);
        }
    }

    protected void paintFilled(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getHeight() - insets.top - insets.bottom;
        int n2 = this.getWidth() - insets.left - insets.right;
        graphics.fillRect(0, 0, n2, n);
    }

    protected void paintDashedLineSeparator(Graphics2D graphics2D) {
        Insets insets = this.getInsets();
        int n = this.getHeight() - insets.top - insets.bottom;
        int n2 = this.getWidth() - insets.left - insets.right;
        int n3 = insets.top + n / 2;
        int n4 = insets.left + n2 / 2;
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
        graphics2D.setStroke(basicStroke);
        if (this.orientation == SeparatorOrientation.HORIZONTAL) {
            graphics2D.draw(new Line2D.Double(insets.left, n3, n2, n3));
        } else if (this.orientation == SeparatorOrientation.VERTICAL) {
            graphics2D.draw(new Line2D.Double(n4, insets.top, n4, insets.top + n));
        }
    }

    protected void paintDoubleDashedLineSeparator(Graphics2D graphics2D) {
        Insets insets = this.getInsets();
        int n = this.getHeight() - insets.top - insets.bottom;
        int n2 = this.getWidth() - insets.left - insets.right;
        int n3 = insets.top + n / 2;
        int n4 = insets.left + n2 / 2;
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
        graphics2D.setStroke(basicStroke);
        if (this.orientation == SeparatorOrientation.HORIZONTAL) {
            graphics2D.draw(new Line2D.Double(insets.left, n3 - 1, n2, n3 - 1));
            graphics2D.draw(new Line2D.Double(insets.left, n3 + 1, n2, n3 + 1));
        } else if (this.orientation == SeparatorOrientation.VERTICAL) {
            graphics2D.draw(new Line2D.Double(n4 - 1, insets.top, n4 - 1, insets.top + n));
            graphics2D.draw(new Line2D.Double(n4 + 1, insets.top, n4 + 1, insets.top + n));
        }
    }

    public static enum SeparatorOrientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum SeparatorType {
        NONE,
        LINE,
        DASHED,
        DOUBLE_DASHED,
        FILLED;

    }
}

