/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuListener;

public class EditableComboBox<T>
extends JComboBox<T> {
    private StringFilterTypeEnum stringFilterType;
    private boolean sortEntries;

    public EditableComboBox(StringFilterTypeEnum stringFilterTypeEnum, boolean bl) {
        this(Collections.emptyList(), stringFilterTypeEnum, bl);
        this.setFont(this.getFont().deriveFont(1));
    }

    public EditableComboBox(List<T> list, StringFilterTypeEnum stringFilterTypeEnum, boolean bl) {
        this.setModel(new FilterableComboBoxModel<T>(list));
        this.setEditor(new MyEditor());
        this.setEditable(true);
        this.stringFilterType = stringFilterTypeEnum;
        this.sortEntries = bl;
    }

    private static class CaseInsensitiveComparator
    implements Comparator<Object> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }

    private static class ContainsFilter
    implements Filter {
        private String prefix;

        public ContainsFilter(String string) {
            this.prefix = string;
        }

        @Override
        public boolean accept(Object object) {
            return object.toString().toLowerCase(Locale.getDefault()).contains(this.prefix.toLowerCase(Locale.getDefault()));
        }
    }

    public static interface Filter {
        public boolean accept(Object var1);
    }

    public class FilterableComboBoxModel<U>
    extends AbstractListModel<U>
    implements MutableComboBoxModel<U> {
        private List<U> items;
        private Filter filter;
        private List<U> filteredItems;
        private Object selectedItem;

        public FilterableComboBoxModel(List<U> list) {
            this.items = new ArrayList<U>(list);
            this.filteredItems = new ArrayList<U>(list.size());
            this.updateFilteredItems();
        }

        @Override
        public void addElement(U u) {
            this.items.add(u);
            this.updateFilteredItems();
        }

        @Override
        public void removeElement(Object object) {
            this.items.remove(object);
            this.updateFilteredItems();
        }

        public void clear() {
            this.items.clear();
            this.updateFilteredItems();
        }

        @Override
        public void removeElementAt(int n) {
            this.items.remove(n);
            this.updateFilteredItems();
        }

        @Override
        public void insertElementAt(Object object, int n) {
            throw new UnsupportedOperationException();
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
            this.updateFilteredItems();
        }

        protected void updateFilteredItems() {
            this.fireIntervalRemoved(this, 0, this.filteredItems.size());
            this.filteredItems.clear();
            if (EditableComboBox.this.sortEntries) {
                Collections.sort(this.items, new CaseInsensitiveComparator());
            }
            if (this.filter == null) {
                this.filteredItems.addAll(this.items);
            } else {
                for (U u : this.items) {
                    if (!this.filter.accept(u)) continue;
                    this.filteredItems.add(u);
                }
            }
            this.fireIntervalAdded(this, 0, this.filteredItems.size());
        }

        @Override
        public int getSize() {
            return this.filteredItems.size();
        }

        @Override
        public U getElementAt(int n) {
            return this.filteredItems.get(n);
        }

        public Object getElementWithName(String string) {
            if (string == null) {
                return null;
            }
            for (U u : this.filteredItems) {
                if (!u.toString().equals(string)) continue;
                return u;
            }
            return null;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedItem == null && object == null) {
                return;
            }
            if (this.selectedItem != null && this.selectedItem.equals(object)) {
                return;
            }
            if (object != null && object.equals(this.selectedItem)) {
                return;
            }
            this.selectedItem = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public class MyEditor
    implements ComboBoxEditor,
    DocumentListener,
    FocusListener {
        public JTextField text = new JTextField(15);
        private volatile boolean filtering = false;
        private volatile boolean setting = false;

        public MyEditor() {
            this.text.getDocument().addDocumentListener(this);
            this.text.addFocusListener(this);
        }

        @Override
        public Component getEditorComponent() {
            return this.text;
        }

        @Override
        public void setItem(Object object) {
            if (this.filtering) {
                return;
            }
            this.setting = true;
            String string = object == null ? "" : object.toString();
            this.text.setText(string);
            this.setting = false;
        }

        @Override
        public Object getItem() {
            return this.text.getText();
        }

        @Override
        public void selectAll() {
            this.text.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.text.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.text.removeActionListener(actionListener);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        protected void handleChange() {
            if (this.setting) {
                return;
            }
            this.filtering = true;
            Filter filter = null;
            if (this.text.getText().length() > 0) {
                switch (EditableComboBox.this.stringFilterType) {
                    case CONTAINS: {
                        filter = new ContainsFilter(this.text.getText());
                        break;
                    }
                    case STARTS_WITH: {
                        filter = new StartsWithFilter(this.text.getText());
                    }
                }
            }
            PopupMenuListener[] popupMenuListenerArray = this.removePopupListeners();
            ((FilterableComboBoxModel)EditableComboBox.this.getModel()).setFilter(filter);
            if (((FilterableComboBoxModel)EditableComboBox.this.getModel()).getSize() > 0) {
                EditableComboBox.this.setPopupVisible(false);
                EditableComboBox.this.setPopupVisible(true);
            } else {
                EditableComboBox.this.setPopupVisible(false);
            }
            this.filtering = false;
            this.addPopupMenuListeners(popupMenuListenerArray);
        }

        private PopupMenuListener[] removePopupListeners() {
            PopupMenuListener[] popupMenuListenerArray;
            PopupMenuListener[] popupMenuListenerArray2 = popupMenuListenerArray = EditableComboBox.this.getPopupMenuListeners();
            int n = popupMenuListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PopupMenuListener popupMenuListener = popupMenuListenerArray2[n2];
                EditableComboBox.this.removePopupMenuListener(popupMenuListener);
                ++n2;
            }
            return popupMenuListenerArray;
        }

        private void addPopupMenuListeners(PopupMenuListener[] popupMenuListenerArray) {
            PopupMenuListener[] popupMenuListenerArray2 = popupMenuListenerArray;
            int n = popupMenuListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PopupMenuListener popupMenuListener = popupMenuListenerArray2[n2];
                EditableComboBox.this.addPopupMenuListener(popupMenuListener);
                ++n2;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.text.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private static class StartsWithFilter
    implements Filter {
        private String prefix;

        public StartsWithFilter(String string) {
            this.prefix = string;
        }

        @Override
        public boolean accept(Object object) {
            return object.toString().toLowerCase(Locale.getDefault()).startsWith(this.prefix.toLowerCase(Locale.getDefault()));
        }
    }

    public static enum StringFilterTypeEnum {
        STARTS_WITH,
        CONTAINS;

    }
}

