/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.ArrowIcon;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.NimbusUtilities;
import com.agfa.pacs.listtext.swingx.util.ScaledIconWrapper;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class DropDownBox
extends JComponent {
    private JPopupMenu popupMenu;
    private AbstractButton itemButton;
    private JButton arrowButton;
    private Orientation orientation;
    private boolean iconScalingEnabled;

    public DropDownBox(String string, Icon icon, JPopupMenu jPopupMenu, Orientation orientation, boolean bl) {
        this.popupMenu = jPopupMenu;
        this.orientation = orientation;
        this.iconScalingEnabled = false;
        this.itemButton = bl ? this.createItemToggleButton() : this.createItemButton();
        this.arrowButton = this.createArrowButton();
        this.arrowButton.addActionListener(new PopupHandler());
        this.itemButton.setText(string);
        this.itemButton.setIcon(icon);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.arrowButton, Orientation.left.equals((Object)orientation) ? "West" : "East");
        this.add((Component)this.itemButton, "Center");
    }

    public DropDownBox(String string, Icon icon) {
        this(string, icon, null, Orientation.bottom, false);
    }

    public DropDownBox() {
        this(null, null, null, Orientation.bottom, false);
    }

    @Override
    public final BorderLayout getLayout() {
        return (BorderLayout)super.getLayout();
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
        if (!(layoutManager instanceof BorderLayout)) {
            throw new UnsupportedOperationException("Setting a custom layout is not supported!");
        }
        super.setLayout(layoutManager);
    }

    public String getText() {
        return this.itemButton.getText();
    }

    @Override
    public String getToolTipText() {
        return this.itemButton.getToolTipText();
    }

    public Icon getIcon() {
        Icon icon = this.itemButton.getIcon();
        if (icon != null && icon instanceof ScaledIconWrapper) {
            icon = ((ScaledIconWrapper)icon).getWrappedIcon();
        }
        return icon;
    }

    public Icon getDisabledIcon() {
        Icon icon = this.itemButton.getDisabledIcon();
        if (icon != null && icon instanceof ScaledIconWrapper) {
            icon = ((ScaledIconWrapper)icon).getWrappedIcon();
        }
        return icon;
    }

    public Icon getRolloverIcon() {
        Icon icon = this.itemButton.getRolloverIcon();
        if (icon != null && icon instanceof ScaledIconWrapper) {
            icon = ((ScaledIconWrapper)icon).getWrappedIcon();
        }
        return icon;
    }

    public Icon getRolloverSelectedIcon() {
        Icon icon = this.itemButton.getRolloverSelectedIcon();
        if (icon != null && icon instanceof ScaledIconWrapper) {
            icon = ((ScaledIconWrapper)icon).getWrappedIcon();
        }
        return icon;
    }

    public boolean isSelected() {
        return this.itemButton.isSelected();
    }

    public void setSelected(boolean bl) {
        if (this.isSelected() != bl) {
            this.itemButton.setSelected(bl);
        }
    }

    public boolean isIconScalingEnabled() {
        return this.iconScalingEnabled;
    }

    public void setIconScalingEnabled(boolean bl) {
        if (this.iconScalingEnabled != bl) {
            this.iconScalingEnabled = bl;
            this.setIcon(this.getIcon());
            this.setDisabledIcon(this.getDisabledIcon());
            this.setRolloverIcon(this.getRolloverIcon());
            this.setRolloverSelectedIcon(this.getRolloverSelectedIcon());
            this.repaint();
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.updateArrowIcons(this.arrowButton);
            this.removeAll();
            this.add((Component)this.arrowButton, Orientation.left.equals((Object)orientation) ? "West" : "East");
            this.add((Component)this.itemButton, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    public void setText(String string) {
        this.itemButton.setText(string);
    }

    @Override
    public void setToolTipText(String string) {
        this.itemButton.setToolTipText(string);
    }

    public void setIcon(Icon icon) {
        if (icon != null && this.iconScalingEnabled && !(icon instanceof ScaledIconWrapper)) {
            this.itemButton.setIcon(new ScaledIconWrapper(icon, this.itemButton));
        } else {
            this.itemButton.setIcon(icon);
        }
    }

    public void setDisabledIcon(Icon icon) {
        if (icon != null && this.iconScalingEnabled && !(icon instanceof ScaledIconWrapper)) {
            this.itemButton.setDisabledIcon(new ScaledIconWrapper(icon, this.itemButton));
        } else {
            this.itemButton.setDisabledIcon(icon);
        }
    }

    public void setRolloverIcon(Icon icon) {
        if (icon != null && this.iconScalingEnabled && !(icon instanceof ScaledIconWrapper)) {
            this.itemButton.setRolloverIcon(new ScaledIconWrapper(icon, this.itemButton));
        } else {
            this.itemButton.setRolloverIcon(icon);
        }
    }

    public void setRolloverSelectedIcon(Icon icon) {
        if (icon != null && this.iconScalingEnabled && !(icon instanceof ScaledIconWrapper)) {
            this.itemButton.setRolloverSelectedIcon(new ScaledIconWrapper(icon, this.itemButton));
        } else {
            this.itemButton.setRolloverSelectedIcon(icon);
        }
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.itemButton.setEnabled(bl);
        this.arrowButton.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setDropDownEnabled() {
        super.setEnabled(true);
        this.arrowButton.setEnabled(true);
    }

    public void addActionListener(ActionListener actionListener) {
        this.itemButton.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.itemButton.removeActionListener(actionListener);
    }

    protected JButton createItemButton() {
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        jButton.setFocusable(false);
        jButton.setRolloverEnabled(true);
        NimbusUtilities.setNimbusProperty(jButton, "nimbusBlueGrey", new Color(0, 0, 0, 0));
        return jButton;
    }

    protected JToggleButton createItemToggleButton() {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setBorderPainted(false);
        jToggleButton.setFocusable(false);
        jToggleButton.setRolloverEnabled(true);
        jToggleButton.setSelected(false);
        NimbusUtilities.setNimbusProperty(jToggleButton, "nimbusBlueGrey", new Color(0, 0, 0, 0));
        return jToggleButton;
    }

    protected JButton createArrowButton() {
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setRolloverEnabled(true);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        this.updateArrowIcons(jButton);
        return jButton;
    }

    private void updateArrowIcons(JButton jButton) {
        Color color = jButton.getBackground();
        boolean bl = ColorUtils.isBright(color);
        Icon icon = this.createArrowIcon(this.orientation, bl ? ColorUtils.darker(color, 0.75f) : ColorUtils.brighter(color, 0.275f));
        Icon icon2 = this.createArrowIcon(this.orientation, bl ? ColorUtils.darker(color, 0.9f) : ColorUtils.brighter(color, 0.5f));
        Icon icon3 = this.createArrowIcon(this.orientation, bl ? ColorUtils.darker(color, 0.9f) : ColorUtils.brighter(color, 0.2f));
        jButton.setIcon(new ScaledIconWrapper(icon, jButton));
        jButton.setDisabledIcon(new ScaledIconWrapper(icon2, jButton));
        jButton.setRolloverIcon(new ScaledIconWrapper(icon3, jButton));
    }

    private Icon createArrowIcon(Orientation orientation, Color color) {
        if (Orientation.left.equals((Object)orientation)) {
            return ArrowIcon.getLeftArrowIcon(color);
        }
        if (Orientation.right.equals((Object)orientation)) {
            return ArrowIcon.getRightArrowIcon(color);
        }
        if (Orientation.top.equals((Object)orientation)) {
            return ArrowIcon.getUpArrowIcon(color);
        }
        return ArrowIcon.getDownArrowIcon(color);
    }

    private void showPopupMenu() {
        this.popupMenu.pack();
        int n = this.getWidth();
        int n2 = this.popupMenu.getPreferredSize().width;
        if (n2 < n) {
            this.popupMenu.setPreferredSize(new Dimension(n, this.popupMenu.getPreferredSize().height));
        }
        Point point = new Point(0, this.getHeight());
        if (Orientation.left.equals((Object)this.orientation)) {
            point.x = 0 - this.popupMenu.getPreferredSize().width;
            point.y = this.getHeight() / 2 - this.popupMenu.getHeight() / 2;
        } else if (Orientation.top.equals((Object)this.orientation)) {
            point.y = 0 - this.popupMenu.getPreferredSize().height;
        } else if (!Orientation.bottom.equals((Object)this.orientation) && Orientation.right.equals((Object)this.orientation)) {
            point.x = this.getWidth();
            point.y = this.getHeight() / 2 - this.popupMenu.getHeight() / 2;
        }
        DropDownBox dropDownBox = this.popupMenu.getInvoker() != null ? this.popupMenu.getInvoker() : this;
        Point point2 = SwingUtilities.convertPoint(this, point, dropDownBox);
        this.popupMenu.show(dropDownBox, point2.x, point2.y);
    }

    public static enum Orientation {
        top,
        left,
        bottom,
        right;

    }

    private class PopupHandler
    implements ActionListener {
        private PopupHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DropDownBox.this.popupMenu != null && DropDownBox.this.arrowButton.isEnabled()) {
                DropDownBox.this.showPopupMenu();
            }
        }
    }
}

