/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.IDateValue;
import com.agfa.pacs.listtext.swingx.controls.MyDateRange;
import java.util.Date;

public class DateValue
implements IDateValue {
    private Date dateValue;
    private int intValue;
    private MyDateRange rangeValue;
    private boolean allowEmptyInput;
    private boolean allowIntInput;
    private boolean allowRangeInput;
    private IDateValue.Types valueType;

    public DateValue(Date date, boolean bl, boolean bl2, boolean bl3) {
        this.dateValue = bl || date != null ? date : new Date();
        this.allowEmptyInput = bl;
        this.allowIntInput = bl2;
        this.allowRangeInput = bl3;
        this.valueType = IDateValue.Types.DATE;
    }

    public DateValue(int n, boolean bl) {
        this(null, bl, true, false);
        this.intValue = n;
        this.valueType = IDateValue.Types.INTEGER;
    }

    public DateValue(Date date, boolean bl) {
        this(date, bl, false, false);
    }

    void setDate(Date date) throws IllegalArgumentException {
        if (!this.allowEmptyInput && date == null) {
            throw new IllegalArgumentException("Setting the current date failed: Date is null!");
        }
        this.dateValue = date;
        this.valueType = IDateValue.Types.DATE;
    }

    void setIntValue(int n) throws UnsupportedOperationException {
        if (!this.allowIntInput) {
            throw new UnsupportedOperationException("Integer input is not allowed! You have to explicitly enable this feature!");
        }
        this.intValue = n;
        this.valueType = IDateValue.Types.INTEGER;
    }

    void setRangeValue(MyDateRange myDateRange) throws UnsupportedOperationException {
        if (!this.allowRangeInput) {
            throw new UnsupportedOperationException("Range input is not allowed! You have to explicitly enable this feature!");
        }
        this.rangeValue = myDateRange;
        this.valueType = IDateValue.Types.RANGE;
    }

    @Override
    public Date getDate() {
        return this.dateValue;
    }

    @Override
    public int getIntValue() {
        return this.intValue;
    }

    @Override
    public MyDateRange getRangeValue() {
        return this.rangeValue;
    }

    public Object getValue() {
        switch (this.valueType) {
            case INTEGER: {
                return this.intValue;
            }
            case RANGE: {
                return this.rangeValue;
            }
        }
        return this.dateValue;
    }

    @Override
    public IDateValue.Types getType() {
        return this.valueType;
    }

    @Override
    public boolean isIntValueAllowed() {
        return this.allowIntInput;
    }

    @Override
    public boolean isRangeValueAllowed() {
        return this.allowRangeInput;
    }

    @Override
    public boolean isEmptyInputAllowed() {
        return this.allowEmptyInput;
    }

    public void setEmptyInputAllowed(boolean bl) {
        this.allowEmptyInput = bl;
    }
}

