/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Pattern;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHelper {
    private static final ALogger logger = ALogger.getLogger(XMLHelper.class);
    private static final java.util.regex.Pattern XPATH_QUERY_PATH_SEPARATOR = Pattern.SLASH;

    public static NodeList selectNodeList(Node node, String string) {
        SimpleNodeList simpleNodeList = new SimpleNodeList();
        if (node == null || string == null) {
            return simpleNodeList;
        }
        String[] stringArray = XPATH_QUERY_PATH_SEPARATOR.split(string);
        simpleNodeList.addNode(node);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            SimpleNodeList simpleNodeList2 = simpleNodeList;
            simpleNodeList = new SimpleNodeList();
            int n3 = 0;
            int n4 = simpleNodeList2.getLength();
            while (n3 < n4) {
                Node node2 = simpleNodeList2.item(n3);
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    if (node3.getNodeType() == 1 && string2.equals(node3.getNodeName())) {
                        simpleNodeList.addNode(node3);
                    }
                    node3 = node3.getNextSibling();
                }
                ++n3;
            }
            ++n2;
        }
        return simpleNodeList;
    }

    public static Node selectSingleNode(Node node, String string) {
        NodeList nodeList = XMLHelper.selectNodeList(node, string);
        if (nodeList.getLength() < 1) {
            return null;
        }
        return nodeList.item(0);
    }

    public static Element createOrReuse(Node node, String string) {
        Element element;
        if (XMLHelper.hasElements(node, string)) {
            element = (Element)XMLHelper.selectNodeList(node, string).item(0);
        } else {
            element = node.getOwnerDocument().createElement(string);
            node.appendChild(element);
        }
        return element;
    }

    public static Element createOrReuse(Node node, String string, String string2, String string3) {
        Element element;
        if (XMLHelper.has(node, string, string2, string3)) {
            element = (Element)XMLHelper.collectPath(node, string, new String[]{string2}, new String[]{string3}).item(0);
        } else {
            element = node.getOwnerDocument().createElement(string);
            node.appendChild(element);
        }
        return element;
    }

    public static NodeList collectPath(Node node, String string, String[] stringArray, String[] stringArray2) {
        NodeList nodeList = XMLHelper.selectNodeList(node, string);
        SimpleNodeList simpleNodeList = new SimpleNodeList();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            boolean bl = true;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = element.getAttribute(stringArray[n2]);
                if (!string2.equals(stringArray2[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                simpleNodeList.addNode(element);
            }
            ++n;
        }
        return simpleNodeList;
    }

    public static boolean has(Node node, String string, String string2, String string3) {
        NodeList nodeList = XMLHelper.selectNodeList(node, string);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element;
            String string4;
            Node node2 = nodeList.item(n2);
            if (node2 instanceof Element && (string4 = (element = (Element)node2).getAttribute(string2)).equals(string3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean has(Node node, String string, String[] stringArray, String[] stringArray2) {
        NodeList nodeList = XMLHelper.selectNodeList(node, string);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2 instanceof Element) {
                Element element = (Element)node2;
                int n3 = 0;
                int n4 = 0;
                while (n4 < stringArray.length) {
                    String string2 = element.getAttribute(stringArray[n4]);
                    if (string2.equals(stringArray2[n4])) {
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 == stringArray.length) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasElements(Node node, String string) {
        NodeList nodeList = XMLHelper.selectNodeList(node, string);
        return nodeList.getLength() > 0;
    }

    public static void dumpNode(Node node, OutputStream outputStream) {
        try {
            OutputFormat outputFormat = new OutputFormat("XML", "ISO-8859-1", true);
            outputFormat.setIndent(1);
            outputFormat.setIndenting(true);
            XMLSerializer xMLSerializer = new XMLSerializer(outputStream, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(node);
        }
        catch (Exception exception) {
            logger.warn("Could not dump node to " + outputStream);
        }
    }

    public static class SimpleNodeList
    implements NodeList {
        List<Node> nodes = new ArrayList<Node>();

        @Override
        public Node item(int n) {
            return this.nodes.get(n);
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }

        public void addNode(Node node) {
            this.nodes.add(node);
        }
    }
}

