/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Pattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;

public class StringTools {
    private static final ALogger logger = ALogger.getLogger(StringTools.class);
    private static final java.util.regex.Pattern nonWhiteSpaceCharacter = java.util.regex.Pattern.compile("\\S+");

    public static long parseMemoryAmount(String string) {
        try {
            String string2 = string.trim().toUpperCase();
            if (string2.indexOf("GB") >= 0) {
                return Long.parseLong(string2.substring(0, string2.length() - 2).trim()) * 1024L * 1024L * 1024L;
            }
            if (string2.indexOf("MB") >= 0) {
                return Long.parseLong(string2.substring(0, string2.length() - 2).trim()) * 1024L * 1024L;
            }
            if (string2.indexOf("KB") >= 0) {
                return Long.parseLong(string2.substring(0, string2.length() - 2).trim()) * 1024L;
            }
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            throw new NumberFormatException("error while parsing " + string);
        }
    }

    public static Map<String, String> parseParameterMap(String string) {
        return StringTools.parseParameterMap(string, " ");
    }

    public static Map<String, String> parseParameterMap(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null || string2 == null) {
            return hashMap;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        int n = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5 = stringTokenizer.nextToken();
            n = string5.indexOf("=");
            if (n == -1) {
                string4 = string5;
                string3 = null;
            } else {
                string4 = string5.substring(0, n).trim();
                string3 = string5.substring(n + 1).trim();
            }
            if (string4.length() <= 0) continue;
            hashMap.put(string4, string3);
        }
        return hashMap;
    }

    public static String composeParameterString(Map<String, String> map, String string) {
        StringBuilder stringBuilder = new StringBuilder(300);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (!string3.contains(string)) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
                stringBuilder.append("=");
                stringBuilder.append(string3);
                continue;
            }
            logger.error("Illegal parameter value in '" + map + "' (" + string3 + ")");
        }
        return stringBuilder.toString();
    }

    public static String composeParameterString(Map<String, String> map) {
        return StringTools.composeParameterString(map, " ");
    }

    public static String[] appendStringValue(String[] stringArray, String string) {
        if (stringArray == null) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public static boolean containsStringValue(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String deleteChars(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringBuffer stringBuffer = new StringBuffer(100);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public static String cleanCRLF(String string) {
        String[] stringArray = Pattern.CR_LF.split(string, -1);
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].replace("\r", "\r\n");
            ++n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        int n2 = 1;
        while (n2 < stringArray.length) {
            stringBuilder.append("\r\n");
            stringBuilder.append(stringArray[n2]);
            ++n2;
        }
        stringArray = Pattern.CR_LF.split(stringBuilder.toString(), -1);
        n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = stringArray[n2].replace("\n", "\r\n");
            ++n2;
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        n2 = 1;
        while (n2 < stringArray.length) {
            stringBuilder.append("\r\n");
            stringBuilder.append(stringArray[n2]);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String incrementString(String string, Set<String> set) {
        if (string == null || set == null || set.size() == 0) {
            return string;
        }
        String string2 = string;
        if (string2.endsWith(")") && set.contains(string2)) {
            string2 = String.valueOf(string2) + " (2)";
        }
        while (set.contains(string2)) {
            if (string2.endsWith(")")) {
                int n = string2.lastIndexOf(40);
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string2.substring(n + 1, string2.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {}
                if (n2 != -1) {
                    string2 = String.valueOf(string2.substring(0, n + 1)) + (n2 + 1) + ")";
                    continue;
                }
                string2 = String.valueOf(string2) + " (2)";
                continue;
            }
            string2 = String.valueOf(string2) + " (2)";
        }
        return string2;
    }

    public static List<String> split(String string, String string2) {
        return StringTools.split(string, string2, false);
    }

    public static List<String> split(String string, String string2, boolean bl) {
        if (string2 == null) {
            throw new IllegalArgumentException("separator cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        int n = 0;
        int n2 = 0;
        String string3 = null;
        while (-1 != (n2 = string.indexOf(string2, n2))) {
            string3 = string.substring(n, n2);
            if (string3.length() > 0 || bl) {
                arrayList.add(string3);
            }
            n = n2 += string2.length();
        }
        if (n != string.length()) {
            string3 = string.substring(n, string.length());
            if (string3.length() > 0 || bl) {
                arrayList.add(string3);
            }
        } else if (bl) {
            arrayList.add("");
        }
        return arrayList;
    }

    public static boolean containsNoneWhiteSpaceCharacter(String string) {
        Matcher matcher = nonWhiteSpaceCharacter.matcher(string);
        return matcher.find();
    }

    public static boolean containsNoneWhiteSpaceCharacter(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (StringTools.containsNoneWhiteSpaceCharacter(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] splitToLines(String string) {
        return Pattern.NEWLINE.split(string);
    }

    public static int getWhiteSpaceSequenceStartPosition(String string, int n) {
        int n2 = n - 1;
        if (string != null) {
            while (n2 >= 0 && Character.isWhitespace(string.charAt(n2))) {
                --n2;
            }
        } else {
            logger.warn("String which is analyzed for whitespace sequence is null");
            return -1;
        }
        return n2 + 1;
    }

    public static String composeList(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = 0;
        while (n < list.size()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(list.get(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static List<String> parseList(String string, String string2) {
        return Arrays.asList(string.split(string2));
    }
}

