/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class StreamUtil {
    private static final boolean CLOSE_STREAMS_AUTOMATICALLY = true;
    public static final int DUMPSIZE = 4096;
    private static final byte[] DUMP = new byte[4096];

    public static byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtil.copyStream(inputStream, byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readStreamSimple(InputStream inputStream) throws IOException {
        return StreamUtil.readStreamSimple(inputStream, true);
    }

    static byte[] readStreamSimple(InputStream inputStream, boolean bl) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        if (bl) {
            inputStream.close();
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readStream(InputStream inputStream, int n) throws IOException {
        byte[] byArray = DataCacheProviderFactory.getCache().allocBytes(n);
        StreamUtil.readStream(inputStream, byArray);
        return byArray;
    }

    public static int readStream(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = 0x100000;
        int n3 = 0;
        while ((n = inputStream.read(byArray, n3, Math.min(n2, byArray.length - n3))) > 0) {
            n3 += n;
        }
        return n3;
    }

    public static int readStreamSmall(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = 65536;
        int n3 = 0;
        while ((n = inputStream.read(byArray, n3, Math.min(n2, byArray.length - n3))) > 0) {
            n3 += n;
        }
        return n3;
    }

    public static String readStream(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(65536);
        int n = 65536;
        char[] cArray = new char[n];
        int n2 = 0;
        while ((n2 = reader.read(cArray)) >= 0) {
            stringBuilder.append(cArray, 0, n2);
        }
        reader.close();
        return stringBuilder.toString();
    }

    public static String readLongStream(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(0x100000);
        int n = 0x100000;
        char[] cArray = new char[n];
        int n2 = 0;
        while ((n2 = reader.read(cArray)) >= 0) {
            stringBuilder.append(cArray, 0, n2);
        }
        reader.close();
        return stringBuilder.toString();
    }

    public static void writeStream(String string, Writer writer) throws IOException {
        int n = 0;
        int n2 = 65536;
        char[] cArray = string.toCharArray();
        while (n + n2 < cArray.length) {
            writer.write(cArray, n, n2);
            n += n2;
        }
        writer.write(cArray, n, cArray.length - n);
    }

    public static void writeStream(byte[] byArray, OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 65536;
        while (n + n2 < byArray.length) {
            outputStream.write(byArray, n, n2);
            n += n2;
        }
        outputStream.write(byArray, n, byArray.length - n);
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 524288;
        byte[] byArray = DataCacheProviderFactory.getCache().allocBytes(n3);
        while ((n = inputStream.read(byArray, 0, n3)) >= 0) {
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        inputStream.close();
        DataCacheProviderFactory.getCache().free(byArray);
        return n2;
    }

    public static long copyStreamSimple(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 65536;
        byte[] byArray = new byte[n3];
        while ((n = inputStream.read(byArray, 0, n3)) >= 0) {
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        inputStream.close();
        return n2;
    }

    public static void copyFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamUtil.copyStream(inputStream, fileOutputStream);
        fileOutputStream.close();
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        StreamUtil.copyStream(fileInputStream, fileOutputStream);
        fileOutputStream.close();
        fileInputStream.close();
    }

    public static void deleteRecursive(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                StreamUtil.deleteRecursive(file2);
                ++n2;
            }
        }
        file.delete();
    }

    public static InputStream getInputStream(HttpURLConnection httpURLConnection) throws IOException {
        try {
            return httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            StreamUtil.cleanupFailedHttpURLConnection(httpURLConnection);
            throw iOException;
        }
    }

    public static InputStream getInputStream(URLConnection uRLConnection) throws IOException {
        return uRLConnection.getInputStream();
    }

    public static OutputStream getOutputStream(HttpURLConnection httpURLConnection) throws IOException {
        try {
            return httpURLConnection.getOutputStream();
        }
        catch (IOException iOException) {
            StreamUtil.cleanupFailedHttpURLConnection(httpURLConnection);
            throw iOException;
        }
    }

    public static void cleanupConnection(HttpURLConnection httpURLConnection) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                StreamUtil.flushRead(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            StreamUtil.cleanupFailedHttpURLConnection(httpURLConnection);
        }
    }

    public static void cleanupFailedHttpURLConnection(HttpURLConnection httpURLConnection) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream inputStream = httpURLConnection.getErrorStream();){
                if (inputStream != null) {
                    StreamUtil.flushRead(inputStream);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    public static void flushRead(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3 = 1;
        while ((n2 = inputStream.read(DUMP)) != -1) {
            if (n > 0 && (n3 += n2) > n) break;
        }
    }

    public static void flushRead(InputStream inputStream) throws IOException {
        StreamUtil.flushRead(inputStream, -1);
    }
}

