/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import java.math.BigInteger;

public class PermutationGenerator {
    private int[] a;
    private BigInteger numLeft;
    private BigInteger total;

    public PermutationGenerator(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of elements must be at least one");
        }
        this.a = new int[n];
        this.total = PermutationGenerator.getFactorial(n);
        this.reset();
    }

    public void reset() {
        int n = 0;
        while (n < this.a.length) {
            this.a[n] = n;
            ++n;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int n = this.a.length - 2;
        while (this.a[n] > this.a[n + 1]) {
            --n;
        }
        int n2 = this.a.length - 1;
        while (this.a[n] > this.a[n2]) {
            --n2;
        }
        int n3 = this.a[n2];
        this.a[n2] = this.a[n];
        this.a[n] = n3;
        int n4 = this.a.length - 1;
        int n5 = n + 1;
        while (n4 > n5) {
            n3 = this.a[n5];
            this.a[n5] = this.a[n4];
            this.a[n4] = n3;
            --n4;
            ++n5;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger bigInteger = BigInteger.ONE;
        int n2 = n;
        while (n2 > 1) {
            bigInteger = bigInteger.multiply(new BigInteger(Integer.toString(n2)));
            --n2;
        }
        return bigInteger;
    }
}

