/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MemoryDumpTools {
    private static final ALogger logger = ALogger.getLogger(MemoryDumpTools.class);

    public static String getProcessId() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        return string.substring(0, string.indexOf(64));
    }

    public static boolean dumpMemory(String string, String string2) {
        try {
            File file = new File(string2);
            file.getParentFile().mkdirs();
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            String string3 = String.valueOf(string2) + "_" + string + ".hprof";
            Object[] objectArray = new Object[]{string3, true};
            String[] stringArray = new String[]{"java.lang.String", "boolean"};
            mBeanServer.invoke(objectName, "dumpHeap", objectArray, stringArray);
            logger.info("Memory dump created. [{}] ", (Object)string3);
            return true;
        }
        catch (Exception exception) {
            logger.error("Memory Dump could not be created.", (Throwable)exception);
            return false;
        }
    }

    public static void dumpMemory(String string) {
        try {
            logger.debug("[24h] trying to lookup process id");
            String string2 = MemoryDumpTools.getProcessId();
            if (string2 == null) {
                logger.error("[24h] process id lookup failed");
            } else {
                logger.debug("[24h] looked up process id: " + string2);
                MemoryDumpTools.dumpMemory(string2, String.valueOf(string) + File.separator + System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            logger.error("[24h] Failed dumping memory!", (Throwable)exception);
        }
    }
}

