/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;

public class LightSemaphore {
    private static ALogger logger = ALogger.getLogger(LightSemaphore.class);
    private int maxCount;
    private int curCount;
    volatile int waitingThreads = 0;

    public LightSemaphore() {
        this.maxCount = 1;
        this.curCount = 1;
    }

    public LightSemaphore(int n) {
        this.maxCount = n;
        this.curCount = n;
    }

    public LightSemaphore(int n, int n2) {
        this.maxCount = n;
        this.curCount = n2;
    }

    public synchronized void P() {
        ++this.waitingThreads;
        while (this.curCount <= 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                logger.error("Exception in Semaphore: " + exception);
            }
        }
        --this.waitingThreads;
        --this.curCount;
    }

    public synchronized void P_uninterruptly() {
        ++this.waitingThreads;
        boolean bl = false;
        while (this.curCount <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        --this.waitingThreads;
        --this.curCount;
    }

    public synchronized boolean P_nonBlocking() {
        if (this.curCount <= 0) {
            return false;
        }
        --this.curCount;
        return true;
    }

    public synchronized void addP_nonBlocking(int n) {
        this.curCount -= n;
    }

    public synchronized void V() {
        ++this.curCount;
        if (this.waitingThreads > 0) {
            this.notify();
        }
    }

    public synchronized void V(int n) {
        this.curCount += n;
        if (this.waitingThreads > 0) {
            if (n > 1) {
                this.notifyAll();
            } else {
                this.notify();
            }
        }
    }

    public int getCurrCount() {
        return this.curCount;
    }

    public boolean isBlocking() {
        return this.curCount <= 0;
    }

    public void setSem(int n) {
        this.curCount = n;
    }
}

