/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.tools.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileSystemView;

public class FileUtil {
    public static void remove(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (fileArray != null && n < fileArray.length) {
                FileUtil.remove(fileArray[n]);
                ++n;
            }
        }
        file.delete();
    }

    public static String getDriveName(File file) {
        String string = FileSystemView.getFileSystemView().getSystemDisplayName(file);
        if (string.length() > 30) {
            string = String.valueOf(string.substring(0, 28)) + "...";
        }
        return string;
    }

    public static String getUserDesktop() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append("Desktop");
            return stringBuffer.toString();
        }
        return string;
    }

    public static byte[] zip(Map<ZipEntry, byte[]> map) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        zipOutputStream.setMethod(8);
        for (Map.Entry<ZipEntry, byte[]> entry : map.entrySet()) {
            zipOutputStream.putNextEntry(entry.getKey());
            zipOutputStream.write(entry.getValue());
        }
        zipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Map<ZipEntry, byte[]> unzip(byte[] byArray) throws Exception {
        HashMap<ZipEntry, byte[]> hashMap = new HashMap<ZipEntry, byte[]>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            hashMap.put(zipEntry, StreamUtil.readStreamSimple(zipInputStream, false));
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
        return hashMap;
    }
}

