/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.services;

import com.agfa.pacs.core.FactorySelector;

public abstract class BackgroundServiceFactory {
    public static final String BACKGROUND_SERVICE_EXT_PT = "com.agfa.pacs.core.shared.BackgroundService";
    private static BackgroundServiceFactory implementation;
    private static boolean isStarted;

    static {
        isStarted = false;
    }

    public static synchronized int startupAllServices() {
        if (implementation == null) {
            BackgroundServiceFactory.initialize();
        }
        if (isStarted) {
            return 0;
        }
        isStarted = true;
        return implementation.startupAll();
    }

    public static synchronized boolean startupService(String string) {
        if (implementation == null) {
            BackgroundServiceFactory.initialize();
        }
        return implementation.startup(string);
    }

    protected abstract int startupAll();

    protected abstract boolean startup(String var1);

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory(BackgroundServiceFactory.class.getName()));
            implementation = (BackgroundServiceFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + BackgroundServiceFactory.class.getName(), reflectiveOperationException);
        }
    }
}

