/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.messages;

import com.agfa.pacs.tools.UnicodeReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnicodeResourceClassLoader
extends ClassLoader {
    private final ClassLoader delegate;

    public UnicodeResourceClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.delegate = classLoader;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = this.delegate.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        UnicodeReader unicodeReader = new UnicodeReader(inputStream, null);
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(16384);
            char[] cArray = new char[1024];
            try {
                int n;
                while ((n = unicodeReader.read(cArray)) > 0) {
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if ((c & 0xFFFF) < 256) {
                            byteArrayOutputStream.write(c & 0xFF);
                        } else {
                            byteArrayOutputStream.write(this.getUtf8Encoding(c).getBytes());
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            try {
                unicodeReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private String getUtf8Encoding(char c) {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append("\\u");
        String string = Integer.toString(c, 16);
        int n = string.length();
        while (n < 4) {
            stringBuilder.append('0');
            ++n;
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

