/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.logging.ALogger;

public class WaitForEventListener
implements IEventListener {
    private static final ALogger LOGGER = ALogger.getLogger(WaitForEventListener.class);
    protected IEventListenerProvider<IEventListener> prov;
    protected final int eventID;
    protected final String eventName;
    private IListenerSynchronization sync = ListenerSynchronizationFactory.getInstance();
    protected boolean eventReceived;
    protected Object payload;
    protected EventPayloadChecker payloadChecker;

    public WaitForEventListener(String string, int n) {
        this(string, n, null);
    }

    public WaitForEventListener(String string, int n, EventPayloadChecker eventPayloadChecker) {
        this.eventID = n;
        this.eventReceived = false;
        if (string != null) {
            this.prov = EventEngineFactory.getInstance().createListenerProvider(this);
            EventEngineFactory.getInstance().register(this.prov, string);
        }
        this.eventName = EventEngineFactory.getInstance().getEventName(n);
        this.payloadChecker = eventPayloadChecker;
        LOGGER.info("Register waiter for event '" + this.eventName + "' at '" + string + "'");
    }

    @Override
    public IListenerSynchronization getSync() {
        return this.sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        if (iEvent.getEventID() == this.eventID) {
            WaitForEventListener waitForEventListener = this;
            synchronized (waitForEventListener) {
                block5: {
                    this.payload = iEvent.getPayload();
                    if (this.payloadChecker == null || this.payloadChecker.evaluate(this.payload)) break block5;
                    return false;
                }
                this.eventReceived = true;
                this.notify();
            }
            EventEngineFactory.getInstance().unregister(this.prov);
        }
        return false;
    }

    @Override
    public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        return false;
    }

    public synchronized Object waitForEvent() {
        return this.waitForEvent(0L);
    }

    public synchronized Object waitForEvent(long l) {
        LOGGER.info("Wait for event '" + this.eventName + "' ...");
        while (!this.eventReceived) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException("Interrupt happened during wait for event " + this.eventName, interruptedException);
            }
            if (l > 0L) break;
        }
        LOGGER.info("'" + this.eventName + "' event received" + (l == 0L ? "" : " or wait timed out after " + l + " ms"));
        return this.payload;
    }

    public boolean getEventReceived() {
        return this.eventReceived;
    }

    public static abstract class EventPayloadChecker {
        public abstract boolean evaluate(Object var1);
    }
}

