/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventEngineFactory;

public abstract class EventEngineFactory
implements IEventEngineFactory {
    private static final EventEngineFactory implementation = EventEngineFactory.initialize();

    public static synchronized IEventEngine getInstance() {
        return implementation.getEngineInt();
    }

    @Override
    public abstract IEventEngine getEngineInt();

    private static EventEngineFactory initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory(EventEngineFactory.class.getName()));
            return (EventEngineFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + EventEngineFactory.class.getName(), reflectiveOperationException);
        }
        return null;
    }
}

