/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.core;

import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import java.util.Vector;

public class PrepareForStateChangeSynchronizer {
    private boolean isDone = false;
    private boolean continueAdviced = true;
    public static final String LISTENER_GROUP = "application.management";

    public synchronized void setDone(boolean bl) {
        this.isDone = true;
        this.continueAdviced = bl;
        this.notifyAll();
    }

    public synchronized boolean waitForStateChangePossible() {
        while (!this.isDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.continueAdviced;
    }

    public static void waitForStateChange(int n, Object object) {
        IEvent iEvent = EventEngineFactory.getInstance().createInternalEvent(n);
        iEvent.setActionInfo(ActionInfo.SINGLE);
        PrepareForStateChangeSynchronizationContext prepareForStateChangeSynchronizationContext = new PrepareForStateChangeSynchronizationContext(object);
        iEvent.setPayload(prepareForStateChangeSynchronizationContext);
        iEvent.setDestination(null, LISTENER_GROUP);
        EventEngineFactory.getInstance().sendExclusiveEvent(iEvent);
        for (PrepareForStateChangeSynchronizer prepareForStateChangeSynchronizer : prepareForStateChangeSynchronizationContext.getSynchronizationLocks()) {
            prepareForStateChangeSynchronizer.waitForStateChangePossible();
        }
    }

    public static class PrepareForStateChangeSynchronizationContext {
        private final Object context;
        private final Vector<PrepareForStateChangeSynchronizer> synchronizationLocks = new Vector();

        public PrepareForStateChangeSynchronizationContext(Object object) {
            this.context = object;
        }

        public Object getContext() {
            return this.context;
        }

        public Vector<PrepareForStateChangeSynchronizer> getSynchronizationLocks() {
            return this.synchronizationLocks;
        }
    }
}

