/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config;

import com.agfa.pacs.config.IConfigurationAdministrationFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.config.IConfigurationProviderFactory;
import com.agfa.pacs.core.FactorySelector;

public abstract class ConfigurationProviderFactory
implements IConfigurationAdministrationFactory,
IConfigurationProviderFactory {
    private static ConfigurationProviderFactory implementation = ConfigurationProviderFactory.initialize();
    protected IConfigurationProvider configuration;
    private String secondaryRole = null;
    private IConfigurationProvider secondaryRoleConfiguration = null;

    public static IConfigurationProvider getConfig() {
        return implementation.getConfigInt();
    }

    public static IConfigurationProvider getBaseConfig() {
        return implementation.getConfigInt();
    }

    public static IConfigurationAdministrationFactory getAdministrationFactory() {
        return implementation;
    }

    @Override
    public IConfigurationProvider getConfigForRole(String string) {
        if (string == null) {
            return this.configuration;
        }
        if (string.equals("LOCAL") || string.equals("WORKSTATION")) {
            return this.configuration.clone(string);
        }
        if (this.secondaryRole == null || !this.secondaryRole.equals(string)) {
            this.secondaryRoleConfiguration = this.createConfiguration();
            this.secondaryRoleConfiguration.setRole(string);
            this.secondaryRole = string;
        }
        return this.secondaryRoleConfiguration;
    }

    @Override
    public void flushRoleConfiguration() {
        if (this.secondaryRole != null) {
            this.configuration.storeConfigurationForRole(this.secondaryRole);
        }
        this.secondaryRole = null;
        this.secondaryRoleConfiguration = null;
    }

    @Override
    public void updateSubtree(String string) {
        this.configuration.storeAllConfiguration();
        this.configuration.updateCache(string);
    }

    @Override
    public abstract IConfigurationProvider createConfiguration();

    protected IConfigurationProvider getConfigInt() {
        return this.configuration;
    }

    private static synchronized ConfigurationProviderFactory initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory(ConfigurationProviderFactory.class.getName()));
            return (ConfigurationProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + ConfigurationProviderFactory.class.getName(), reflectiveOperationException);
        }
        return null;
    }
}

