/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.cache;

import com.agfa.pacs.cache.DataGroup;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.IDisposable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class DataGroupRegistry {
    private static final ALogger LOGGER = ALogger.getLogger(DataGroupRegistry.class);
    private static Map<String, DataGroup> owners = new HashMap<String, DataGroup>();
    private static Queue<DataGroup> pendingDisposalQueue = new LinkedList<DataGroup>();
    private static DataGroup dummyGroup = new DataGroup(true);

    static {
        DataGroupDisposer dataGroupDisposer = new DataGroupDisposer();
        dataGroupDisposer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DataGroup registerDataOwner(String string, IDisposable iDisposable) {
        DataGroup dataGroup;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("+++ Registering data owner for " + string);
        }
        if ((dataGroup = owners.get(string)) == null) {
            Queue<DataGroup> queue = pendingDisposalQueue;
            synchronized (queue) {
                boolean bl = true;
                Iterator iterator = pendingDisposalQueue.iterator();
                while (iterator.hasNext()) {
                    DataGroup dataGroup2 = (DataGroup)iterator.next();
                    if (dataGroup2.getId().equals(string)) {
                        if (bl) {
                            while (!pendingDisposalQueue.isEmpty() && pendingDisposalQueue.peek().getId().equals(string)) {
                                try {
                                    pendingDisposalQueue.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            break;
                        }
                        dataGroup = dataGroup2;
                        iterator.remove();
                        owners.put(string, dataGroup);
                        break;
                    }
                    bl = false;
                }
            }
            if (dataGroup == null) {
                dataGroup = new DataGroup(string);
                owners.put(string, dataGroup);
            }
        }
        dataGroup.register(iDisposable);
        return dataGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterDataOwner(String string, IDisposable iDisposable) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("+++ Deregistering data owner for " + string);
        }
        DataGroup dataGroup = null;
        boolean bl = false;
        Object object = DataGroupRegistry.class;
        synchronized (DataGroupRegistry.class) {
            dataGroup = owners.get(string);
            if (dataGroup != null) {
                DataGroup.DeregisterResult deregisterResult = dataGroup.deregister(iDisposable);
                switch (deregisterResult) {
                    case EMPTY: {
                        owners.remove(string);
                        break;
                    }
                    case REMOVED: 
                    case NOT_REGISTERED: {
                        dataGroup = null;
                        break;
                    }
                    case UNKNOWN: {
                        dataGroup = null;
                        bl = true;
                    }
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (bl) {
                iDisposable.dispose();
            }
            if (dataGroup != null) {
                object = pendingDisposalQueue;
                synchronized (object) {
                    pendingDisposalQueue.add(dataGroup);
                    pendingDisposalQueue.notifyAll();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerItem(String string, IDisposable iDisposable) {
        DataGroup dataGroup = null;
        Class<DataGroupRegistry> clazz = DataGroupRegistry.class;
        synchronized (DataGroupRegistry.class) {
            dataGroup = owners.get(string);
            if (dataGroup != null) {
                dataGroup.registerItem(iDisposable);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (dataGroup == null) {
                iDisposable.dispose();
            }
            return;
        }
    }

    public static synchronized IDataCacheProvider getCacheView(String string) {
        IDataCacheProvider iDataCacheProvider = owners.get(string);
        if (iDataCacheProvider == null) {
            return dummyGroup;
        }
        return iDataCacheProvider;
    }

    public static synchronized boolean exists(String string) {
        return owners.containsKey(string);
    }

    private static class DataGroupDisposer
    extends Thread {
        private DataGroupDisposer() {
            super("DataGroupDisposer");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                DataGroup dataGroup;
                Queue queue = pendingDisposalQueue;
                synchronized (queue) {
                    dataGroup = (DataGroup)pendingDisposalQueue.peek();
                    if (dataGroup == null) {
                        try {
                            pendingDisposalQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (dataGroup == null) continue;
                try {
                    long l = System.currentTimeMillis();
                    dataGroup.dispose();
                    LOGGER.info(">>>> time to dispose async:" + (System.currentTimeMillis() - l));
                }
                catch (Exception exception) {
                    LOGGER.error("error while disposing data", (Throwable)exception);
                }
                queue = pendingDisposalQueue;
                synchronized (queue) {
                    pendingDisposalQueue.remove();
                    pendingDisposalQueue.notifyAll();
                }
            }
        }
    }
}

