/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.cache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.ICacheItemGroup;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.IDisposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataGroup
implements IDataCacheProvider {
    private static final ALogger LOGGER = ALogger.getLogger(DataGroup.class);
    private final List<IDisposable> active = new ArrayList<IDisposable>();
    private final List<IDisposable> toClean = new LinkedList<IDisposable>();
    private boolean disposed;
    private final IDataCacheProvider delegate;
    private final String cacheId;

    public DataGroup(String string) {
        this.cacheId = string;
        this.delegate = DataCacheProviderFactory.getCache();
    }

    public DataGroup(boolean bl) {
        this("Not.A.U1D.At.All");
        this.disposed = bl;
    }

    public String getId() {
        return this.cacheId;
    }

    public void register(IDisposable iDisposable) {
        this.active.add(iDisposable);
    }

    public DeregisterResult deregister(IDisposable iDisposable) {
        boolean bl = false;
        int n = 0;
        while (n < this.active.size()) {
            if (this.active.get(n) == iDisposable) {
                this.active.remove(n);
                this.toClean.add(iDisposable);
                bl = true;
                break;
            }
            ++n;
        }
        if (this.active.size() == 0) {
            return DeregisterResult.EMPTY;
        }
        if (bl) {
            return DeregisterResult.REMOVED;
        }
        if (this.active.size() > 0) {
            return DeregisterResult.NOT_REGISTERED;
        }
        return DeregisterResult.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DataGroup object2 = this;
        synchronized (object2) {
            this.disposed = true;
        }
        for (IDisposable iDisposable : this.toClean) {
            iDisposable.dispose();
        }
        this.toClean.clear();
    }

    @Override
    public ICacheItemGroup getItemGroup(String string) {
        return this.delegate.getItemGroup(string);
    }

    public void registerItem(IDisposable iDisposable) {
        this.toClean.add(iDisposable);
    }

    private synchronized boolean checkDisposed(CacheID cacheID) {
        if (this.disposed) {
            this.delegate.remove(cacheID);
        }
        return this.disposed;
    }

    @Override
    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        if (!this.disposed) {
            this.delegate.addPersistentBytes(byArray, cacheID);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentBytes(byte[] byArray, CacheID cacheID, int n) {
        if (!this.disposed) {
            this.delegate.addPersistentBytes(byArray, cacheID, n);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentDoubles(double[] dArray, CacheID cacheID) {
        if (!this.disposed) {
            this.delegate.addPersistentDoubles(dArray, cacheID);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentFloats(float[] fArray, CacheID cacheID) {
        if (!this.disposed) {
            this.delegate.addPersistentFloats(fArray, cacheID);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        if (!this.disposed) {
            this.delegate.addPersistentInts(nArray, cacheID);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentInts(int[] nArray, CacheID cacheID, int n) {
        if (!this.disposed) {
            this.delegate.addPersistentInts(nArray, cacheID, n);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentObject(Object object, CacheID cacheID) {
        if (!this.disposed) {
            this.delegate.addPersistentObject(object, cacheID);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentObject(Object object, CacheID cacheID, int n) {
        if (!this.disposed) {
            this.delegate.addPersistentObject(object, cacheID, n);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        if (!this.disposed) {
            this.delegate.addPersistentObject(object, clazz, cacheID);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        if (!this.disposed) {
            this.delegate.addPersistentShorts(sArray, cacheID);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void addPersistentShorts(short[] sArray, CacheID cacheID, int n) {
        if (!this.disposed) {
            this.delegate.addPersistentShorts(sArray, cacheID, n);
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public byte[] allocAndClearBytes(long l) {
        return this.delegate.allocAndClearBytes(l);
    }

    @Override
    public double[] allocAndClearDoubles(long l) {
        return this.delegate.allocAndClearDoubles(l);
    }

    @Override
    public float[] allocAndClearFloats(long l) {
        return this.delegate.allocAndClearFloats(l);
    }

    @Override
    public int[] allocAndClearInts(long l) {
        return this.delegate.allocAndClearInts(l);
    }

    @Override
    public short[] allocAndClearShorts(long l) {
        return this.delegate.allocAndClearShorts(l);
    }

    @Override
    public byte[] allocBytes(long l) {
        return this.delegate.allocBytes(l);
    }

    @Override
    public byte[] allocBytes(long l, int n) {
        return this.delegate.allocBytes(l, n);
    }

    @Override
    public double[] allocDoubles(long l) {
        return this.delegate.allocDoubles(l);
    }

    @Override
    public float[] allocFloats(long l) {
        return this.delegate.allocFloats(l);
    }

    @Override
    public int[] allocInts(long l) {
        return this.delegate.allocInts(l);
    }

    @Override
    public int[] allocInts(long l, int n) {
        return this.delegate.allocInts(l, n);
    }

    @Override
    public Object allocObject(Class<?> clazz, Object[] objectArray) {
        return this.delegate.allocObject(clazz, objectArray);
    }

    @Override
    public short[] allocShorts(long l) {
        return this.delegate.allocShorts(l);
    }

    @Override
    public short[] allocShorts(long l, int n) {
        return this.delegate.allocShorts(l, n);
    }

    @Override
    public long availableMemory(int n) {
        return this.delegate.availableMemory(n);
    }

    @Override
    public long getFreeMemory() {
        return this.delegate.getFreeMemory();
    }

    @Override
    public CacheID createID() {
        return this.delegate.createID();
    }

    @Override
    public CacheID createID(String string, String string2, int n) {
        return this.delegate.createID(string, string2, n);
    }

    @Override
    public void ensureFreeMemory(long l) {
        this.delegate.ensureFreeMemory(l);
    }

    @Override
    public boolean exists(Class<?> clazz, CacheID cacheID) {
        return this.delegate.exists(clazz, cacheID) && !this.checkDisposed(cacheID);
    }

    @Override
    public void flush(CacheID cacheID) {
        this.delegate.flush(cacheID);
    }

    @Override
    public void flushGroup(Class<?> clazz, CacheID cacheID) {
        this.delegate.flushGroup(clazz, cacheID);
    }

    @Override
    public void flushAll() {
        this.delegate.flushAll();
    }

    @Override
    public void free(byte[] byArray) {
        this.delegate.free(byArray);
    }

    @Override
    public void free(short[] sArray) {
        this.delegate.free(sArray);
    }

    @Override
    public void free(int[] nArray) {
        this.delegate.free(nArray);
    }

    @Override
    public void free(float[] fArray) {
        this.delegate.free(fArray);
    }

    @Override
    public void free(double[] dArray) {
        this.delegate.free(dArray);
    }

    @Override
    public void free(Object object) {
        this.delegate.free(object);
    }

    @Override
    public byte[] getContentBytes(CacheID cacheID) {
        return this.delegate.getContentBytes(cacheID);
    }

    @Override
    public double[] getContentDoubles(CacheID cacheID) {
        return this.delegate.getContentDoubles(cacheID);
    }

    @Override
    public float[] getContentFloats(CacheID cacheID) {
        return this.delegate.getContentFloats(cacheID);
    }

    @Override
    public int[] getContentInts(CacheID cacheID) {
        return this.delegate.getContentInts(cacheID);
    }

    @Override
    public Object getContentObject(CacheID cacheID) {
        return this.delegate.getContentObject(cacheID);
    }

    @Override
    public short[] getContentShorts(CacheID cacheID) {
        return this.delegate.getContentShorts(cacheID);
    }

    @Override
    public int getItemPriority(CacheID cacheID) {
        return this.delegate.getItemPriority(cacheID);
    }

    @Override
    public boolean isInCache(Class<?> clazz, CacheID cacheID) {
        return this.delegate.isInCache(clazz, cacheID) && !this.checkDisposed(cacheID);
    }

    @Override
    public boolean isInMemory(CacheID cacheID) {
        return this.delegate.isInMemory(cacheID);
    }

    @Override
    public Iterator<ICacheItemGroup> listItemGroups() {
        return this.delegate.listItemGroups();
    }

    @Override
    public void putContentBytes(byte[] byArray, CacheID cacheID) {
        this.delegate.putContentBytes(byArray, cacheID);
    }

    @Override
    public void putContentBytes(byte[] byArray, CacheID cacheID, int n) {
        this.delegate.putContentBytes(byArray, cacheID, n);
    }

    @Override
    public void putContentDoubles(double[] dArray, CacheID cacheID) {
        this.delegate.putContentDoubles(dArray, cacheID);
    }

    @Override
    public void putContentFloats(float[] fArray, CacheID cacheID) {
        this.delegate.putContentFloats(fArray, cacheID);
    }

    @Override
    public void putContentInts(int[] nArray, CacheID cacheID) {
        this.delegate.putContentInts(nArray, cacheID);
    }

    @Override
    public void putContentInts(int[] nArray, CacheID cacheID, int n) {
        this.delegate.putContentInts(nArray, cacheID, n);
    }

    @Override
    public void putContentObject(Object object, CacheID cacheID) {
        this.delegate.putContentObject(object, cacheID);
    }

    @Override
    public void putContentShorts(short[] sArray, CacheID cacheID) {
        this.delegate.putContentShorts(sArray, cacheID);
    }

    @Override
    public void putContentShorts(short[] sArray, CacheID cacheID, int n) {
        this.delegate.putContentShorts(sArray, cacheID, n);
    }

    @Override
    public byte[] referencePersistentBytes(CacheID cacheID) {
        byte[] byArray = this.delegate.referencePersistentBytes(cacheID);
        this.checkDisposed(cacheID);
        return byArray;
    }

    @Override
    public double[] referencePersistentDoubles(CacheID cacheID) {
        double[] dArray = this.delegate.referencePersistentDoubles(cacheID);
        this.checkDisposed(cacheID);
        return dArray;
    }

    @Override
    public float[] referencePersistentFloats(CacheID cacheID) {
        float[] fArray = this.delegate.referencePersistentFloats(cacheID);
        this.checkDisposed(cacheID);
        return fArray;
    }

    @Override
    public int[] referencePersistentInts(CacheID cacheID) {
        int[] nArray = this.delegate.referencePersistentInts(cacheID);
        this.checkDisposed(cacheID);
        return nArray;
    }

    @Override
    public Object referencePersistentObject(CacheID cacheID, Class<?> clazz) {
        Object object = this.delegate.referencePersistentObject(cacheID, clazz);
        this.checkDisposed(cacheID);
        return object;
    }

    @Override
    public short[] referencePersistentShorts(CacheID cacheID) {
        short[] sArray = this.delegate.referencePersistentShorts(cacheID);
        this.checkDisposed(cacheID);
        return sArray;
    }

    @Override
    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
        this.delegate.releaseModifiedArrayReference(cacheID, lArray, lArray2);
        this.checkDisposed(cacheID);
    }

    @Override
    public void releaseModifiedReference(CacheID cacheID) {
        this.delegate.releaseModifiedReference(cacheID);
        this.checkDisposed(cacheID);
    }

    @Override
    public void releaseReference(CacheID cacheID) {
        try {
            this.delegate.releaseReference(cacheID);
        }
        catch (IllegalStateException illegalStateException) {
            if (this.disposed) {
                LOGGER.error("disposed=true, something went wrong with the handling of already disposed DataGroups, we need to fix this (see artf146911)", (Throwable)illegalStateException);
            } else {
                LOGGER.error("disposed=false, seems not to be related to wrong handling of already disposed DataGroups, so our initial idea seems to be wrong (see artf146911)", (Throwable)illegalStateException);
            }
            throw illegalStateException;
        }
        this.checkDisposed(cacheID);
    }

    @Override
    public void remove(CacheID cacheID) {
        this.delegate.remove(cacheID);
    }

    @Override
    public void setItemPriority(CacheID cacheID, int n) {
        this.delegate.setItemPriority(cacheID, n);
    }

    @Override
    public boolean isPoolActive(Object object, CacheID cacheID) {
        return this.delegate.isPoolActive(object, cacheID);
    }

    @Override
    public File getFile(CacheID cacheID, Class<?> clazz) {
        return this.delegate.getFile(cacheID, clazz);
    }

    @Override
    public String getGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        return this.delegate.getGroupAttribute(cacheID, clazz, string);
    }

    @Override
    public void setGroupAttribute(CacheID cacheID, Class<?> clazz, String string, String string2) {
        this.delegate.setGroupAttribute(cacheID, clazz, string, string2);
    }

    @Override
    public void deleteGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        this.delegate.deleteGroupAttribute(cacheID, clazz, string);
    }

    protected static enum DeregisterResult {
        UNKNOWN,
        REMOVED,
        NOT_REGISTERED,
        EMPTY;

    }
}

