/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.background;

import com.agfa.pacs.background.IProgressListener;
import com.agfa.pacs.background.IProgressProvider;
import com.agfa.pacs.tools.ExceptionDialogUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProgressProvider<DONE_STATE, PROGRESS_STATE, RESULT>
implements IProgressProvider<DONE_STATE, PROGRESS_STATE, RESULT> {
    private final List<IProgressListener<? super DONE_STATE, ? super PROGRESS_STATE, ? super RESULT>> progressListeners = new CopyOnWriteArrayList<IProgressListener<? super DONE_STATE, ? super PROGRESS_STATE, ? super RESULT>>();
    protected volatile boolean isDone = false;
    private DONE_STATE doneState;
    private RESULT doneResult;

    @Override
    public synchronized void attachProgressListener(IProgressListener<? super DONE_STATE, ? super PROGRESS_STATE, ? super RESULT> iProgressListener) {
        if (this.isDone) {
            iProgressListener.done(this.doneState, this.doneResult);
            return;
        }
        this.progressListeners.add(iProgressListener);
    }

    public synchronized void notifyDone(DONE_STATE DONE_STATE, RESULT RESULT) {
        if (this.isDone) {
            throw new IllegalArgumentException("Done must only be notified once");
        }
        this.doneState = DONE_STATE;
        this.doneResult = RESULT;
        this.isDone = true;
        for (IProgressListener<DONE_STATE, PROGRESS_STATE, RESULT> iProgressListener : this.progressListeners) {
            try {
                iProgressListener.done(DONE_STATE, RESULT);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialogUtils.displayExceptionToUser(runtimeException);
            }
        }
        this.progressListeners.clear();
    }

    public void notifyProgress(double d, PROGRESS_STATE PROGRESS_STATE) {
        for (IProgressListener<DONE_STATE, PROGRESS_STATE, RESULT> iProgressListener : this.progressListeners) {
            try {
                iProgressListener.progress(d, PROGRESS_STATE);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialogUtils.displayExceptionToUser(runtimeException);
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }
}

