/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.security.role.impl;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.role.IRoleManagerProvider;
import java.util.List;

public abstract class RoleManagerProviderFactory {
    private static RoleManagerProviderFactory implementation;

    public static synchronized RoleManagerProviderFactory getInstance() {
        if (implementation == null) {
            RoleManagerProviderFactory.initialize();
        }
        return implementation;
    }

    public IRoleManagerProvider getRoleManagerProvider() {
        List<IRoleManagerProvider> list = implementation.getRoleManagerProvidersInt();
        if (list.size() == 0 || list.size() > 1) {
            ALogger.getLogger((String)"RoleManager").error("Multiple or nor RoleManager providers found.");
            return null;
        }
        return list.get(0);
    }

    protected abstract List<IRoleManagerProvider> getRoleManagerProvidersInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)RoleManagerProviderFactory.class.getName()));
            implementation = (RoleManagerProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + RoleManagerProviderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

