/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.renderer.layout;

import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxLayoutException;
import com.agfa.pacs.listtext.print.renderer.layout.AbstractFilmBoxLayout;
import com.agfa.pacs.listtext.print.renderer.layout.LayoutBox;
import java.util.List;

public class RowFilmBoxLayout
extends AbstractFilmBoxLayout {
    private int[] numberOfBoxesPerRow;
    private int numberOfBoxes;

    public RowFilmBoxLayout(int[] nArray) {
        this.numberOfBoxesPerRow = nArray;
        this.numberOfBoxes = 0;
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            this.numberOfBoxes += n3;
            ++n2;
        }
    }

    @Override
    public int getNumberOfImageBoxes() {
        return this.numberOfBoxes;
    }

    @Override
    public void layout(List<? extends LayoutBox> list) throws FilmBoxLayoutException {
        int n = this.numberOfBoxesPerRow.length;
        int n2 = 0;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = 0.0;
            dArray2[n3] = 0.0;
            dArray3[n3] = -1.0;
            dArray4[n3] = -1.0;
            ++n3;
        }
        n2 = 0;
        n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.numberOfBoxesPerRow[n3]) {
                LayoutBox layoutBox = list.get(n2);
                this.assignIfGreater(dArray3, n4, layoutBox.getMinimumHeight());
                this.assignIfGreater(dArray4, n4, layoutBox.getMaximumHeight());
                this.add(dArray, n4, layoutBox.getMinimumWidth());
                this.add(dArray2, n4, layoutBox.getMaximumWidth());
                ++n2;
                ++n4;
            }
            ++n3;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n5 = 0;
        while (n5 < n) {
            if (dArray3[n5] > 0.0) {
                d2 += dArray3[n5];
            }
            d = this.returnIfGreater(d, dArray[n5], this.gapWidth * (double)(this.numberOfBoxesPerRow[n5] - 1));
            ++n5;
        }
        double d3 = this.gapHeight * (double)(n - 1);
        if (d2 + d3 > this.height) {
            throw new FilmBoxLayoutException("Required minimum height exceeds area height", FilmBoxLayoutException.Problem.MinimumHeightExceeded);
        }
        if (d > this.width) {
            throw new FilmBoxLayoutException("Required minimum width exceeds area width", FilmBoxLayoutException.Problem.MinimumWidthExceeded);
        }
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double d4 = 0.0;
        int n6 = 0;
        while (n6 < n) {
            double d5 = (this.height - d3 - d4) / (double)(n - n6);
            d5 = this.returnIfGreater(d5, dArray3[n6], 0.0);
            d5 = this.returnIfLower(d5, dArray4[n6]);
            dArray5[n6] = d4 + this.gapHeight * (double)n6;
            dArray6[n6] = d5;
            d4 += d5;
            ++n6;
        }
        n2 = 0;
        n6 = 0;
        while (n6 < n) {
            int n7 = this.numberOfBoxesPerRow[n6];
            double d6 = this.gapWidth * (double)(n7 - 1);
            double d7 = 0.0;
            int n8 = 0;
            while (n8 < n7) {
                LayoutBox layoutBox = list.get(n2);
                double d8 = (this.width - d6 - d7) / (double)(n7 - n8);
                d8 = this.returnIfGreater(d8, layoutBox.getMinimumWidth(), 0.0);
                d8 = this.returnIfLower(d8, layoutBox.getMaximumWidth());
                double d9 = dArray5[n6];
                double d10 = d7 + this.gapWidth * (double)n8;
                double d11 = dArray6[n6];
                double d12 = d8;
                if (layoutBox.getMaximumWidth() > 0.0 && d12 > layoutBox.getMaximumWidth()) {
                    d10 += (d12 - layoutBox.getMaximumWidth()) / 2.0;
                    d12 = layoutBox.getMaximumWidth();
                }
                if (layoutBox.getMaximumHeight() > 0.0 && d11 > layoutBox.getMaximumHeight()) {
                    d9 += (d11 - layoutBox.getMaximumHeight()) / 2.0;
                    d11 = layoutBox.getMaximumHeight();
                }
                layoutBox.set(this.posX + d10, this.posY + d9, d12, d11);
                d7 += d8;
                ++n2;
                ++n8;
            }
            ++n6;
        }
    }

    private void assignIfGreater(double[] dArray, int n, double d) {
        if (d > 0.0 && d > dArray[n]) {
            dArray[n] = d;
        }
    }

    private void add(double[] dArray, int n, double d) {
        if (d > 0.0) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
        }
    }

    private double returnIfGreater(double d, double d2, double d3) {
        if (d2 > 0.0 && d2 > d) {
            return d2 + d3;
        }
        return d;
    }

    private double returnIfLower(double d, double d2) {
        if (d2 > 0.0 && d2 < d) {
            return d2;
        }
        return d;
    }
}

