/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.renderer.layout;

import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxLayoutException;
import com.agfa.pacs.listtext.print.renderer.layout.AbstractFilmBoxLayout;
import com.agfa.pacs.listtext.print.renderer.layout.LayoutBox;
import java.util.List;

public class RasterFilmBoxLayout
extends AbstractFilmBoxLayout {
    private int rows;
    private int columns;

    public RasterFilmBoxLayout(int n, int n2) {
        this.columns = n;
        this.rows = n2;
    }

    @Override
    public int getNumberOfImageBoxes() {
        return this.columns * this.rows;
    }

    @Override
    public void layout(List<? extends LayoutBox> list) throws FilmBoxLayoutException {
        if (list.size() != this.getNumberOfImageBoxes()) {
            throw new FilmBoxLayoutException("Invalid number of boxes", FilmBoxLayoutException.Problem.InvalidNumberOfImageBoxes);
        }
        LayoutBox[][] layoutBoxArray = new LayoutBox[this.rows][this.columns];
        double[] dArray = new double[this.columns];
        double[] dArray2 = new double[this.columns];
        double[] dArray3 = new double[this.rows];
        double[] dArray4 = new double[this.rows];
        int n = 0;
        while (n < this.columns) {
            dArray[n] = -1.0;
            dArray2[n] = -1.0;
            ++n;
        }
        n = 0;
        while (n < this.rows) {
            dArray3[n] = -1.0;
            dArray4[n] = -1.0;
            ++n;
        }
        n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.columns) {
                LayoutBox layoutBox;
                layoutBoxArray[n][n2] = layoutBox = list.get(n * this.columns + n2);
                this.assignIfGreater(dArray, n2, layoutBox.getMinimumWidth());
                this.assignIfGreater(dArray2, n2, layoutBox.getMaximumWidth());
                this.assignIfGreater(dArray3, n2, layoutBox.getMinimumHeight());
                this.assignIfGreater(dArray4, n2, layoutBox.getMaximumHeight());
                ++n2;
            }
            ++n;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < this.columns) {
            if (dArray[n3] > 0.0) {
                d += dArray[n3];
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.rows) {
            if (dArray3[n3] > 0.0) {
                d2 += dArray3[n3];
            }
            ++n3;
        }
        double d3 = this.gapWidth * (double)(this.columns - 1);
        double d4 = this.gapHeight * (double)(this.rows - 1);
        if (d + d3 > this.width) {
            throw new FilmBoxLayoutException("Required minimum width exceeds area width", FilmBoxLayoutException.Problem.MinimumWidthExceeded);
        }
        if (d2 + d4 > this.height) {
            throw new FilmBoxLayoutException("Required minimum height exceeds area height", FilmBoxLayoutException.Problem.MinimumHeightExceeded);
        }
        double[] dArray5 = new double[this.columns];
        double[] dArray6 = new double[this.columns];
        double d5 = 0.0;
        int n4 = 0;
        while (n4 < this.columns) {
            double d6 = (this.width - d3 - d5) / (double)(this.columns - n4);
            d6 = this.returnIfGreater(d6, dArray[n4]);
            d6 = this.returnIfLower(d6, dArray2[n4]);
            dArray5[n4] = d5 + this.gapWidth * (double)n4;
            dArray6[n4] = d6;
            d5 += d6;
            ++n4;
        }
        double[] dArray7 = new double[this.rows];
        double[] dArray8 = new double[this.rows];
        double d7 = 0.0;
        int n5 = 0;
        while (n5 < this.rows) {
            double d8 = (this.height - d4 - d7) / (double)(this.rows - n5);
            d8 = this.returnIfGreater(d8, dArray3[n5]);
            d8 = this.returnIfLower(d8, dArray4[n5]);
            dArray7[n5] = d7 + this.gapHeight * (double)n5;
            dArray8[n5] = d8;
            d7 += d8;
            ++n5;
        }
        n5 = 0;
        while (n5 < this.rows) {
            int n6 = 0;
            while (n6 < this.columns) {
                LayoutBox layoutBox = layoutBoxArray[n5][n6];
                double d9 = dArray5[n6];
                double d10 = dArray7[n5];
                double d11 = dArray6[n6];
                double d12 = dArray8[n5];
                if (layoutBox.getMaximumWidth() > 0.0 && d11 > layoutBox.getMaximumWidth()) {
                    d9 += (d11 - layoutBox.getMaximumWidth()) / 2.0;
                    d11 = layoutBox.getMaximumWidth();
                }
                if (layoutBox.getMaximumHeight() > 0.0 && d12 > layoutBox.getMaximumHeight()) {
                    d10 += (d12 - layoutBox.getMaximumHeight()) / 2.0;
                    d12 = layoutBox.getMaximumHeight();
                }
                layoutBox.set(this.posX + d9, this.posY + d10, d11, d12);
                ++n6;
            }
            ++n5;
        }
    }

    private void assignIfGreater(double[] dArray, int n, double d) {
        if (d > 0.0 && d > dArray[n]) {
            dArray[n] = d;
        }
    }

    private double returnIfGreater(double d, double d2) {
        if (d2 > 0.0 && d2 > d) {
            return d2;
        }
        return d;
    }

    private double returnIfLower(double d, double d2) {
        if (d2 > 0.0 && d2 < d) {
            return d2;
        }
        return d;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }
}

