/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.renderer.layout;

import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxLayoutException;
import com.agfa.pacs.listtext.print.renderer.layout.AbstractFilmBoxLayout;
import com.agfa.pacs.listtext.print.renderer.layout.LayoutBox;
import java.util.List;

public class ColumnFilmBoxLayout
extends AbstractFilmBoxLayout {
    private int[] numberOfBoxesPerColumn;
    private int numberOfBoxes;

    public ColumnFilmBoxLayout(int[] nArray) {
        this.numberOfBoxesPerColumn = nArray;
        this.numberOfBoxes = 0;
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            this.numberOfBoxes += n3;
            ++n2;
        }
    }

    @Override
    public int getNumberOfImageBoxes() {
        return this.numberOfBoxes;
    }

    @Override
    public void layout(List<? extends LayoutBox> list) throws FilmBoxLayoutException {
        int n = this.numberOfBoxesPerColumn.length;
        int n2 = 0;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = -1.0;
            dArray2[n3] = -1.0;
            dArray3[n3] = 0.0;
            dArray4[n3] = 0.0;
            ++n3;
        }
        n2 = 0;
        n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.numberOfBoxesPerColumn[n3]) {
                LayoutBox layoutBox = list.get(n2);
                this.assignIfGreater(dArray, n3, layoutBox.getMinimumWidth());
                this.assignIfGreater(dArray2, n3, layoutBox.getMaximumWidth());
                this.add(dArray3, n3, layoutBox.getMinimumHeight());
                this.add(dArray4, n3, layoutBox.getMaximumHeight());
                ++n2;
                ++n4;
            }
            ++n3;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n5 = 0;
        while (n5 < n) {
            if (dArray[n5] > 0.0) {
                d += dArray[n5];
            }
            d2 = this.returnIfGreater(d2, dArray3[n5], this.gapHeight * (double)(this.numberOfBoxesPerColumn[n5] - 1));
            ++n5;
        }
        double d3 = this.gapWidth * (double)(n - 1);
        if (d + d3 > this.width) {
            throw new FilmBoxLayoutException("Required minimum width exceeds area width", FilmBoxLayoutException.Problem.MinimumWidthExceeded);
        }
        if (d2 > this.height) {
            throw new FilmBoxLayoutException("Required minimum height exceeds area height", FilmBoxLayoutException.Problem.MinimumHeightExceeded);
        }
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double d4 = 0.0;
        int n6 = 0;
        while (n6 < n) {
            double d5 = (this.width - d3 - d4) / (double)(n - n6);
            d5 = this.returnIfGreater(d5, dArray[n6], 0.0);
            d5 = this.returnIfLower(d5, dArray2[n6]);
            dArray5[n6] = d4 + this.gapWidth * (double)n6;
            dArray6[n6] = d5;
            d4 += d5;
            ++n6;
        }
        n2 = 0;
        n6 = 0;
        while (n6 < n) {
            int n7 = this.numberOfBoxesPerColumn[n6];
            double d6 = this.gapHeight * (double)(n7 - 1);
            double d7 = 0.0;
            int n8 = 0;
            while (n8 < n7) {
                LayoutBox layoutBox = list.get(n2);
                double d8 = (this.height - d6 - d7) / (double)(n7 - n8);
                d8 = this.returnIfGreater(d8, layoutBox.getMinimumHeight(), 0.0);
                d8 = this.returnIfLower(d8, layoutBox.getMaximumHeight());
                double d9 = dArray5[n6];
                double d10 = d7 + this.gapHeight * (double)n8;
                double d11 = dArray6[n6];
                double d12 = d8;
                if (layoutBox.getMaximumWidth() > 0.0 && d11 > layoutBox.getMaximumWidth()) {
                    d9 += (d11 - layoutBox.getMaximumWidth()) / 2.0;
                    d11 = layoutBox.getMaximumWidth();
                }
                if (layoutBox.getMaximumHeight() > 0.0 && d12 > layoutBox.getMaximumHeight()) {
                    d10 += (d12 - layoutBox.getMaximumHeight()) / 2.0;
                    d12 = layoutBox.getMaximumHeight();
                }
                layoutBox.set(this.posX + d9, this.posY + d10, d11, d12);
                d7 += d8;
                ++n2;
                ++n8;
            }
            ++n6;
        }
    }

    private void assignIfGreater(double[] dArray, int n, double d) {
        if (d > 0.0 && d > dArray[n]) {
            dArray[n] = d;
        }
    }

    private void add(double[] dArray, int n, double d) {
        if (d > 0.0) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
        }
    }

    private double returnIfGreater(double d, double d2, double d3) {
        if (d2 > 0.0 && d2 > d) {
            return d2 + d3;
        }
        return d;
    }

    private double returnIfLower(double d, double d2) {
        if (d2 > 0.0 && d2 < d) {
            return d2;
        }
        return d;
    }
}

