/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.renderer;

import com.agfa.pacs.listtext.print.IFilmBoxResolution;
import com.agfa.pacs.listtext.print.IFilmSize;
import com.agfa.pacs.listtext.print.renderer.FilmBox;
import com.agfa.pacs.listtext.print.renderer.FilmBoxRenderer;
import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxLayoutException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.Paper;

public class FilmBoxSheet {
    public static final double PTS_PER_MM = 2.834645669291339;
    public static final double PTS_PER_INCH = 72.0;
    private FilmBox filmBox;
    private IFilmSize filmBoxMedium;
    private IFilmBoxResolution filmBoxResolution;
    private boolean rotated;
    private Double zoomRatio = null;
    private Image customLogo = null;
    private double customLogoPrintHeight;
    private int customLogoAlignment;

    public FilmBoxSheet(FilmBox filmBox, IFilmSize iFilmSize, IFilmBoxResolution iFilmBoxResolution, Double d, boolean bl, Image image, int n, int n2) {
        this.filmBox = filmBox;
        this.filmBoxMedium = iFilmSize;
        this.filmBoxResolution = iFilmBoxResolution;
        this.rotated = bl;
        this.zoomRatio = d;
        this.customLogo = image;
        if (image != null) {
            this.customLogoPrintHeight = n;
            this.customLogoAlignment = n2;
        }
    }

    public void layout() throws FilmBoxLayoutException {
        double d = this.filmBoxMedium.getHeight();
        double d2 = this.filmBoxMedium.getTopBorder();
        if (this.rotated) {
            this.filmBox.setWidth(d);
            this.filmBox.setHeight(this.filmBoxMedium.getWidth());
            this.filmBox.setBorderLeftWidth(d2);
            this.filmBox.setBorderTopHeight(this.filmBoxMedium.getLeftBorder());
            this.filmBox.setBorderRightWidth(this.filmBoxMedium.getBottomBorder());
            this.filmBox.setBorderBottomHeight(this.filmBoxMedium.getRightBorder());
        } else {
            this.filmBox.setWidth(this.filmBoxMedium.getWidth());
            this.filmBox.setHeight(d);
            this.filmBox.setBorderLeftWidth(this.filmBoxMedium.getLeftBorder());
            this.filmBox.setBorderTopHeight(d2);
            this.filmBox.setBorderRightWidth(this.filmBoxMedium.getRightBorder());
            this.filmBox.setBorderBottomHeight(this.filmBoxMedium.getBottomBorder());
        }
        this.filmBox.layout();
    }

    static double mm2paper(double d) {
        return d * 2.834645669291339;
    }

    static double paper2mm(double d) {
        return d / 2.834645669291339;
    }

    public Double getZoomRatio() {
        return this.zoomRatio;
    }

    public void layout(Paper paper) throws FilmBoxLayoutException {
        double d;
        double d2 = this.rotated ? paper.getImageableHeight() : paper.getImageableWidth();
        double d3 = this.rotated ? paper.getImageableWidth() : paper.getImageableHeight();
        double d4 = this.rotated ? paper.getImageableY() : paper.getImageableX();
        double d5 = d = this.rotated ? paper.getImageableX() : paper.getImageableY();
        if (this.customLogo != null) {
            d5 += FilmBoxSheet.mm2paper(this.customLogoPrintHeight);
        }
        this.filmBox.setWidth(FilmBoxSheet.paper2mm(d2 + 2.0 * d4));
        this.filmBox.setHeight(FilmBoxSheet.paper2mm(d3 + 2.0 * d));
        this.filmBox.setBorderBottomHeight(FilmBoxSheet.paper2mm(d));
        this.filmBox.setBorderLeftWidth(FilmBoxSheet.paper2mm(d4));
        this.filmBox.setBorderRightWidth(FilmBoxSheet.paper2mm(d4));
        this.filmBox.setBorderTopHeight(FilmBoxSheet.paper2mm(d5));
        this.filmBox.layout();
    }

    public FilmBoxRenderer createFilmBoxRenderer() {
        FilmBoxRenderer filmBoxRenderer = new FilmBoxRenderer(this, false);
        filmBoxRenderer.setWidth(this.filmBox.getWidth());
        filmBoxRenderer.setHeight(this.filmBox.getHeight());
        filmBoxRenderer.setResolutionPixelPerInch(this.filmBoxResolution.getResolutionDPI());
        filmBoxRenderer.setZoomRatio(this.zoomRatio);
        return filmBoxRenderer;
    }

    public Paper getPaper() {
        Paper paper = new Paper();
        paper.setSize(this.filmBox.getWidth() * 2.834645669291339, this.filmBox.getHeight() * 2.834645669291339);
        paper.setImageableArea(this.filmBox.getBorderLeftWidth() * 2.834645669291339, this.filmBox.getBorderTopHeight() * 2.834645669291339, (this.filmBox.getWidth() - 2.0 * this.filmBox.getBorderRightWidth()) * 2.834645669291339, (this.filmBox.getHeight() - 2.0 * this.filmBox.getBorderBottomHeight()) * 2.834645669291339);
        return paper;
    }

    public BufferedImage createPreview(boolean bl, RenderingHints renderingHints, int n) {
        FilmBoxRenderer filmBoxRenderer = new FilmBoxRenderer(this, true);
        filmBoxRenderer.setPaintBackground(true);
        filmBoxRenderer.setWidth(this.filmBox.getWidth());
        filmBoxRenderer.setHeight(this.filmBox.getHeight());
        filmBoxRenderer.setResolutionPixelPerInch(n);
        filmBoxRenderer.setZoomRatio(this.zoomRatio);
        if (bl) {
            int n2 = filmBoxRenderer.toPixel(this.filmBoxMedium.getWidth());
            int n3 = filmBoxRenderer.toPixel(this.filmBoxMedium.getHeight());
            int n4 = filmBoxRenderer.toPixel(this.filmBoxMedium.getLeftBorder());
            int n5 = filmBoxRenderer.toPixel(this.filmBoxMedium.getRightBorder());
            int n6 = filmBoxRenderer.toPixel(this.filmBoxMedium.getTopBorder());
            int n7 = filmBoxRenderer.toPixel(this.filmBoxMedium.getBottomBorder());
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            if (renderingHints != null) {
                graphics2D.addRenderingHints(renderingHints);
            }
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n2, n6);
            graphics2D.fillRect(0, n3 - n7, n2, n7);
            graphics2D.fillRect(0, n6, n4, n3 - n6 - n7);
            graphics2D.fillRect(n2 - n5, n6, n5, n3 - n6 - n7);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(0, 0, n2 - 1, n3 - 1);
            graphics2D.translate(n4, n6);
            filmBoxRenderer.setGraphics(graphics2D, bufferedImage.getType());
            filmBoxRenderer.render(this);
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(filmBoxRenderer.getPixelWidth(), filmBoxRenderer.getPixelHeight(), 1);
        filmBoxRenderer.setGraphics((Graphics2D)bufferedImage.getGraphics(), bufferedImage.getType());
        filmBoxRenderer.render(this);
        return bufferedImage;
    }

    public BufferedImage createPreview(boolean bl, RenderingHints renderingHints) {
        return this.createPreview(bl, renderingHints, 72);
    }

    public FilmBox getFilmBox() {
        return this.filmBox;
    }

    public Image getCustomLogo() {
        return this.customLogo;
    }

    public double getCustomLogoPrintHeight() {
        return this.customLogoPrintHeight;
    }

    public int getCustomLogoAlignment() {
        return this.customLogoAlignment;
    }
}

