/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.renderer;

import com.agfa.pacs.listtext.print.renderer.Annotation;
import com.agfa.pacs.listtext.print.renderer.ImageBox;
import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxLayoutException;
import com.agfa.pacs.listtext.print.renderer.layout.IFilmBoxLayout;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class FilmBox {
    private double borderLeftWidth = 3.0;
    private double borderRightWidth = 3.0;
    private double borderTopHeight = 3.0;
    private double borderBottomHeight = 3.0;
    private double gapWidth = 3.0;
    private double gapHeight = 3.0;
    private Color borderColor = Color.BLACK;
    private Color gapColor = Color.BLACK;
    private double imageBoxBorderThickness = 0.3;
    private Color imageBoxBorderColor = Color.WHITE;
    private Color imageBoxColor = Color.BLACK;
    private IFilmBoxLayout filmBoxLayout;
    private List<ImageBox> imageBoxes;
    private double width;
    private double height;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private Font mappingFont;
    private double mappingFontSize = 3.0;
    private boolean mappingImageBox = true;
    private Color mappingColor = Color.YELLOW;

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getBorderLeftWidth() {
        return this.borderLeftWidth;
    }

    public double getBorderRightWidth() {
        return this.borderRightWidth;
    }

    public double getBorderTopHeight() {
        return this.borderTopHeight;
    }

    public double getBorderBottomHeight() {
        return this.borderBottomHeight;
    }

    public double getGapHeight() {
        return this.gapHeight;
    }

    public void setGapHeight(double d) {
        this.gapHeight = d;
    }

    public double getGapWidth() {
        return this.gapWidth;
    }

    public void setGapWidth(double d) {
        this.gapWidth = d;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setBorderTopHeight(double d) {
        this.borderTopHeight = d;
    }

    public void setBorderBottomHeight(double d) {
        this.borderBottomHeight = d;
    }

    public void setBorderLeftWidth(double d) {
        this.borderLeftWidth = d;
    }

    public void setBorderRightWidth(double d) {
        this.borderRightWidth = d;
    }

    public void setGapColor(Color color) {
        this.gapColor = color;
    }

    public void setImageBoxBorderColor(Color color) {
        this.imageBoxBorderColor = color;
    }

    public void setImageBoxBorderThickness(double d) {
        this.imageBoxBorderThickness = d;
    }

    public void setImageBoxColor(Color color) {
        this.imageBoxColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getGapColor() {
        return this.gapColor;
    }

    public double getImageBoxBorderThickness() {
        return this.imageBoxBorderThickness;
    }

    public Color getImageBoxBorderColor() {
        return this.imageBoxBorderColor;
    }

    public Color getImageBoxColor() {
        return this.imageBoxColor;
    }

    public void setFilmBoxLayout(IFilmBoxLayout iFilmBoxLayout) {
        this.filmBoxLayout = iFilmBoxLayout;
        this.imageBoxes = new ArrayList<ImageBox>();
        int n = 0;
        while (n < this.filmBoxLayout.getNumberOfImageBoxes()) {
            this.imageBoxes.add(new ImageBox());
            ++n;
        }
    }

    public List<ImageBox> imageBoxes() {
        return this.imageBoxes;
    }

    public List<Annotation> annotations() {
        return this.annotations;
    }

    public void layout() throws FilmBoxLayoutException {
        this.filmBoxLayout.setPosX(this.borderLeftWidth);
        this.filmBoxLayout.setPosY(this.borderTopHeight);
        this.filmBoxLayout.setWidth(this.width - this.borderLeftWidth - this.borderRightWidth);
        this.filmBoxLayout.setHeight(this.height - this.borderTopHeight - this.borderBottomHeight);
        this.filmBoxLayout.setGapWidth(this.gapWidth);
        this.filmBoxLayout.setGapHeight(this.gapHeight);
        this.filmBoxLayout.layout(this.imageBoxes);
        for (Annotation annotation : this.annotations) {
            annotation.layout(this.width, this.height);
        }
    }

    public Font getMappingFont() {
        return this.mappingFont;
    }

    public void setMappingFont(Font font) {
        this.mappingFont = font;
    }

    public double getMappingFontSize() {
        return this.mappingFontSize;
    }

    public void setMappingFontSize(double d) {
        this.mappingFontSize = d;
    }

    public boolean isMappingImageBox() {
        return this.mappingImageBox;
    }

    public void setMappingImageBox(boolean bl) {
        this.mappingImageBox = bl;
    }

    public Color getMappingColor() {
        return this.mappingColor;
    }

    public void setMappingColor(Color color) {
        this.mappingColor = color;
    }
}

