/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.mapper;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrameProvider;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameUtilities;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.dicomobject.renderer.DicomObjectRendererFactory;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.agfa.pacs.listtext.print.mapper.IDicomEvaluation;
import com.agfa.pacs.listtext.print.mapper.MapperConfigurationContainer;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class MapperImageBox
extends MapperConfigurationContainer
implements IDicomDataListener {
    private Integer index;
    private IObjectInfo objectInfo;
    private int itemNumber;
    private IDicomObjectRenderer dicomObjectRenderer;
    private PresentationSizeMode sizeMode = PresentationSizeMode.ScaleToFit;
    private Attributes dataset;
    private boolean includeMappings;
    private boolean mappingsOutside;
    private IFramePresentationStateSource framePresentationStateSource;
    private IDicomEvaluation evaluator;
    private Map<Integer, String> annotations = null;

    public MapperImageBox(Integer n) {
        this.index = n;
    }

    public void setPresentationSizeMode(PresentationSizeMode presentationSizeMode) {
        this.sizeMode = presentationSizeMode;
    }

    public PresentationSizeMode getPresentationSizeMode() {
        return this.sizeMode;
    }

    public Map<Integer, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<Integer, String> map) {
        this.annotations = map;
    }

    public void setEvaluator(IDicomEvaluation iDicomEvaluation) {
        this.evaluator = iDicomEvaluation;
    }

    public IDicomEvaluation getEvaluator() {
        return this.evaluator;
    }

    public boolean isIncludeMappings() {
        return this.includeMappings;
    }

    public boolean isMappingsOutside() {
        return this.mappingsOutside;
    }

    public void setIncludeMappings(boolean bl) {
        this.includeMappings = bl;
    }

    public void setMappingsOutside(boolean bl) {
        this.mappingsOutside = bl;
    }

    public void setContent(IObjectInfo iObjectInfo, int n) {
        this.objectInfo = iObjectInfo;
        this.itemNumber = n;
    }

    public IObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    public Integer getIndex() {
        return this.index;
    }

    public int getItemNumber() {
        return this.itemNumber;
    }

    public IDicomObjectRenderer getDicomObjectRenderer() {
        return this.dicomObjectRenderer;
    }

    public void setDicomObjectRenderer(IDicomObjectRenderer iDicomObjectRenderer) {
        this.dicomObjectRenderer = iDicomObjectRenderer;
    }

    public void setFramePresentationStateSource(IFramePresentationStateSource iFramePresentationStateSource) {
        this.framePresentationStateSource = iFramePresentationStateSource;
    }

    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        this.dataset = attributes;
        if (this.annotations != null && this.evaluator != null) {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            for (Map.Entry<Integer, String> entry : this.annotations.entrySet()) {
                hashMap.put(entry.getKey(), this.evaluator.evaluate(entry.getValue(), this.dataset));
            }
            this.annotations = hashMap;
        }
    }

    public void dicomDataError(String string, String string2, Throwable throwable) {
    }

    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
    }

    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        if (!this.objectInfo.getSOPInstanceUID().equals(string)) {
            return;
        }
        if (this.itemNumber != n) {
            return;
        }
        IPixelDataFrame iPixelDataFrame = PixelDataFrameUtilities.createPixelDataFrame((IPixelDataFrameProvider)PixelDataFrameUtilities.DefaultPixelDataFrameProvider, (IPixelDataInfo)iPixelDataInfo, (String)string);
        this.dicomObjectRenderer = DicomObjectRendererFactory.getInstance().createDicomObjectRenderer(this.dataset, iPixelDataFrame, n, null);
        if (this.framePresentationStateSource != null) {
            IFramePresentationState iFramePresentationState = this.framePresentationStateSource.getFramePresentationState(string, this.dataset, n, iPixelDataFrame);
            this.dicomObjectRenderer.setPresentationState(iFramePresentationState);
        }
    }
}

