/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentationstate;

import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.presentation.SoftcopyPresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractPresentationStateInfo
implements IPresentationStateInfo {
    protected List<IFramePresentationStateProvider> providers;
    protected Set<String> providerUIDs;
    private HashSet<String> referencedSeries = new HashSet();

    public AbstractPresentationStateInfo() {
        this.providers = new ArrayList<IFramePresentationStateProvider>();
        this.providerUIDs = new HashSet<String>();
    }

    @Override
    public void add(IFramePresentationStateProvider iFramePresentationStateProvider) {
        if (!this.contains(iFramePresentationStateProvider.getProviderUID())) {
            this.providers.add(iFramePresentationStateProvider);
            this.providerUIDs.add(iFramePresentationStateProvider.getProviderUID());
        }
    }

    @Override
    public boolean contains(String string) {
        return this.providerUIDs.contains(string);
    }

    @Override
    public boolean containsFrame(String string, int n) {
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            if (!iFramePresentationStateProvider.hasFramePresentationState(string, n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSpatialTransformation(String string, int n) {
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            if (!iFramePresentationStateProvider.hasFramePresentationState(string, n)) continue;
            return iFramePresentationStateProvider.hasSpatialTransformation(string, n);
        }
        return false;
    }

    @Override
    public boolean containsSeries(String string) {
        if (this.referencedSeries.contains(string)) {
            return true;
        }
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            SoftcopyPresentationStateProvider softcopyPresentationStateProvider;
            if (!(iFramePresentationStateProvider instanceof SoftcopyPresentationStateProvider) || !(softcopyPresentationStateProvider = (SoftcopyPresentationStateProvider)iFramePresentationStateProvider).referencesSeries(string)) continue;
            this.referencedSeries.add(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsUnsavedGraphicAnnotations() {
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            if (!iFramePresentationStateProvider.containsUnsavedGraphicAnnotations()) continue;
            return true;
        }
        return false;
    }
}

