/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitReader;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.EmptyOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataFactory;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.RLEOverlayDataWriter;
import com.agfa.pacs.logging.ALogger;

public class RLEOverlayDataFactory
implements IOverlayDataFactory {
    private static final ALogger logger = ALogger.getLogger(RLEOverlayDataFactory.class);

    @Override
    public IOverlayData createOverlayData(byte[] byArray, int n, int n2, int n3) {
        BitReader bitReader = new BitReader(byArray, n * n2 * n3);
        try {
            IOverlayDataWriter iOverlayDataWriter = this.createOverlayDataWriter();
            iOverlayDataWriter.start();
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n) {
                    iOverlayDataWriter.setBit(bitReader.getBit());
                    ++n5;
                }
                iOverlayDataWriter.nextLine();
                ++n4;
            }
            iOverlayDataWriter.end();
            return iOverlayDataWriter.getOverlayData(n, n2);
        }
        catch (Exception exception) {
            logger.error("Error creating overlay data - returning empty instance", (Throwable)exception);
            return new EmptyOverlayData();
        }
    }

    @Override
    public IOverlayData createOverlayData(IPixelDataFrame iPixelDataFrame, int n) {
        try {
            int n2;
            int n3;
            Object[] objectArray;
            int n4;
            Object object = iPixelDataFrame.getOriginalData();
            int n5 = iPixelDataFrame.getWidth();
            int n6 = iPixelDataFrame.getHeight();
            IOverlayDataWriter iOverlayDataWriter = this.createOverlayDataWriter();
            iOverlayDataWriter.start();
            if (object instanceof byte[]) {
                n4 = 0;
                objectArray = (byte[])object;
                n3 = 0;
                while (n3 < n6) {
                    n2 = 0;
                    while (n2 < n5) {
                        iOverlayDataWriter.setBit(objectArray[n4++] >> n & 1);
                        ++n2;
                    }
                    iOverlayDataWriter.nextLine();
                    ++n3;
                }
            }
            if (object instanceof short[]) {
                n4 = 0;
                objectArray = (short[])object;
                n3 = 0;
                while (n3 < n6) {
                    n2 = 0;
                    while (n2 < n5) {
                        iOverlayDataWriter.setBit(objectArray[n4++] >> n & 1);
                        ++n2;
                    }
                    iOverlayDataWriter.nextLine();
                    ++n3;
                }
            }
            iOverlayDataWriter.end();
            iPixelDataFrame.releaseOriginalData(object);
            return iOverlayDataWriter.getOverlayData(n5, n6);
        }
        catch (Exception exception) {
            logger.warn("Error creating overlay data - returning empty instance", (Throwable)exception);
            return new EmptyOverlayData();
        }
    }

    @Override
    public IOverlayDataWriter createOverlayDataWriter() {
        return new RLEOverlayDataWriter();
    }
}

