/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitReader;
import com.agfa.pacs.data.shared.BitWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.AbstractOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ByteOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.GraphicsOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataLine;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IntOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ShortOverlayRenderer;
import java.awt.Graphics;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

public class PaddedOverlayData
implements IOverlayData {
    private final byte[] data;
    private final int width;
    private final int height;
    private final int stride;

    public PaddedOverlayData(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.width = n;
        this.stride = (n + 7) / 8;
        this.height = n2;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final void renderTo(int n, int n2, Graphics graphics) {
        GraphicsOverlayRenderer graphicsOverlayRenderer = new GraphicsOverlayRenderer(n, n2, graphics);
        int n3 = 0;
        while (n3 < this.height) {
            graphicsOverlayRenderer.drawLine(this.data, n3 * this.stride, this.width);
            ++n3;
        }
    }

    @Override
    public final void renderTo(int n, int n2, Object object, int n3, int n4) {
        AbstractOverlayRenderer abstractOverlayRenderer = null;
        if (object instanceof DataBufferByte) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, ((DataBufferByte)object).getData(), n3, (byte)n4);
        }
        if (object instanceof DataBufferShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferUShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferUShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferInt) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, ((DataBufferInt)object).getData(), n3, n4);
        }
        if (object instanceof byte[]) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, (byte[])object, n3, (byte)n4);
        }
        if (object instanceof short[]) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, (short[])object, n3, (byte)n4);
        }
        if (object instanceof int[]) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, (int[])object, n3, n4);
        }
        BitReader bitReader = new BitReader(this.data);
        int n5 = 0;
        while (n5 < this.height) {
            byte[] byArray = bitReader.getBits(this.width);
            abstractOverlayRenderer.drawLine(byArray, this.width);
            ++n5;
        }
    }

    @Override
    public final byte[] toPackedBits() {
        BitWriter bitWriter = new BitWriter();
        this.writePackedBits(bitWriter);
        return bitWriter.toBytes();
    }

    public final byte[] toPaddedLineBits() {
        return this.data;
    }

    public final void writePackedBits(BitWriter bitWriter) {
        int n = 0;
        while (n < this.height) {
            bitWriter.writeBits(this.data, n * this.stride, this.width);
            ++n;
        }
    }

    @Override
    public final void writePackedBits(BitWriter bitWriter, int n, int n2, int n3, int n4, int n5) {
        bitWriter.writeBit(0, n * n4);
        int n6 = 0;
        while (n6 < this.height) {
            bitWriter.writeBit(0, n2);
            bitWriter.writeBits(this.data, n6 * this.stride, this.width);
            bitWriter.writeBit(0, n3);
            ++n6;
        }
        bitWriter.writeBit(0, n * n5);
    }

    public final IOverlayDataLine getLine(int n) {
        return new OverlayDataLine(n * this.stride);
    }

    private final class OverlayDataLine
    implements IOverlayDataLine {
        private final int lineOffset;

        public OverlayDataLine(int n) {
            this.lineOffset = n;
        }

        @Override
        public final int getBit(int n) {
            byte by = PaddedOverlayData.this.data[this.lineOffset + (n >> 3)];
            if (by == 0) {
                return 0;
            }
            return by >> (n & 7) & 1;
        }

        @Override
        public final int getPosOfFirstBit() {
            int n = 0;
            int n2 = this.lineOffset;
            while (n < PaddedOverlayData.this.width) {
                int n3 = PaddedOverlayData.this.data[n2++];
                if (n3 == 0) {
                    if ((n += 8) <= PaddedOverlayData.this.width) continue;
                    return PaddedOverlayData.this.width;
                }
                while ((n3 & 1) != 1) {
                    ++n;
                    n3 >>= 1;
                }
                return n;
            }
            return n;
        }

        @Override
        public final int getPosOfLastBit() {
            int n = PaddedOverlayData.this.width - 1;
            while (n >= 0) {
                int n2 = PaddedOverlayData.this.data[this.lineOffset + (n >> 3)];
                if (n2 == 0) {
                    if ((n -= (n & 7) + 1) >= 0) continue;
                    return -1;
                }
                while ((n2 & 0x80) != 128) {
                    --n;
                    n2 <<= 1;
                }
                return n;
            }
            return n;
        }

        @Override
        public final byte[] getData() {
            byte[] byArray = new byte[PaddedOverlayData.this.stride];
            System.arraycopy(PaddedOverlayData.this.data, this.lineOffset, byArray, 0, PaddedOverlayData.this.stride);
            return byArray;
        }
    }
}

