/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation;

import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.interfaces.ICompositeInformationObject;
import com.agfa.pacs.listtext.dicomobject.interfaces.IImageReferencing;
import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.lut.IColorLookupTableSource;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.BitmapDisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedAreaModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayer;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayerModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayCurveActivationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlane;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlaneModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationStateIdentificationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationStateRelationship;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationStateRelationshipModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.module.ps.SoftcopyPresentationLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.SoftcopyVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.SoftcopyVOILUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.presentation.DisplayShutter;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.presentation.OverlayContainer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataFactory;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che3.data.Attributes;

public class SoftcopyPresentationStateProvider
implements IFramePresentationStateProvider {
    private static final String TEMP_IDENTIFIER = "TEMP";
    protected SoftcopyPresentationStateInformationObject softcopyPresentationState;
    private Map<String, ReferencedImage> imageMap;
    private Map<String, SoftcopyVOILUT> voiLUTMap = new HashMap<String, SoftcopyVOILUT>();
    private SoftcopyVOILUT defaultVOILUT = null;
    private Map<String, DisplayedArea> displayAreaMap = new HashMap<String, DisplayedArea>();
    private DisplayedArea defaultDisplayArea = null;
    private Map<String, List<OverlayContainer>> overlayMap;
    private IOverlayDataFactory odFact;
    private boolean temporary = false;
    private Date creationDate;

    public SoftcopyPresentationStateProvider(SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject, IOverlayDataFactory iOverlayDataFactory) {
        ReferencedSeries referencedSeries;
        DisplayedAreaModule displayedAreaModule2;
        PresentationStateRelationship presentationStateRelationship;
        this.softcopyPresentationState = softcopyPresentationStateInformationObject;
        if (softcopyPresentationStateInformationObject.getModule(PresentationStateIdentificationModule.class) != null && TEMP_IDENTIFIER.equals(((PresentationStateIdentificationModule)softcopyPresentationStateInformationObject.getModule(PresentationStateIdentificationModule.class)).getContentLabel())) {
            this.temporary = true;
        }
        this.odFact = iOverlayDataFactory;
        this.imageMap = new HashMap<String, ReferencedImage>();
        this.overlayMap = new HashMap<String, List<OverlayContainer>>();
        PresentationStateRelationshipModule presentationStateRelationshipModule = (PresentationStateRelationshipModule)this.softcopyPresentationState.getModule(PresentationStateRelationshipModule.class);
        if (presentationStateRelationshipModule != null) {
            presentationStateRelationship = presentationStateRelationshipModule.getPresentationStateRelationship();
            displayedAreaModule2 = presentationStateRelationship.referencedSeries().iterator();
            while (displayedAreaModule2.hasNext()) {
                referencedSeries = (ReferencedSeries)displayedAreaModule2.next();
                for (ReferencedImage referencedImage : referencedSeries.referencedImages().values()) {
                    this.imageMap.put(referencedImage.getSOPInstanceUID(), referencedImage);
                }
            }
        }
        presentationStateRelationship = (PresentationStateIdentificationModule)this.softcopyPresentationState.getModuleCreate(PresentationStateIdentificationModule.class);
        this.creationDate = presentationStateRelationship.getPresentationCreationDateTime();
        referencedSeries = (SoftcopyVOILUTModule)this.softcopyPresentationState.getModule(SoftcopyVOILUTModule.class);
        if (referencedSeries != null) {
            for (DisplayedAreaModule displayedAreaModule2 : referencedSeries.softcopyVOILUTs()) {
                if (displayedAreaModule2.referencedImages().isEmpty()) {
                    this.defaultVOILUT = displayedAreaModule2;
                    continue;
                }
                for (Object object : displayedAreaModule2.referencedImages().keySet()) {
                    this.voiLUTMap.put((String)object, (SoftcopyVOILUT)displayedAreaModule2);
                }
            }
        }
        if ((displayedAreaModule2 = (DisplayedAreaModule)this.softcopyPresentationState.getModule(DisplayedAreaModule.class)) != null) {
            for (ReferencedImage referencedImage : displayedAreaModule2.displayedAreas()) {
                if (referencedImage.referencedImages().isEmpty()) {
                    this.defaultDisplayArea = referencedImage;
                    continue;
                }
                for (Object object : referencedImage.referencedImages().keySet()) {
                    this.displayAreaMap.put((String)object, (DisplayedArea)referencedImage);
                }
            }
        }
    }

    @Override
    public ICompositeInformationObject getDicomInformationObject() {
        return this.softcopyPresentationState;
    }

    @Override
    public boolean hasFramePresentationState(String string, int n) {
        ReferencedImage referencedImage = this.imageMap.get(string);
        if (referencedImage == null) {
            return false;
        }
        if (n < 0) {
            return true;
        }
        return referencedImage.hasFrame(n);
    }

    public boolean hasFramePresentationState(String string, Date date) {
        if (!this.getLabel().equals(string)) {
            return false;
        }
        return this.getCreationDateTime().equals(date);
    }

    public boolean referencesSeries(String string) {
        PresentationStateRelationshipModule presentationStateRelationshipModule = (PresentationStateRelationshipModule)this.softcopyPresentationState.getModule(PresentationStateRelationshipModule.class);
        if (presentationStateRelationshipModule == null) {
            return false;
        }
        PresentationStateRelationship presentationStateRelationship = presentationStateRelationshipModule.getPresentationStateRelationship();
        for (ReferencedSeries referencedSeries : presentationStateRelationship.referencedSeries()) {
            if (!CompareUtils.equals((Object)referencedSeries.getSeriesInstanceUID(), (Object)string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFramePresentationStateCached(String string, int n) {
        return this.hasFramePresentationState(string, n);
    }

    @Override
    public IFramePresentationState getFramePresentationState(String string, Attributes attributes, int n, IPixelDataFrame<?> iPixelDataFrame) {
        FramePresentationState framePresentationState = this.getFramePresentationState(string, n);
        if (framePresentationState != null) {
            this.initShutterAndOverlays(string, attributes.getInt(2621456, 0), attributes.getInt(2621457, 0), framePresentationState, n, iPixelDataFrame);
        }
        return framePresentationState;
    }

    private FramePresentationState getFramePresentationState(String string, int n) {
        DisplayedArea displayedArea;
        ReferencedImage referencedImage;
        if (!this.hasFramePresentationState(string, n)) {
            return null;
        }
        ModalityLUTModule modalityLUTModule = (ModalityLUTModule)this.softcopyPresentationState.getModule(ModalityLUTModule.class);
        SoftcopyPresentationLUTModule softcopyPresentationLUTModule = (SoftcopyPresentationLUTModule)this.softcopyPresentationState.getModule(SoftcopyPresentationLUTModule.class);
        SpatialTransformationModule spatialTransformationModule = (SpatialTransformationModule)this.softcopyPresentationState.getModule(SpatialTransformationModule.class);
        GraphicLayerModule graphicLayerModule = (GraphicLayerModule)this.softcopyPresentationState.getModule(GraphicLayerModule.class);
        GraphicAnnotationModule graphicAnnotationModule = (GraphicAnnotationModule)this.softcopyPresentationState.getModule(GraphicAnnotationModule.class);
        PaletteColorLUTModule paletteColorLUTModule = (PaletteColorLUTModule)this.softcopyPresentationState.getModule(PaletteColorLUTModule.class);
        SoftcopyVOILUT softcopyVOILUT = this.voiLUTMap.get(string);
        if (softcopyVOILUT != null) {
            referencedImage = (ReferencedImage)softcopyVOILUT.referencedImages().get(string);
            if (referencedImage == null || !referencedImage.hasFrame(n)) {
                softcopyVOILUT = null;
            }
        } else {
            softcopyVOILUT = this.defaultVOILUT;
        }
        if ((displayedArea = this.displayAreaMap.get(string)) != null) {
            referencedImage = (ReferencedImage)displayedArea.referencedImages().get(string);
            if (referencedImage == null || !referencedImage.hasFrame(n)) {
                displayedArea = null;
            }
        } else {
            displayedArea = this.defaultDisplayArea;
        }
        FramePresentationState framePresentationState = new FramePresentationState(this.softcopyPresentationState.getSOPInstanceUID());
        if (modalityLUTModule != null) {
            framePresentationState.modalityLUT = modalityLUTModule.getModalityLUT();
        }
        if (softcopyVOILUT != null) {
            framePresentationState.voiLUT = softcopyVOILUT.getVOILUT();
        }
        framePresentationState.setForceLUT(this.softcopyPresentationState.isForcedIndexedColorLUT());
        if (softcopyPresentationLUTModule != null) {
            framePresentationState.presentationLUT = softcopyPresentationLUTModule.getPresentationLUT();
        }
        if (spatialTransformationModule != null) {
            framePresentationState.spatialTransformation = spatialTransformationModule;
        }
        if (graphicLayerModule != null) {
            framePresentationState.graphicLayers = graphicLayerModule.graphicLayers();
        }
        framePresentationState.displayedArea = displayedArea;
        if (graphicAnnotationModule != null) {
            framePresentationState.graphicAnnotations = this.getImageReferencingList(graphicAnnotationModule.graphicAnnotations(), string, n);
        }
        if (paletteColorLUTModule != null) {
            framePresentationState.paletteColorLUT = (IColorLookupTableSource)paletteColorLUTModule;
        }
        return framePresentationState;
    }

    @Override
    public String getProviderUID() {
        return this.softcopyPresentationState.getSOPInstanceUID();
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public String getFramePresentationStateUID(String string, int n) {
        return this.getProviderUID();
    }

    @Override
    public String getLabel() {
        return ((PresentationStateIdentificationModule)this.softcopyPresentationState.getModuleCreate(PresentationStateIdentificationModule.class)).getContentLabel();
    }

    @Override
    public Set<String> getReferencedInstances() {
        return this.imageMap.keySet();
    }

    @Override
    public String getDescription() {
        return ((PresentationStateIdentificationModule)this.softcopyPresentationState.getModuleCreate(PresentationStateIdentificationModule.class)).getContentDescription();
    }

    @Override
    public Date getCreationDateTime() {
        return this.creationDate;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    private void initShutterAndOverlays(String string, int n, int n2, FramePresentationState framePresentationState, int n3, IPixelDataFrame<?> iPixelDataFrame) {
        DisplayShutterModule displayShutterModule = (DisplayShutterModule)this.softcopyPresentationState.getModule(DisplayShutterModule.class);
        BitmapDisplayShutterModule bitmapDisplayShutterModule = (BitmapDisplayShutterModule)this.softcopyPresentationState.getModule(BitmapDisplayShutterModule.class);
        int n4 = -1;
        if (displayShutterModule != null) {
            if (bitmapDisplayShutterModule != null && bitmapDisplayShutterModule.getShutterOverlayGroup() != null) {
                n4 = bitmapDisplayShutterModule.getShutterOverlayGroup() - 24576;
                framePresentationState.bitmapDisplayShutterModule = bitmapDisplayShutterModule;
            } else {
                framePresentationState.shutter = new DisplayShutter(n2, n, displayShutterModule, this.odFact);
                framePresentationState.displayShutterModule = displayShutterModule;
            }
        }
        List<OverlayContainer> list = this.getOverlays(string);
        for (OverlayContainer overlayContainer : list) {
            OverlayFrame overlayFrame = overlayContainer.getOverlayFrame(n3, iPixelDataFrame, this.odFact);
            if (overlayFrame == null) continue;
            if (overlayContainer.getGroupTag() == n4) {
                overlayFrame.setShutter(true);
                framePresentationState.shutter = new DisplayShutter(overlayFrame, bitmapDisplayShutterModule);
                framePresentationState.bsdOverlayFrame = overlayFrame;
                continue;
            }
            framePresentationState.overlayFrames.add(overlayFrame);
        }
    }

    private List<OverlayContainer> getOverlays(String string) {
        OverlayPlaneModule overlayPlaneModule = (OverlayPlaneModule)this.softcopyPresentationState.getModule(OverlayPlaneModule.class);
        OverlayCurveActivationModule overlayCurveActivationModule = (OverlayCurveActivationModule)this.softcopyPresentationState.getModule(OverlayCurveActivationModule.class);
        ArrayList arrayList = new ArrayList();
        if (overlayPlaneModule != null) {
            arrayList.addAll(overlayPlaneModule.overlayPlanes());
        }
        if (!this.overlayMap.containsKey(string)) {
            ArrayList<OverlayContainer> arrayList2 = new ArrayList<OverlayContainer>();
            for (OverlayPlane overlayPlane : arrayList) {
                String string2 = overlayCurveActivationModule != null ? overlayCurveActivationModule.getOverlayActivationLayer(overlayPlane.getGroupTag()) : null;
                OverlayContainer overlayContainer = new OverlayContainer(overlayPlane, string2);
                arrayList2.add(overlayContainer);
            }
            this.overlayMap.put(string, arrayList2);
        }
        return this.overlayMap.get(string);
    }

    private boolean isReferenced(Map<String, ReferencedImage> map, String string, int n) {
        ReferencedImage referencedImage = map.get(string);
        if (referencedImage != null) {
            return referencedImage.hasFrame(n);
        }
        return map.isEmpty();
    }

    public <U extends IImageReferencing> List<U> getImageReferencingList(List<U> list, String string, int n) {
        ArrayList<IImageReferencing> arrayList = new ArrayList<IImageReferencing>();
        for (IImageReferencing iImageReferencing : list) {
            if (!this.isReferenced(iImageReferencing.referencedImages(), string, n)) continue;
            arrayList.add(iImageReferencing);
        }
        return arrayList;
    }

    @Override
    public boolean hasSpatialTransformation(String string, int n) {
        SpatialTransformationModule spatialTransformationModule = (SpatialTransformationModule)this.softcopyPresentationState.getModule(SpatialTransformationModule.class);
        if (spatialTransformationModule != null) {
            return spatialTransformationModule.hasSomeRotationFlipping();
        }
        return false;
    }

    @Override
    public boolean containsUnsavedGraphicAnnotations() {
        GraphicAnnotationModule graphicAnnotationModule = (GraphicAnnotationModule)this.softcopyPresentationState.getModule(GraphicAnnotationModule.class);
        if (graphicAnnotationModule != null) {
            for (GraphicAnnotation graphicAnnotation : graphicAnnotationModule.graphicAnnotations()) {
                if (graphicAnnotation.isSaved()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Attributes getDataset() {
        return this.softcopyPresentationState.toDataset();
    }

    private class FramePresentationState
    implements IFramePresentationState {
        private List<OverlayFrame> overlayFrames = new ArrayList<OverlayFrame>();
        private DisplayShutter shutter;
        private DisplayedArea displayedArea;
        private ModalityLUT modalityLUT;
        private PresentationLUT presentationLUT;
        private IVOILUT voiLUT;
        private List<GraphicLayer> graphicLayers = new ArrayList<GraphicLayer>();
        private List<GraphicAnnotation> graphicAnnotations = new ArrayList<GraphicAnnotation>();
        private SpatialTransformationModule spatialTransformation;
        private OverlayFrame bsdOverlayFrame;
        private DisplayShutterModule displayShutterModule;
        private BitmapDisplayShutterModule bitmapDisplayShutterModule;
        private IColorLookupTableSource paletteColorLUT;
        private String providerUID;
        private boolean forceLUT = true;

        @Override
        public boolean getForceLUT() {
            return this.forceLUT;
        }

        @Override
        public void setForceLUT(boolean bl) {
            this.forceLUT = bl;
        }

        public FramePresentationState(String string) {
            this.providerUID = string;
        }

        @Override
        public String getProviderUID() {
            return this.providerUID;
        }

        @Override
        public DisplayedArea getDisplayedArea() {
            return this.displayedArea;
        }

        @Override
        public List<GraphicAnnotation> getGraphicAnnotations() {
            return this.graphicAnnotations;
        }

        @Override
        public List<GraphicLayer> getGraphicLayers() {
            return this.graphicLayers;
        }

        @Override
        public ModalityLUT getModalityLUT() {
            return this.modalityLUT;
        }

        @Override
        public List<OverlayFrame> getOverlayFrames() {
            return this.overlayFrames;
        }

        @Override
        public PresentationLUT getPresentationLUT() {
            return this.presentationLUT;
        }

        @Override
        public DisplayShutter getDisplayShutter() {
            return this.shutter;
        }

        @Override
        public SpatialTransformationModule getSpatialTransformation() {
            return this.spatialTransformation;
        }

        @Override
        public IVOILUT getVOILUT() {
            return this.voiLUT;
        }

        @Override
        public void setVOILUT(IVOILUT iVOILUT) {
            this.voiLUT = iVOILUT;
        }

        @Override
        public IVOILUT getVOILUT(IHistogramProvider iHistogramProvider) {
            return this.getVOILUT();
        }

        @Override
        public boolean isExternal() {
            return true;
        }

        @Override
        public boolean isTemporary() {
            return SoftcopyPresentationStateProvider.this.temporary;
        }

        @Override
        public OverlayFrame getBitmapDisplayShutterOverlayFrame() {
            return this.bsdOverlayFrame;
        }

        @Override
        public BitmapDisplayShutterModule getBitmapDisplayShutterModule() {
            return this.bitmapDisplayShutterModule;
        }

        @Override
        public DisplayShutterModule getDisplayShutterModule() {
            return this.displayShutterModule;
        }

        @Override
        public IColorLookupTableSource getPaletteColorLUT() {
            return this.paletteColorLUT;
        }

        @Override
        public String getLabel() {
            return SoftcopyPresentationStateProvider.this.getLabel();
        }
    }
}

